/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.owner;

import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.FuelAbility;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.CapabilityEnergy;
import org.jetbrains.annotations.NotNull;

public class TileEntityFuelAbility<T extends BlockEntity>
extends FuelAbility<BlockEntityPeripheralOwner<T>> {
    public TileEntityFuelAbility(@NotNull BlockEntityPeripheralOwner<T> owner) {
        super(owner);
    }

    @Override
    protected boolean consumeFuel(int count) {
        return ((BlockEntityPeripheralOwner)this.owner).tileEntity.getCapability(CapabilityEnergy.ENERGY).map(storage -> {
            int energyCount = count * (Integer)APConfig.METAPHYSICS_CONFIG.energyToFuelRate.get();
            int extractedCount = storage.extractEnergy(energyCount, true);
            if (extractedCount == energyCount) {
                storage.extractEnergy(energyCount, false);
                return true;
            }
            return false;
        }).orElse(false);
    }

    @Override
    protected int getMaxFuelConsumptionRate() {
        return 1;
    }

    @Override
    public boolean isFuelConsumptionDisable() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enablePoweredPeripherals.get() == false;
    }

    @Override
    public int getFuelCount() {
        return ((BlockEntityPeripheralOwner)this.owner).tileEntity.getCapability(CapabilityEnergy.ENERGY).map(storage -> storage.getEnergyStored() / (Integer)APConfig.METAPHYSICS_CONFIG.energyToFuelRate.get()).orElse(0);
    }

    @Override
    public int getFuelMaxCount() {
        return ((BlockEntityPeripheralOwner)this.owner).tileEntity.getCapability(CapabilityEnergy.ENERGY).map(storage -> storage.getMaxEnergyStored() / (Integer)APConfig.METAPHYSICS_CONFIG.energyToFuelRate.get()).orElse(0);
    }

    @Override
    public void addFuel(int count) {
        ((BlockEntityPeripheralOwner)this.owner).tileEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(storage -> {
            int energyCount = count * (Integer)APConfig.METAPHYSICS_CONFIG.energyToFuelRate.get();
            storage.receiveEnergy(energyCount, false);
        });
    }
}

