/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.world;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;
import vectorwing.farmersdelight.common.registry.ModBiomeFeatures;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.world.configuration.WildCropConfiguration;

public class WildCropGeneration {
    public static Holder<ConfiguredFeature<WildCropConfiguration, ?>> FEATURE_PATCH_WILD_CABBAGES;
    public static Holder<ConfiguredFeature<WildCropConfiguration, ?>> FEATURE_PATCH_WILD_ONIONS;
    public static Holder<ConfiguredFeature<WildCropConfiguration, ?>> FEATURE_PATCH_WILD_TOMATOES;
    public static Holder<ConfiguredFeature<WildCropConfiguration, ?>> FEATURE_PATCH_WILD_CARROTS;
    public static Holder<ConfiguredFeature<WildCropConfiguration, ?>> FEATURE_PATCH_WILD_POTATOES;
    public static Holder<ConfiguredFeature<WildCropConfiguration, ?>> FEATURE_PATCH_WILD_BEETROOTS;
    public static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> FEATURE_PATCH_WILD_RICE;
    public static Holder<ConfiguredFeature<WildCropConfiguration, ?>> FEATURE_PATCH_BROWN_MUSHROOM_COLONIES;
    public static Holder<ConfiguredFeature<WildCropConfiguration, ?>> FEATURE_PATCH_RED_MUSHROOM_COLONIES;
    public static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> FEATURE_PATCH_SANDY_SHRUB_BONEMEAL;
    public static Holder<PlacedFeature> PATCH_WILD_CABBAGES;
    public static Holder<PlacedFeature> PATCH_WILD_ONIONS;
    public static Holder<PlacedFeature> PATCH_WILD_TOMATOES;
    public static Holder<PlacedFeature> PATCH_WILD_CARROTS;
    public static Holder<PlacedFeature> PATCH_WILD_POTATOES;
    public static Holder<PlacedFeature> PATCH_WILD_BEETROOTS;
    public static Holder<PlacedFeature> PATCH_WILD_RICE;
    public static Holder<PlacedFeature> PATCH_BROWN_MUSHROOM_COLONIES;
    public static Holder<PlacedFeature> PATCH_RED_MUSHROOM_COLONIES;
    public static final BlockPos BLOCK_BELOW;
    public static final BlockPos BLOCK_ABOVE;

    public static void registerWildCropGeneration() {
        FEATURE_PATCH_WILD_CABBAGES = WildCropGeneration.register(new ResourceLocation("farmersdelight", "patch_wild_cabbages"), (Feature)ModBiomeFeatures.WILD_CROP.get(), WildCropGeneration.wildCropConfig((Block)ModBlocks.WILD_CABBAGES.get(), (Block)ModBlocks.SANDY_SHRUB.get(), BlockPredicate.m_204679_((TagKey)BlockTags.f_13029_, (Vec3i)BLOCK_BELOW)));
        FEATURE_PATCH_WILD_ONIONS = WildCropGeneration.register(new ResourceLocation("farmersdelight", "patch_wild_onions"), (Feature)ModBiomeFeatures.WILD_CROP.get(), WildCropGeneration.wildCropConfig((Block)ModBlocks.WILD_ONIONS.get(), Blocks.f_50114_, BlockPredicate.m_204679_((TagKey)BlockTags.f_144274_, (Vec3i)BLOCK_BELOW)));
        FEATURE_PATCH_WILD_TOMATOES = WildCropGeneration.register(new ResourceLocation("farmersdelight", "patch_wild_tomatoes"), (Feature)ModBiomeFeatures.WILD_CROP.get(), WildCropGeneration.wildCropConfig((Block)ModBlocks.WILD_TOMATOES.get(), Blocks.f_50036_, BlockPredicate.m_204679_(ModTags.TERRAIN, (Vec3i)BLOCK_BELOW)));
        FEATURE_PATCH_WILD_CARROTS = WildCropGeneration.register(new ResourceLocation("farmersdelight", "patch_wild_carrots"), (Feature)ModBiomeFeatures.WILD_CROP.get(), WildCropGeneration.wildCropWithFloorConfig((Block)ModBlocks.WILD_CARROTS.get(), Blocks.f_50034_, BlockPredicate.m_204679_((TagKey)BlockTags.f_144274_, (Vec3i)BLOCK_BELOW), Blocks.f_50546_, BlockPredicate.m_204677_((TagKey)BlockTags.f_144274_)));
        FEATURE_PATCH_WILD_POTATOES = WildCropGeneration.register(new ResourceLocation("farmersdelight", "patch_wild_potatoes"), (Feature)ModBiomeFeatures.WILD_CROP.get(), WildCropGeneration.wildCropConfig((Block)ModBlocks.WILD_POTATOES.get(), Blocks.f_50035_, BlockPredicate.m_204679_((TagKey)BlockTags.f_144274_, (Vec3i)BLOCK_BELOW)));
        FEATURE_PATCH_WILD_BEETROOTS = WildCropGeneration.register(new ResourceLocation("farmersdelight", "patch_wild_beetroots"), (Feature)ModBiomeFeatures.WILD_CROP.get(), WildCropGeneration.wildCropConfig((Block)ModBlocks.WILD_BEETROOTS.get(), (Block)ModBlocks.SANDY_SHRUB.get(), BlockPredicate.m_204679_((TagKey)BlockTags.f_13029_, (Vec3i)BLOCK_BELOW)));
        FEATURE_PATCH_WILD_RICE = WildCropGeneration.register(new ResourceLocation("farmersdelight", "patch_wild_rice"), (Feature)ModBiomeFeatures.WILD_RICE.get(), FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.WILD_RICE.get()))), List.of(Blocks.f_50493_)));
        FEATURE_PATCH_BROWN_MUSHROOM_COLONIES = WildCropGeneration.register(new ResourceLocation("farmersdelight", "patch_brown_mushroom_colonies"), (Feature)ModBiomeFeatures.WILD_CROP.get(), WildCropGeneration.mushroomColonyConfig((Block)ModBlocks.BROWN_MUSHROOM_COLONY.get(), Blocks.f_50072_, BlockPredicate.m_190396_((Block)Blocks.f_50195_, (Vec3i)BLOCK_BELOW)));
        FEATURE_PATCH_RED_MUSHROOM_COLONIES = WildCropGeneration.register(new ResourceLocation("farmersdelight", "patch_red_mushroom_colonies"), (Feature)ModBiomeFeatures.WILD_CROP.get(), WildCropGeneration.mushroomColonyConfig((Block)ModBlocks.RED_MUSHROOM_COLONY.get(), Blocks.f_50073_, BlockPredicate.m_190396_((Block)Blocks.f_50195_, (Vec3i)BLOCK_BELOW)));
        FEATURE_PATCH_SANDY_SHRUB_BONEMEAL = WildCropGeneration.register(new ResourceLocation("farmersdelight", "patch_sandy_shrub"), Feature.f_65763_, WildCropGeneration.randomPatchConfig((Block)ModBlocks.SANDY_SHRUB.get(), 32, 2, BlockPredicate.m_204679_((TagKey)BlockTags.f_13029_, (Vec3i)BLOCK_BELOW)));
        PATCH_WILD_CABBAGES = WildCropGeneration.registerPlacement(new ResourceLocation("farmersdelight", "patch_wild_cabbages"), FEATURE_PATCH_WILD_CABBAGES, new PlacementModifier[]{RarityFilter.m_191900_((int)((Integer)Configuration.CHANCE_WILD_CABBAGES.get())), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        PATCH_WILD_ONIONS = WildCropGeneration.registerPlacement(new ResourceLocation("farmersdelight", "patch_wild_onions"), FEATURE_PATCH_WILD_ONIONS, new PlacementModifier[]{RarityFilter.m_191900_((int)((Integer)Configuration.CHANCE_WILD_ONIONS.get())), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        PATCH_WILD_TOMATOES = WildCropGeneration.registerPlacement(new ResourceLocation("farmersdelight", "patch_wild_tomatoes"), FEATURE_PATCH_WILD_TOMATOES, new PlacementModifier[]{RarityFilter.m_191900_((int)((Integer)Configuration.CHANCE_WILD_TOMATOES.get())), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        PATCH_WILD_CARROTS = WildCropGeneration.registerPlacement(new ResourceLocation("farmersdelight", "patch_wild_carrots"), FEATURE_PATCH_WILD_CARROTS, new PlacementModifier[]{RarityFilter.m_191900_((int)((Integer)Configuration.CHANCE_WILD_CARROTS.get())), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        PATCH_WILD_POTATOES = WildCropGeneration.registerPlacement(new ResourceLocation("farmersdelight", "patch_wild_potatoes"), FEATURE_PATCH_WILD_POTATOES, new PlacementModifier[]{RarityFilter.m_191900_((int)((Integer)Configuration.CHANCE_WILD_POTATOES.get())), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        PATCH_WILD_BEETROOTS = WildCropGeneration.registerPlacement(new ResourceLocation("farmersdelight", "patch_wild_beetroots"), FEATURE_PATCH_WILD_BEETROOTS, new PlacementModifier[]{RarityFilter.m_191900_((int)((Integer)Configuration.CHANCE_WILD_BEETROOTS.get())), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        PATCH_WILD_RICE = WildCropGeneration.registerPlacement(new ResourceLocation("farmersdelight", "patch_wild_rice"), FEATURE_PATCH_WILD_RICE, new PlacementModifier[]{RarityFilter.m_191900_((int)((Integer)Configuration.CHANCE_WILD_RICE.get())), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        PATCH_BROWN_MUSHROOM_COLONIES = WildCropGeneration.registerPlacement(new ResourceLocation("farmersdelight", "patch_brown_mushroom_colonies"), FEATURE_PATCH_BROWN_MUSHROOM_COLONIES, new PlacementModifier[]{RarityFilter.m_191900_((int)((Integer)Configuration.CHANCE_BROWN_MUSHROOM_COLONIES.get())), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        PATCH_RED_MUSHROOM_COLONIES = WildCropGeneration.registerPlacement(new ResourceLocation("farmersdelight", "patch_red_mushroom_colonies"), FEATURE_PATCH_RED_MUSHROOM_COLONIES, new PlacementModifier[]{RarityFilter.m_191900_((int)((Integer)Configuration.CHANCE_RED_MUSHROOM_COLONIES.get())), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
    }

    public static RandomPatchConfiguration randomPatchConfig(Block block, int tries, int xzSpread, BlockPredicate plantedOn) {
        return new RandomPatchConfiguration(tries, xzSpread, 3, PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)block)), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.f_190393_, (BlockPredicate)plantedOn)));
    }

    public static WildCropConfiguration wildCropConfig(Block primaryBlock, Block secondaryBlock, BlockPredicate plantedOn) {
        return new WildCropConfiguration(64, 6, 3, WildCropGeneration.plantBlockConfig(primaryBlock, plantedOn), WildCropGeneration.plantBlockConfig(secondaryBlock, plantedOn), null);
    }

    public static WildCropConfiguration wildCropWithFloorConfig(Block primaryBlock, Block secondaryBlock, BlockPredicate plantedOn, Block floorBlock, BlockPredicate replaces) {
        return new WildCropConfiguration(64, 6, 3, WildCropGeneration.plantBlockConfig(primaryBlock, plantedOn), WildCropGeneration.plantBlockConfig(secondaryBlock, plantedOn), WildCropGeneration.floorBlockConfig(floorBlock, replaces));
    }

    public static WildCropConfiguration mushroomColonyConfig(Block colonyBlock, Block secondaryBlock, BlockPredicate plantedOn) {
        return new WildCropConfiguration(64, 6, 3, WildCropGeneration.colonyBlockConfig(colonyBlock, plantedOn), WildCropGeneration.plantBlockConfig(secondaryBlock, plantedOn), null);
    }

    public static Holder<PlacedFeature> plantBlockConfig(Block block, BlockPredicate plantedOn) {
        return PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)block)), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.f_190393_, (BlockPredicate)plantedOn));
    }

    public static Holder<PlacedFeature> colonyBlockConfig(Block block, BlockPredicate plantedOn) {
        return PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.m_191382_((Block)block), MushroomColonyBlock.COLONY_AGE, (IntProvider)UniformInt.m_146622_((int)0, (int)3))), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.f_190393_, (BlockPredicate)plantedOn));
    }

    public static Holder<PlacedFeature> floorBlockConfig(Block block, BlockPredicate replaces) {
        return PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)block)), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.m_190410_((Vec3i)BLOCK_ABOVE), (BlockPredicate)replaces));
    }

    static Holder<PlacedFeature> registerPlacement(ResourceLocation id, Holder<? extends ConfiguredFeature<?, ?>> feature, PlacementModifier ... modifiers) {
        return BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)id, (Object)new PlacedFeature(Holder.m_205706_(feature), List.of(modifiers)));
    }

    protected static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<FC, ?>> register(ResourceLocation id, F feature, FC featureConfig) {
        return WildCropGeneration.register(BuiltinRegistries.f_123861_, id, new ConfiguredFeature(feature, featureConfig));
    }

    private static <V extends T, T> Holder<V> register(Registry<T> registry, ResourceLocation id, V value) {
        return BuiltinRegistries.m_206388_(registry, (ResourceLocation)id, value);
    }

    static {
        BLOCK_BELOW = new BlockPos(0, -1, 0);
        BLOCK_ABOVE = new BlockPos(0, 1, 0);
    }
}

