/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Random;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.common.Configuration;

public class ChanceResult {
    public static final ChanceResult EMPTY = new ChanceResult(ItemStack.f_41583_, 1.0f);
    private final ItemStack stack;
    private final float chance;

    public ChanceResult(ItemStack stack, float chance) {
        this.stack = stack;
        this.chance = chance;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack rollOutput(Random rand, int fortuneLevel) {
        int outputAmount = this.stack.m_41613_();
        double fortuneBonus = (Double)Configuration.CUTTING_BOARD_FORTUNE_BONUS.get() * (double)fortuneLevel;
        for (int roll = 0; roll < this.stack.m_41613_(); ++roll) {
            if (!((double)rand.nextFloat() > (double)this.chance + fortuneBonus)) continue;
            --outputAmount;
        }
        if (outputAmount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack out = this.stack.m_41777_();
        out.m_41764_(outputAmount);
        return out;
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        ResourceLocation resourceLocation = this.stack.m_41720_().getRegistryName();
        json.addProperty("item", resourceLocation.toString());
        int count = this.stack.m_41613_();
        if (count != 1) {
            json.addProperty("count", (Number)count);
        }
        if (this.stack.m_41782_()) {
            json.add("nbt", new JsonParser().parse(this.stack.m_41783_().toString()));
        }
        if (this.chance != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(this.chance));
        }
        return json;
    }

    public static ChanceResult deserialize(JsonElement je) {
        if (!je.isJsonObject()) {
            throw new JsonSyntaxException("Must be a json object");
        }
        JsonObject json = je.getAsJsonObject();
        String itemId = GsonHelper.m_13906_((JsonObject)json, (String)"item");
        int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
        float chance = GsonHelper.m_13820_((JsonObject)json, (String)"chance", (float)1.0f);
        ItemStack itemstack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), count);
        if (GsonHelper.m_13894_((JsonObject)json, (String)"nbt")) {
            try {
                JsonElement element = json.get("nbt");
                itemstack.m_41751_(TagParser.m_129359_((String)(element.isJsonObject() ? FarmersDelight.GSON.toJson(element) : GsonHelper.m_13805_((JsonElement)element, (String)"nbt"))));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return new ChanceResult(itemstack, chance);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130055_(this.getStack());
        buf.writeFloat(this.getChance());
    }

    public static ChanceResult read(FriendlyByteBuf buf) {
        return new ChanceResult(buf.m_130267_(), buf.readFloat());
    }
}

