/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.block.state.properties.Property;
import vectorwing.farmersdelight.common.block.CuttingBoardBlock;
import vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity;
import vectorwing.farmersdelight.common.tag.ModTags;

public class CuttingBoardRenderer
implements BlockEntityRenderer<CuttingBoardBlockEntity> {
    public CuttingBoardRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public void render(CuttingBoardBlockEntity cuttingBoardEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction direction = ((Direction)cuttingBoardEntity.m_58900_().m_61143_((Property)CuttingBoardBlock.FACING)).m_122424_();
        ItemStack boardStack = cuttingBoardEntity.getStoredItem();
        int posLong = (int)cuttingBoardEntity.m_58899_().m_121878_();
        if (!boardStack.m_41619_()) {
            poseStack.m_85836_();
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            boolean isBlockItem = itemRenderer.m_174264_(boardStack, cuttingBoardEntity.m_58904_(), null, 0).m_7539_();
            if (cuttingBoardEntity.isItemCarvingBoard()) {
                this.renderItemCarved(poseStack, direction, boardStack);
            } else if (isBlockItem && !boardStack.m_204117_(ModTags.FLAT_ON_CUTTING_BOARD)) {
                this.renderBlock(poseStack, direction);
            } else {
                this.renderItemLayingDown(poseStack, direction);
            }
            Minecraft.m_91087_().m_91291_().m_174269_(boardStack, ItemTransforms.TransformType.FIXED, combinedLight, combinedOverlay, poseStack, buffer, posLong);
            poseStack.m_85849_();
        }
    }

    public void renderItemLayingDown(PoseStack matrixStackIn, Direction direction) {
        matrixStackIn.m_85837_(0.5, 0.08, 0.5);
        float f = -direction.m_122435_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f));
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStackIn.m_85841_(0.6f, 0.6f, 0.6f);
    }

    public void renderBlock(PoseStack matrixStackIn, Direction direction) {
        matrixStackIn.m_85837_(0.5, 0.27, 0.5);
        float f = -direction.m_122435_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f));
        matrixStackIn.m_85841_(0.8f, 0.8f, 0.8f);
    }

    public void renderItemCarved(PoseStack matrixStackIn, Direction direction, ItemStack itemStack) {
        matrixStackIn.m_85837_(0.5, 0.23, 0.5);
        float f = -direction.m_122435_() + 180.0f;
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f));
        Item toolItem = itemStack.m_41720_();
        float poseAngle = toolItem instanceof PickaxeItem || toolItem instanceof HoeItem ? 225.0f : (toolItem instanceof TridentItem ? 135.0f : 180.0f);
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(poseAngle));
        matrixStackIn.m_85841_(0.6f, 0.6f, 0.6f);
    }
}

