/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModEffects;

@OnlyIn(value=Dist.CLIENT)
public class NourishmentHungerOverlay {
    public static int foodIconsOffset;
    private static final ResourceLocation MOD_ICONS_TEXTURE;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new NourishmentHungerOverlay());
    }

    @SubscribeEvent
    public void onRenderGuiOverlayPost(RenderGameOverlayEvent.PostLayer event) {
        if (event.getOverlay() == ForgeIngameGui.FOOD_LEVEL_ELEMENT) {
            boolean isMounted;
            Minecraft mc = Minecraft.m_91087_();
            ForgeIngameGui gui = (ForgeIngameGui)mc.f_91065_;
            boolean bl = isMounted = mc.f_91074_ != null && mc.f_91074_.m_20202_() instanceof LivingEntity;
            if (!isMounted && !mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                NourishmentHungerOverlay.renderNourishmentOverlay(gui, event.getMatrixStack());
            }
        }
    }

    public static void renderNourishmentOverlay(ForgeIngameGui gui, PoseStack poseStack) {
        boolean isPlayerHealingWithSaturation;
        if (!((Boolean)Configuration.NOURISHED_HUNGER_OVERLAY.get()).booleanValue()) {
            return;
        }
        foodIconsOffset = gui.right_height;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        FoodData stats = player.m_36324_();
        int top = minecraft.m_91268_().m_85446_() - foodIconsOffset + 10;
        int left = minecraft.m_91268_().m_85445_() / 2 + 91;
        boolean bl = isPlayerHealingWithSaturation = player.f_19853_.m_46469_().m_46207_(GameRules.f_46139_) && player.m_36325_() && stats.m_38702_() >= 18;
        if (player.m_21124_((MobEffect)ModEffects.NOURISHMENT.get()) != null) {
            NourishmentHungerOverlay.drawNourishmentOverlay(stats, minecraft, poseStack, left, top, isPlayerHealingWithSaturation);
        }
    }

    public static void drawNourishmentOverlay(FoodData stats, Minecraft mc, PoseStack matrixStack, int left, int top, boolean naturalHealing) {
        float saturation = stats.m_38722_();
        int foodLevel = stats.m_38702_();
        int ticks = mc.f_91065_.m_93079_();
        Random rand = new Random();
        rand.setSeed((long)ticks * 312871L);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MOD_ICONS_TEXTURE);
        RenderSystem.m_69478_();
        for (int j = 0; j < 10; ++j) {
            int naturalHealingOffset;
            int x = left - j * 8 - 9;
            int y = top;
            if (saturation <= 0.0f && ticks % (foodLevel * 3 + 1) == 0) {
                y = top + (rand.nextInt(3) - 1);
            }
            mc.f_91065_.m_93228_(matrixStack, x, y, 0, 0, 9, 9);
            float effectiveHungerOfBar = (float)stats.m_38702_() / 2.0f - (float)j;
            int n = naturalHealingOffset = naturalHealing ? 18 : 0;
            if (effectiveHungerOfBar >= 1.0f) {
                mc.f_91065_.m_93228_(matrixStack, x, y, 18 + naturalHealingOffset, 0, 9, 9);
                continue;
            }
            if (!((double)effectiveHungerOfBar >= 0.5)) continue;
            mc.f_91065_.m_93228_(matrixStack, x, y, 9 + naturalHealingOffset, 0, 9, 9);
        }
        RenderSystem.m_69461_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }

    static {
        MOD_ICONS_TEXTURE = new ResourceLocation("farmersdelight", "textures/gui/fd_icons.png");
    }
}

