/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.event;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.client.model.SkilletModel;
import vectorwing.farmersdelight.client.particle.StarParticle;
import vectorwing.farmersdelight.client.particle.SteamParticle;
import vectorwing.farmersdelight.client.renderer.CanvasSignRenderer;
import vectorwing.farmersdelight.client.renderer.CuttingBoardRenderer;
import vectorwing.farmersdelight.client.renderer.SkilletRenderer;
import vectorwing.farmersdelight.client.renderer.StoveRenderer;
import vectorwing.farmersdelight.common.registry.ModAtlases;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModEntityTypes;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;

@Mod.EventBusSubscriber(modid="farmersdelight", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetupEvents {
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_BOWL = new ResourceLocation("farmersdelight", "item/empty_container_slot_bowl");

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        ForgeModelBakery.addSpecialModel((ResourceLocation)new ModelResourceLocation(new ResourceLocation("farmersdelight", "skillet_cooking"), "inventory"));
    }

    @SubscribeEvent
    public static void onEntityRendererRegister(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntityTypes.ROTTEN_TOMATO.get(), ThrownItemRenderer::new);
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        ModelResourceLocation skilletLocation = new ModelResourceLocation(new ResourceLocation("farmersdelight", "skillet"), "inventory");
        BakedModel skilletModel = (BakedModel)modelRegistry.get(skilletLocation);
        ModelResourceLocation skilletCookingLocation = new ModelResourceLocation(new ResourceLocation("farmersdelight", "skillet_cooking"), "inventory");
        BakedModel skilletCookingModel = (BakedModel)modelRegistry.get(skilletCookingLocation);
        modelRegistry.put(skilletLocation, new SkilletModel((ModelBakery)event.getModelLoader(), skilletModel, skilletCookingModel));
    }

    @SubscribeEvent
    public static void onStitchEvent(TextureStitchEvent.Pre event) {
        ResourceLocation stitching = event.getAtlas().m_118330_();
        if (stitching.equals((Object)new ResourceLocation("textures/atlas/signs.png"))) {
            event.addSprite(ModAtlases.BLANK_CANVAS_SIGN_MATERIAL.m_119203_());
            for (Material material : ModAtlases.DYED_CANVAS_SIGN_MATERIALS.values()) {
                event.addSprite(material.m_119203_());
            }
        }
        if (!stitching.equals((Object)TextureAtlas.f_118259_)) {
            return;
        }
        event.addSprite(EMPTY_CONTAINER_SLOT_BOWL);
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.STOVE.get(), StoveRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.CUTTING_BOARD.get(), CuttingBoardRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.CANVAS_SIGN.get(), CanvasSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.SKILLET.get(), SkilletRenderer::new);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerParticles(ParticleFactoryRegisterEvent event) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticleTypes.STAR.get(), StarParticle.Factory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticleTypes.STEAM.get(), SteamParticle.Factory::new);
    }
}

