/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.cfg.entries;

import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import org.zeith.hammerlib.util.cfg.ConfigEntrySerializer;
import org.zeith.hammerlib.util.cfg.ConfigFile;
import org.zeith.hammerlib.util.cfg.ReaderHelper;
import org.zeith.hammerlib.util.cfg.entries.ConfigEntryStringArray;

public final class ConfigSerializerStringArray
extends ConfigEntrySerializer<ConfigEntryStringArray> {
    public ConfigSerializerStringArray() {
        super("SA");
    }

    @Override
    public void write(ConfigFile config, BufferedWriter writer, ConfigEntryStringArray entry, int indents) throws IOException {
        if (entry.getDescription() != null) {
            ArrayList<CallSite> strings = new ArrayList<CallSite>();
            String[] stringArray = entry.initialValue;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String k = stringArray[i];
                strings.add((CallSite)((Object)("\"" + k + "\"")));
            }
            this.writeComment(writer, entry.getDescription() + " (Default: " + strings + ")", indents);
        }
        this.writeIndents(writer, indents);
        writer.write("+" + this.type + ":" + entry.getSerializedName() + "=[\n");
        for (String e : entry.value) {
            int i = 0;
            for (String s : e.split("\n")) {
                this.writeIndents(writer, indents + (i < 1 ? 2 : 0));
                writer.write(s + "\n");
                ++i;
            }
        }
        this.writeIndents(writer, indents);
        writer.write("]\n\n");
    }

    @Override
    public ConfigEntryStringArray read(ConfigFile config, ReaderHelper reader, int indents) throws IOException {
        ConfigEntryStringArray cat = new ConfigEntryStringArray(config, null);
        reader.until('+', true);
        if (reader.eat(this.type, true) && reader.eat(':', true)) {
            String name = reader.until('=', true);
            if (reader.eat('[', true)) {
                cat.name = name;
                char[] ics = new char[indents + 2];
                Arrays.fill(ics, ' ');
                ics[0] = 10;
                ics[indents + 1] = 93;
                String sub = reader.getRest();
                sub = sub.substring(0, sub.indexOf("\n]"));
                while (sub.startsWith("\n") || sub.startsWith(" ")) {
                    sub = sub.substring(1);
                }
                int il = sub.length();
                cat.value = sub.split("\n  ");
                reader.pop(reader.push() + il);
            }
        }
        return cat;
    }
}

