/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.cfg.entries;

import java.util.Objects;
import org.zeith.hammerlib.util.cfg.ConfigEntrySerializer;
import org.zeith.hammerlib.util.cfg.ConfigFile;
import org.zeith.hammerlib.util.cfg.IConfigEntry;

public class ConfigEntryDouble
implements IConfigEntry {
    final ConfigFile cfg;
    public double min = Double.MIN_VALUE;
    public double max = Double.MAX_VALUE;
    String description;
    String name;
    Double value;
    Double initialValue;

    public ConfigEntryDouble(ConfigFile cfg, Double initialValue) {
        this.value = initialValue;
        this.initialValue = initialValue;
        this.cfg = cfg;
    }

    public ConfigEntryDouble setDescription(String description) {
        this.description = description;
        return this;
    }

    public ConfigEntryDouble setMinValue(double min) {
        if (Double.isNaN(min)) {
            return this;
        }
        this.min = min;
        if (this.value != null) {
            this.value = Math.max(min, Math.min(this.max, this.value));
        }
        return this;
    }

    public ConfigEntryDouble setMaxValue(double max) {
        if (Double.isNaN(max)) {
            return this;
        }
        this.max = max;
        if (this.value != null) {
            this.value = Math.max(this.min, Math.min(max, this.value));
        }
        return this;
    }

    public ConfigEntryDouble setName(String name) {
        if (!Objects.equals(name, this.name)) {
            this.name = name;
            this.cfg.markChanged();
        }
        return this;
    }

    public ConfigEntryDouble setValue(Double value) {
        if (value != null) {
            value = Math.max(this.min, Math.min(this.max, value));
        }
        if (!Objects.equals(value, this.value)) {
            this.value = value;
            this.cfg.markChanged();
        }
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Double getValue() {
        if (this.value == null) {
            this.setValue(this.initialValue);
        }
        return this.value;
    }

    @Override
    public ConfigEntrySerializer<?> getSerializer() {
        return ConfigFile.SERIALIZER_DOUBLE;
    }
}

