/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyItemStack
implements IProperty<ItemStack> {
    final DirectStorage<ItemStack> value;
    boolean changed;
    PropertyDispatcher dispatcher;

    public PropertyItemStack(DirectStorage<ItemStack> value) {
        this.value = value;
    }

    public PropertyItemStack() {
        this(DirectStorage.allocate(ItemStack.f_41583_));
    }

    public static boolean itemsEqual(ItemStack a, ItemStack b) {
        return ItemStack.m_41728_((ItemStack)a, (ItemStack)b);
    }

    @Override
    public Class<ItemStack> getType() {
        return ItemStack.class;
    }

    @Override
    public ItemStack set(ItemStack value) {
        ItemStack pv = this.value.get();
        if (!PropertyItemStack.itemsEqual(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        ItemStack value = this.value.get();
        buf.writeItemStack(value, false);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.value.set(buf.m_130267_());
    }

    @Override
    public ItemStack get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

