/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyDouble
implements IProperty<Double> {
    final DirectStorage<Double> value;
    boolean changed;
    PropertyDispatcher dispatcher;

    public PropertyDouble(DirectStorage<Double> value) {
        this.value = value;
    }

    public PropertyDouble() {
        this(DirectStorage.allocate(0.0));
    }

    @Override
    public Class<Double> getType() {
        return Double.class;
    }

    @Override
    public Double set(Double value) {
        Double pv = this.value.get();
        if (!Objects.equals(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeDouble(this.value.get().doubleValue());
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.value.set(buf.readDouble());
    }

    @Override
    public Double get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

