/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import org.zeith.hammerlib.net.packets.SendPropertiesPacket;
import org.zeith.hammerlib.net.properties.IProperty;

public class PropertyDispatcher {
    public final BiMap<String, IProperty<?>> properties = HashBiMap.create();
    public final BiMap<IProperty<?>, String> propertiesInverse = this.properties.inverse();
    public final Map<String, IProperty<?>> dirty = new HashMap();
    public final Runnable onDirty;

    public PropertyDispatcher(Runnable onDirty) {
        this.onDirty = onDirty;
    }

    public <T> IProperty<T> registerProperty(String id, IProperty<T> property) {
        if (((String)id).startsWith("!")) {
            id = "." + ((String)id).substring(1);
        }
        this.properties.put(id, property);
        property.setDispatcher(this);
        return property;
    }

    public IProperty<?> getProperty(String id) {
        if (((String)id).startsWith("!")) {
            id = "." + ((String)id).substring(1);
        }
        return (IProperty)this.properties.get(id);
    }

    public void decodeChanges(FriendlyByteBuf buf) {
        String str;
        while ("!".compareTo(str = buf.m_130277_()) != 0) {
            IProperty prop = (IProperty)this.properties.get((Object)str);
            if (prop == null) continue;
            prop.read(buf);
        }
    }

    public void notifyOfChange(IProperty<?> prop) {
        String id = (String)this.propertiesInverse.get(prop);
        if (prop.hasChanged()) {
            this.dirty.put(id, prop);
            if (this.onDirty != null) {
                this.onDirty.run();
            }
        }
    }

    @Nullable
    public SendPropertiesPacket detectAndGenerateChanges(BlockPos pos, boolean cleanse) {
        ByteBuf bb = Unpooled.buffer();
        FriendlyByteBuf buf = new FriendlyByteBuf(bb);
        if (!this.dirty.isEmpty()) {
            this.dirty.forEach((id, prop) -> {
                if (prop.hasChanged()) {
                    buf.m_130070_(id);
                    prop.write(buf);
                    if (cleanse) {
                        prop.markChanged(false);
                    }
                }
            });
            if (cleanse) {
                this.dirty.clear();
            }
        }
        buf.m_130070_("!");
        int size = bb.writerIndex();
        if (size > 0) {
            bb.readerIndex(0);
            byte[] data = new byte[size];
            bb.readBytes(data);
            return new SendPropertiesPacket(pos.m_121878_(), data);
        }
        return null;
    }
}

