/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.recipe;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraftforge.eventbus.api.GenericEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BuildTagsEvent<T extends IForgeRegistryEntry<T>>
extends GenericEvent<T> {
    public final String directory;
    public final Map<ResourceLocation, Tag.Builder> tags;
    private final Map<ResourceLocation, SubTag> builders = new HashMap<ResourceLocation, SubTag>();
    public final ForgeRegistry<T> reg;

    public BuildTagsEvent(ForgeRegistry<T> reg, String directory, Map<ResourceLocation, Tag.Builder> tags) {
        super(reg.getRegistrySuperType());
        this.reg = reg;
        this.directory = directory;
        this.tags = tags;
    }

    public void addToTag(TagKey<T> key, T value) {
        if (this.reg.containsKey(value.getRegistryName())) {
            this.getSubTag(key.f_203868_()).add(value);
        }
    }

    public void addAllToTag(TagKey<T> key, Iterable<T> value) {
        SubTag<T> s = this.getSubTag(key.f_203868_());
        value.forEach(i -> {
            if (this.reg.containsKey(i.getRegistryName())) {
                s.add(i);
            }
        });
    }

    public String toString() {
        return "BuildTagsEvent<" + ((Class)this.getGenericType()).getSimpleName() + ">{directory=" + this.directory + "}";
    }

    public SubTag<T> getSubTag(ResourceLocation loc) {
        return this.builders.computeIfAbsent(loc, l -> {
            Tag.Builder builder = this.tags.get(l);
            return new SubTag<IForgeRegistryEntry>((ResourceLocation)l, e -> builder.m_13327_(e.getRegistryName(), "HammerLib"), e -> builder.removeElement(e.getRegistryName(), "HammerLib"), t -> builder.m_13335_(t.f_203868_(), "HammerLib"), t -> builder.removeTag(t.f_203868_(), "HammerLib"));
        });
    }

    public record SubTag<T extends IForgeRegistryEntry<T>>(ResourceLocation loc, Consumer<T> add, Consumer<T> remove, Consumer<TagKey<T>> addTag, Consumer<TagKey<T>> removeTag) {
        public void add(T it) {
            this.add.accept(it);
        }

        public void remove(T it) {
            this.remove.accept(it);
        }

        public void addTag(TagKey<T> it) {
            this.addTag.accept(it);
        }

        public void remove(TagKey<T> it) {
            this.removeTag.accept(it);
        }
    }
}

