/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.annotations.OnlyIf;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.Setup;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.annotations.client.ClientSetup;
import org.zeith.hammerlib.api.blocks.ICustomBlockItem;
import org.zeith.hammerlib.api.blocks.IItemGroupBlock;
import org.zeith.hammerlib.api.blocks.IItemPropertySupplier;
import org.zeith.hammerlib.api.blocks.INoItemBlock;
import org.zeith.hammerlib.api.fml.IRegisterListener;
import org.zeith.hammerlib.core.adapter.OnlyIfAdapter;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.ReflectionUtil;

public class RegistryAdapter {
    private static final Map<Class<?>, List<Block>> blocks = new ConcurrentHashMap();

    public static <T extends IForgeRegistryEntry<T>> Consumer<T> createRegisterer(IForgeRegistry<T> registry) {
        return entry -> {
            IRegisterListener l = Cast.cast(entry, IRegisterListener.class);
            if (l != null) {
                l.onPreRegistered();
            }
            registry.register(entry);
            if (l != null) {
                l.onPostRegistered();
            }
        };
    }

    public static <T extends IForgeRegistryEntry<T>> int register(IForgeRegistry<T> registry, Class<?> source, String modid) {
        List blockList = blocks.computeIfAbsent(source, s -> new ArrayList());
        Consumer<IForgeRegistryEntry> grabber = RegistryAdapter.createRegisterer(registry).andThen(handler -> {
            if (handler instanceof Block) {
                blockList.add((Block)handler);
            }
        });
        if (Item.class.equals((Object)registry.getRegistrySuperType())) {
            for (Block blk : blockList) {
                BlockItem item;
                if (blk instanceof INoItemBlock) continue;
                IItemPropertySupplier gen = Cast.cast(blk, IItemPropertySupplier.class);
                if (blk instanceof ICustomBlockItem) {
                    item = ((ICustomBlockItem)blk).createBlockItem();
                } else {
                    Item.Properties props;
                    Item.Properties properties = props = gen != null ? gen.createItemProperties(new Item.Properties()) : new Item.Properties();
                    if (blk instanceof IItemGroupBlock) {
                        props = props.m_41491_(((IItemGroupBlock)blk).getItemGroup());
                    }
                    item = new BlockItem(blk, props);
                }
                if (item.getRegistryName() == null) {
                    item.setRegistryName(blk.getRegistryName());
                }
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
            }
        }
        int prevSize = registry.getValues().size();
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(SimplyRegister.class) != null && m.getParameterCount() == 1 && Consumer.class.isAssignableFrom(m.getParameterTypes()[0]) && ReflectionUtil.doesParameterTypeArgsMatch(m.getParameters()[0], registry.getRegistrySuperType())).forEach(method -> {
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    OnlyIf onlyIf = method.getAnnotation(OnlyIf.class);
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), registry.getRegistrySuperType().getSimpleName(), null)) {
                        return;
                    }
                    method.setAccessible(true);
                    method.invoke(null, grabber);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
        Arrays.stream(source.getDeclaredFields()).filter(f -> registry.getRegistrySuperType().isAssignableFrom(f.getType())).forEach(field -> {
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())) {
                try {
                    ResourceLocation rl;
                    field.setAccessible(true);
                    RegistryName name = field.getAnnotation(RegistryName.class);
                    OnlyIf onlyIf = field.getAnnotation(OnlyIf.class);
                    IForgeRegistryEntry t = (IForgeRegistryEntry)registry.getRegistrySuperType().cast(field.get(null));
                    ResourceLocation resourceLocation = rl = name != null ? new ResourceLocation(modid, name.value()) : null;
                    if (rl != null) {
                        t.setRegistryName(rl);
                    }
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), registry.getRegistrySuperType().getSimpleName(), t)) {
                        if (t instanceof ForgeRegistryEntry) {
                            ForgeRegistryEntry e = (ForgeRegistryEntry)t;
                            try {
                                Method refl = e.delegate.getClass().getDeclaredMethod("setName", ResourceLocation.class);
                                refl.setAccessible(true);
                                if (rl != null) {
                                    refl.invoke((Object)e.delegate, rl);
                                }
                                refl = e.delegate.getClass().getDeclaredMethod("changeReference", Object.class);
                                refl.setAccessible(true);
                                if (rl != null) {
                                    refl.invoke((Object)e.delegate, e);
                                }
                            }
                            catch (ReflectiveOperationException err) {
                                HammerLib.LOG.fatal("Forge sucks big pp", (Throwable)err);
                            }
                        }
                        RegistryAdapter.fuckForgeOff(t);
                        return;
                    }
                    grabber.accept(t);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        });
        return registry.getValues().size() - prevSize;
    }

    public static <T extends IForgeRegistryEntry<T>> Holder.Reference<T> findReference(T t) {
        if (t instanceof EntityType) {
            EntityType i = (EntityType)t;
            return i.m_204041_();
        }
        if (t instanceof Item) {
            Item i = (Item)t;
            return (Holder.Reference)Cast.cast(i.m_204114_());
        }
        if (t instanceof Block) {
            Block i = (Block)t;
            return (Holder.Reference)Cast.cast(i.m_204297_());
        }
        if (t instanceof GameEvent) {
            GameEvent i = (GameEvent)t;
            return (Holder.Reference)Cast.cast(i.m_204530_());
        }
        if (t instanceof Fluid) {
            Fluid i = (Fluid)t;
            return (Holder.Reference)Cast.cast(i.m_205069_());
        }
        Field refF = ReflectionUtil.lookupField(t.getClass(), Holder.Reference.class);
        if (refF != null) {
            try {
                return (Holder.Reference)refF.get(t);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static <T extends IForgeRegistryEntry<T>> void fuckForgeOff(T t) {
        if (t instanceof EntityType) {
            EntityType i = (EntityType)t;
            i.m_204041_().m_205775_(ResourceKey.m_135785_((ResourceKey)Registry.f_122903_, (ResourceLocation)t.getRegistryName()), (Object)i);
        } else if (t instanceof Item) {
            Item i = (Item)t;
            i.m_204114_().m_205775_(ResourceKey.m_135785_((ResourceKey)Registry.f_122904_, (ResourceLocation)t.getRegistryName()), (Object)i);
        } else if (t instanceof Block) {
            Block i = (Block)t;
            i.m_204297_().m_205775_(ResourceKey.m_135785_((ResourceKey)Registry.f_122901_, (ResourceLocation)t.getRegistryName()), (Object)i);
        } else if (t instanceof GameEvent) {
            GameEvent i = (GameEvent)t;
            i.m_204530_().m_205775_(ResourceKey.m_135785_((ResourceKey)Registry.f_175423_, (ResourceLocation)t.getRegistryName()), (Object)i);
        } else if (t instanceof Fluid) {
            Fluid i = (Fluid)t;
            i.m_205069_().m_205775_(ResourceKey.m_135785_((ResourceKey)Registry.f_122899_, (ResourceLocation)t.getRegistryName()), (Object)i);
        } else {
            Field refF = ReflectionUtil.lookupField(t.getClass(), Holder.Reference.class);
            if (refF != null) {
                try {
                    Holder.Reference o = (Holder.Reference)refF.get(t);
                    IForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(t.getRegistryType());
                    o.m_205775_(ResourceKey.m_135785_((ResourceKey)registry.getRegistryKey(), (ResourceLocation)t.getRegistryName()), t);
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void setup(FMLCommonSetupEvent event, Class<?> source, String memberName) {
        String methodName = memberName.substring(0, memberName.indexOf(40));
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(Setup.class) != null && m.getName().equals(methodName)).forEach(method -> {
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    OnlyIf onlyIf = method.getAnnotation(OnlyIf.class);
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), "Setup", null)) {
                        return;
                    }
                    method.setAccessible(true);
                    if (method.getParameterCount() == 0) {
                        method.invoke(null, new Object[0]);
                    } else if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == FMLCommonSetupEvent.class) {
                        method.invoke(null, event);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    RuntimeException re = null;
                    if (e instanceof InvocationTargetException && e.getCause() instanceof RuntimeException) {
                        re = (RuntimeException)e.getCause();
                    }
                    if (e instanceof RuntimeException) {
                        re = (RuntimeException)e;
                    }
                    if (re != null) {
                        throw re;
                    }
                    e.printStackTrace();
                }
            }
        });
    }

    public static void clientSetup(FMLClientSetupEvent event, Class<?> source, String memberName) {
        String methodName = memberName.substring(0, memberName.indexOf(40));
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(ClientSetup.class) != null && m.getName().equals(methodName)).forEach(method -> {
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    OnlyIf onlyIf = method.getAnnotation(OnlyIf.class);
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), "ClientSetup", null)) {
                        return;
                    }
                    method.setAccessible(true);
                    if (method.getParameterCount() == 0) {
                        method.invoke(null, new Object[0]);
                    } else if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == FMLClientSetupEvent.class) {
                        method.invoke(null, event);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    RuntimeException re = null;
                    if (e instanceof InvocationTargetException && e.getCause() instanceof RuntimeException) {
                        re = (RuntimeException)e.getCause();
                    }
                    if (e instanceof RuntimeException) {
                        re = (RuntimeException)e;
                    }
                    if (re != null) {
                        throw re;
                    }
                    e.printStackTrace();
                }
            }
        });
    }
}

