/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.util.AECableType;
import appeng.items.parts.ColoredPartItem;
import appeng.parts.networking.CablePart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;

public abstract class DenseCablePart
extends CablePart {
    public DenseCablePart(ColoredPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(GridFlags.DENSE_CAPACITY, GridFlags.PREFERRED);
    }

    @Override
    public BusSupport supportsBuses() {
        return BusSupport.DENSE_CABLE;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        this.updateConnections();
        boolean noLadder = !bch.isBBCollision();
        double min = noLadder ? 3.0 : 4.9;
        double max = noLadder ? 13.0 : 11.1;
        bch.addBox(min, min, min, max, max, max);
        block16: for (Direction of : this.getConnections()) {
            if (this.isDense(of)) {
                switch (of) {
                    case DOWN: {
                        bch.addBox(min, 0.0, min, max, min, max);
                        continue block16;
                    }
                    case EAST: {
                        bch.addBox(max, min, min, 16.0, max, max);
                        continue block16;
                    }
                    case NORTH: {
                        bch.addBox(min, min, 0.0, max, max, min);
                        continue block16;
                    }
                    case SOUTH: {
                        bch.addBox(min, min, max, max, max, 16.0);
                        continue block16;
                    }
                    case UP: {
                        bch.addBox(min, max, min, max, 16.0, max);
                        continue block16;
                    }
                    case WEST: {
                        bch.addBox(0.0, min, min, min, max, max);
                        continue block16;
                    }
                }
                continue;
            }
            switch (of) {
                case DOWN: {
                    bch.addBox(5.0, 0.0, 5.0, 11.0, 5.0, 11.0);
                    break;
                }
                case EAST: {
                    bch.addBox(11.0, 5.0, 5.0, 16.0, 11.0, 11.0);
                    break;
                }
                case NORTH: {
                    bch.addBox(5.0, 5.0, 0.0, 11.0, 11.0, 5.0);
                    break;
                }
                case SOUTH: {
                    bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 16.0);
                    break;
                }
                case UP: {
                    bch.addBox(5.0, 11.0, 5.0, 11.0, 16.0, 11.0);
                    break;
                }
                case WEST: {
                    bch.addBox(0.0, 5.0, 5.0, 5.0, 11.0, 11.0);
                    break;
                }
            }
        }
    }

    private boolean isDense(Direction of) {
        BlockPos adjacentPos = this.getBlockEntity().m_58899_().m_142300_(of);
        if (!this.getLevel().m_46805_(adjacentPos)) {
            return false;
        }
        IInWorldGridNodeHost adjacentHost = GridHelper.getNodeHost((LevelAccessor)this.getBlockEntity().m_58904_(), adjacentPos);
        if (adjacentHost != null) {
            AECableType t = adjacentHost.getCableConnectionType(of.m_122424_());
            return t.isDense();
        }
        return false;
    }
}

