/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.rei.throwinginwater;

import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.localization.ItemModText;
import appeng.entity.GrowingCrystalEntity;
import appeng.integration.modules.rei.throwinginwater.GrowingSeedIconRenderer;
import appeng.integration.modules.rei.throwinginwater.ThrowingInWaterDisplay;
import appeng.integration.modules.rei.throwinginwater.WaterBlockRenderer;
import appeng.items.misc.CrystalSeedItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class ThrowingInWaterCategory
implements DisplayCategory<ThrowingInWaterDisplay> {
    public static final CategoryIdentifier<ThrowingInWaterDisplay> ID = CategoryIdentifier.of((ResourceLocation)AppEng.makeId("throwing_in_water"));
    private final Renderer icon;

    public ThrowingInWaterCategory() {
        ItemStack stage1 = AEItems.CERTUS_CRYSTAL_SEED.stack();
        CrystalSeedItem.setGrowthTicks(stage1, 0);
        ItemStack stage2 = AEItems.CERTUS_CRYSTAL_SEED.stack();
        CrystalSeedItem.setGrowthTicks(stage2, 9600);
        ItemStack stage3 = AEItems.CERTUS_CRYSTAL_SEED.stack();
        CrystalSeedItem.setGrowthTicks(stage3, 16800);
        ItemStack result = AEItems.CERTUS_QUARTZ_CRYSTAL.stack();
        this.icon = new GrowingSeedIconRenderer(List.of(stage1, stage2, stage3, result));
    }

    public Renderer getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return ItemModText.THROWING_IN_WATER_CATEGORY.text();
    }

    public CategoryIdentifier<ThrowingInWaterDisplay> getCategoryIdentifier() {
        return ID;
    }

    public List<Widget> setupDisplay(ThrowingInWaterDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        int col1 = bounds.x + 10;
        int y = bounds.y + 10;
        for (EntryIngredient input : display.getInputEntries()) {
            Slot slot = Widgets.createSlot((Point)new Point(col1, y)).entries((Collection)input).markInput();
            y += slot.getBounds().height;
            widgets.add((Widget)slot);
        }
        int yOffset = bounds.y + (display.getInputEntries().size() - 1) / 2 * 18 + 10;
        int col2 = col1 + 25;
        Arrow arrow1 = Widgets.createArrow((Point)new Point(col2, yOffset));
        widgets.add((Widget)arrow1);
        int col3 = col2 + arrow1.getBounds().getWidth() + 6;
        widgets.add((Widget)Widgets.wrapRenderer((Rectangle)new Rectangle(col3, yOffset, 14, 14), (Renderer)new WaterBlockRenderer()));
        int col4 = col3 + 16 + 5;
        Arrow arrow2 = Widgets.createArrow((Point)new Point(col4, yOffset));
        widgets.add((Widget)arrow2);
        int col5 = arrow2.getBounds().getMaxX() + 10;
        Slot slot = Widgets.createSlot((Point)new Point(col5, yOffset)).entries((Collection)display.getOutputEntries().get(0)).markOutput();
        widgets.add((Widget)slot);
        if (display.isSupportsAccelerators()) {
            int durationY = bounds.y + 10 + display.getInputEntries().size() * 18 + 2;
            ArrayList<Object> tooltipLines = new ArrayList<Object>();
            tooltipLines.add(ItemModText.WITH_CRYSTAL_GROWTH_ACCELERATORS.text());
            for (int i = 1; i <= 5; ++i) {
                long duration = GrowingCrystalEntity.getGrowthDuration(i).toMillis();
                tooltipLines.add(new TextComponent(i + ": " + DurationFormatUtils.formatDurationWords((long)duration, (boolean)true, (boolean)true)));
            }
            long defaultDuration = GrowingCrystalEntity.getGrowthDuration(0).toMillis();
            widgets.add((Widget)Widgets.createLabel((Point)new Point(col3 + 7, durationY), (Component)new TextComponent(DurationFormatUtils.formatDurationWords((long)defaultDuration, (boolean)true, (boolean)true))).noShadow().color(-12566464, -4473925).centered().tooltipLines((String[])tooltipLines.stream().map(Component::getString).toArray(String[]::new)));
        }
        return widgets;
    }

    public int getDisplayHeight() {
        return 72;
    }
}

