/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.rei;

import appeng.integration.modules.rei.EntropyManipulatorCategory;
import appeng.recipes.entropy.EntropyRecipe;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class EntropyManipulatorDisplay
implements Display {
    private final EntropyRecipe recipe;
    private final List<EntryIngredient> inputs = new ArrayList<EntryIngredient>();
    private final List<EntryIngredient> outputs = new ArrayList<EntryIngredient>();

    public EntropyManipulatorDisplay(EntropyRecipe recipe) {
        this.recipe = recipe;
        if (recipe.getInputFluid() != null) {
            this.inputs.add(EntryIngredient.of((EntryStack)EntryStacks.of((Fluid)recipe.getInputFluid())));
        }
        if (recipe.getInputBlock() != null) {
            this.inputs.add(EntryIngredient.of((EntryStack)EntryStacks.of((ItemLike)recipe.getInputBlock())));
        }
        if (recipe.getOutputFluid() != null) {
            this.outputs.add(EntryIngredient.of((EntryStack)EntryStacks.of((Fluid)recipe.getOutputFluid())));
        }
        if (recipe.getOutputBlock() != null) {
            this.outputs.add(EntryIngredient.of((EntryStack)EntryStacks.of((ItemLike)recipe.getOutputBlock())));
        }
        for (ItemStack drop : recipe.getDrops()) {
            this.outputs.add(EntryIngredient.of((EntryStack)EntryStacks.of((ItemStack)drop)));
        }
    }

    public EntropyRecipe getRecipe() {
        return this.recipe;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return EntropyManipulatorCategory.ID;
    }
}

