/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createendertransmission.entry;

import com.forsteri.createendertransmission.transmitUtil.ConfigureTransmitterPacket;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public enum TransmissionPackets {
    CONFIGURE_TRANSMITTER(ConfigureTransmitterPacket.class, ConfigureTransmitterPacket::new, NetworkDirection.PLAY_TO_SERVER);

    public static final ResourceLocation CHANNEL_NAME;
    public static final int NETWORK_VERSION = 1;
    public static final String NETWORK_VERSION_STR;
    public static SimpleChannel channel;
    private final LoadedPacket<?> packet;

    private <T extends SimplePacketBase> TransmissionPackets(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
        this.packet = new LoadedPacket<T>(type, factory, direction);
    }

    public static void registerPackets() {
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)CHANNEL_NAME).serverAcceptedVersions(NETWORK_VERSION_STR::equals).clientAcceptedVersions(NETWORK_VERSION_STR::equals).networkProtocolVersion(() -> NETWORK_VERSION_STR).simpleChannel();
        for (TransmissionPackets packet : TransmissionPackets.values()) {
            packet.packet.register();
        }
    }

    public static void sendToNear(Level world, BlockPos pos, int range, Object message) {
        channel.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)range, (ResourceKey)world.m_46472_())), message);
    }

    static {
        CHANNEL_NAME = new ResourceLocation("createendertransmission", "main");
        NETWORK_VERSION_STR = String.valueOf(1);
    }

    private static class LoadedPacket<T extends SimplePacketBase> {
        private static int index = 0;
        private BiConsumer<T, FriendlyByteBuf> encoder = SimplePacketBase::write;
        private Function<FriendlyByteBuf, T> decoder;
        private BiConsumer<T, Supplier<NetworkEvent.Context>> handler;
        private Class<T> type;
        private NetworkDirection direction;

        private LoadedPacket(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
            this.decoder = factory;
            this.handler = (packet, contextSupplier) -> {
                NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
                if (packet.handle(context)) {
                    context.setPacketHandled(true);
                }
            };
            this.type = type;
            this.direction = direction;
        }

        private void register() {
            channel.messageBuilder(this.type, index++, this.direction).encoder(this.encoder).decoder(this.decoder).consumer(this.handler).add();
        }
    }
}

