/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlecharginstation.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.energy.EnergyStorage;

public class EnergyStorageElement
extends GuiComponent {
    private static final ResourceLocation ENERGY_STORAGE_TEXTURE = new ResourceLocation("turtlechargingstation", "textures/gui/energy_storage.png");
    private final EnergyStorage energyStorage;
    private Rect2i area;
    private final int textureWidth = 34;
    private final int textureHeight = 84;
    private final int width = 16;
    private final int height = 84;

    public EnergyStorageElement(EnergyStorage energyStorage, int xPos, int yPos) {
        this.area = new Rect2i(xPos, yPos, 16, 84);
        this.energyStorage = energyStorage;
    }

    public void draw(PoseStack poseStack) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)ENERGY_STORAGE_TEXTURE);
        int n = this.area.m_110085_();
        int n2 = this.area.m_110086_();
        Objects.requireNonNull(this);
        EnergyStorageElement.m_93133_((PoseStack)poseStack, (int)n, (int)n2, (float)0.0f, (float)0.0f, (int)this.width, (int)84, (int)34, (int)84);
        this.drawEnergyLevel(poseStack);
    }

    private void drawEnergyLevel(PoseStack poseStack) {
        int n = this.area.m_110085_();
        int n2 = this.area.m_110086_() + this.getEnergyLevel();
        float f = this.getEnergyLevel();
        Objects.requireNonNull(this);
        EnergyStorageElement.m_93133_((PoseStack)poseStack, (int)n, (int)n2, (float)18.0f, (float)f, (int)this.width, (int)(84 - this.getEnergyLevel()), (int)34, (int)84);
    }

    private int getEnergyLevel() {
        Objects.requireNonNull(this);
        return 84 - (int)Math.floor((float)this.area.m_110091_() * ((float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored()));
    }

    public List<Component> getTooltips() {
        return List.of(new TextComponent(this.energyStorage.getEnergyStored() + "/" + this.energyStorage.getMaxEnergyStored() + " FE"));
    }

    public Rect2i getArea() {
        return this.area;
    }
}

