/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.BuilderTransformers;
import com.railwayteam.railways.content.conductor.vent.CopycatVentModel;
import com.railwayteam.railways.content.conductor.vent.VentBlock;
import com.railwayteam.railways.content.conductor.whistle.ConductorWhistleFlagBlock;
import com.railwayteam.railways.content.conductor.whistle.ConductorWhistleItem;
import com.railwayteam.railways.content.coupling.TrackCouplerDisplaySource;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlock;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockItem;
import com.railwayteam.railways.content.custom_bogeys.DoubleAxleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.LargePlatformDoubleAxleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.SingleAxleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.TripleAxleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.invisible.InvisibleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.monobogey.MonoBogeyBlock;
import com.railwayteam.railways.content.custom_tracks.CustomTrackBlockStateGenerator;
import com.railwayteam.railways.content.custom_tracks.monorail.MonorailBlockStateGenerator;
import com.railwayteam.railways.content.distant_signals.SemaphoreDisplayTarget;
import com.railwayteam.railways.content.semaphore.SemaphoreBlock;
import com.railwayteam.railways.content.semaphore.SemaphoreItem;
import com.railwayteam.railways.content.smokestack.AxisSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.DieselSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.SmokeStackBlock;
import com.railwayteam.railways.content.smokestack.SmokeStackMovementBehaviour;
import com.railwayteam.railways.content.switches.SwitchDisplaySource;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.content.switches.TrackSwitchBlockItem;
import com.railwayteam.railways.content.tender.TenderBlock;
import com.railwayteam.railways.multiloader.CommonTags;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.railwayteam.railways.registry.CRShapes;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.ShapeWrapper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.redstone.displayLink.AllDisplayBehaviours;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockItem;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackModel;
import com.simibubi.create.foundation.block.ItemUseOverrides;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public class CRBlocks {
    private static final CreateRegistrate REGISTRATE = Railways.registrate();
    public static final BlockEntry<TenderBlock> BLOCK_TENDER = null;
    public static final BlockEntry<SemaphoreBlock> SEMAPHORE = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("semaphore", SemaphoreBlock::new).initialProperties(SharedProperties::softMetal).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)prov.models().getExistingFile(prov.modLoc("block/semaphore/block" + ((Boolean)state.m_61143_((Property)SemaphoreBlock.FULL) != false ? "_full" : "") + ((Boolean)state.m_61143_((Property)SemaphoreBlock.FLIPPED) != false ? "_flipped" : "") + ((Boolean)state.m_61143_((Property)SemaphoreBlock.UPSIDE_DOWN) != false ? "_down" : "")))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build())).properties(p -> p.m_155949_(MaterialColor.f_76419_)).properties(p -> p.m_60918_(SoundType.f_56725_)).onRegister(AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new SemaphoreDisplayTarget(), (String[])new String[0]))).item(SemaphoreItem::new).transform(ModelGen.customItemModel())).transform(TagGen.axeOnly())).addLayer(() -> RenderType::m_110466_).register();
    public static final BlockEntry<TrackCouplerBlock> TRACK_COUPLER = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("track_coupler", TrackCouplerBlock::create).initialProperties(SharedProperties::softMetal).properties(p -> p.m_155949_(MaterialColor.f_76370_)).properties(p -> p.m_60955_()).properties(p -> p.m_60918_(SoundType.f_56725_)).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{((TrackCouplerBlockEntity.AllowedOperationMode)((Object)((Object)((Object)state.m_61143_(TrackCouplerBlock.MODE))))).m_7912_()})).build(), new Property[]{TrackCouplerBlock.POWERED})).transform(TagGen.pickaxeOnly())).onRegister(AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new TrackCouplerDisplaySource(), (String[])new String[]{"track_coupler_info"}))).lang("Train Coupler").item(TrackCouplerBlockItem.ofType(CREdgePointTypes.COUPLER)).transform(ModelGen.customItemModel((String[])new String[]{"_", "block_both"}))).register();
    public static final BlockEntry<TrackSwitchBlock> ANDESITE_SWITCH = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("track_switch_andesite", TrackSwitchBlock::manual).initialProperties(SharedProperties::softMetal).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(Railways.asResource("block/track_switch_andesite/block"))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 90) % 360).build(), new Property[]{TrackSwitchBlock.LOCKED})).properties(p -> p.m_155949_(MaterialColor.f_76370_)).properties(p -> p.m_60955_()).properties(p -> p.m_60918_(SoundType.f_56725_)).transform(TagGen.pickaxeOnly())).onRegister(AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new SwitchDisplaySource(), (String[])new String[0]))).onRegister(ItemUseOverrides::addBlock)).lang("Andesite Track Switch").item(TrackSwitchBlockItem.ofType(CREdgePointTypes.SWITCH)).transform(ModelGen.customItemModel())).register();
    public static final BlockEntry<TrackSwitchBlock> BRASS_SWITCH = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("track_switch_brass", TrackSwitchBlock::automatic).initialProperties(SharedProperties::softMetal).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(Railways.asResource("block/track_switch_brass/block"))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 90) % 360).build(), new Property[]{TrackSwitchBlock.LOCKED})).properties(p -> p.m_155949_(MaterialColor.f_76384_)).properties(p -> p.m_60955_()).properties(p -> p.m_60918_(SoundType.f_56725_)).transform(TagGen.pickaxeOnly())).onRegister(AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new SwitchDisplaySource(), (String[])new String[0]))).onRegister(ItemUseOverrides::addBlock)).lang("Brass Track Switch").item(TrackSwitchBlockItem.ofType(CREdgePointTypes.SWITCH)).transform(ModelGen.customItemModel())).register();
    public static final BlockEntry<TrackBlock> ACACIA_TRACK = CRBlocks.makeTrack(CRTrackMaterials.ACACIA);
    public static final BlockEntry<TrackBlock> BIRCH_TRACK = CRBlocks.makeTrack(CRTrackMaterials.BIRCH);
    public static final BlockEntry<TrackBlock> CRIMSON_TRACK = CRBlocks.makeTrack(CRTrackMaterials.CRIMSON);
    public static final BlockEntry<TrackBlock> DARK_OAK_TRACK = CRBlocks.makeTrack(CRTrackMaterials.DARK_OAK);
    public static final BlockEntry<TrackBlock> JUNGLE_TRACK = CRBlocks.makeTrack(CRTrackMaterials.JUNGLE);
    public static final BlockEntry<TrackBlock> OAK_TRACK = CRBlocks.makeTrack(CRTrackMaterials.OAK);
    public static final BlockEntry<TrackBlock> SPRUCE_TRACK = CRBlocks.makeTrack(CRTrackMaterials.SPRUCE);
    public static final BlockEntry<TrackBlock> WARPED_TRACK = CRBlocks.makeTrack(CRTrackMaterials.WARPED);
    public static final BlockEntry<TrackBlock> BLACKSTONE_TRACK = CRBlocks.makeTrack(CRTrackMaterials.BLACKSTONE);
    public static final BlockEntry<TrackBlock> ENDER_TRACK = CRBlocks.makeTrack(CRTrackMaterials.ENDER);
    public static final BlockEntry<TrackBlock> TIELESS_TRACK = CRBlocks.makeTrack(CRTrackMaterials.TIELESS);
    public static final BlockEntry<TrackBlock> PHANTOM_TRACK = CRBlocks.makeTrack(CRTrackMaterials.PHANTOM);
    public static final BlockEntry<TrackBlock> MONORAIL_TRACK = CRBlocks.makeTrack(CRTrackMaterials.MONORAIL, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((MonorailBlockStateGenerator)new MonorailBlockStateGenerator()).generate(arg_0, arg_1)), BlockBehaviour.Properties::m_60977_);
    public static final BlockEntry<MonoBogeyBlock> MONO_BOGEY = ((BlockBuilder)REGISTRATE.block("mono_bogey", MonoBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.monobogey())).lang("Monorail Bogey").register();
    public static final BlockEntry<InvisibleBogeyBlock> INVISIBLE_BOGEY = ((BlockBuilder)REGISTRATE.block("invisible_bogey", InvisibleBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.invisibleBogey())).lang("Invisible Bogey").register();
    public static final BlockEntry<SingleAxleBogeyBlock> SINGLEAXLE_BOGEY = ((BlockBuilder)REGISTRATE.block("singleaxle_bogey", SingleAxleBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Single Axle Bogey").register();
    public static final BlockEntry<DoubleAxleBogeyBlock> DOUBLEAXLE_BOGEY = ((BlockBuilder)REGISTRATE.block("doubleaxle_bogey", DoubleAxleBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Double Axle Bogey").register();
    public static final BlockEntry<LargePlatformDoubleAxleBogeyBlock> LARGE_PLATFORM_DOUBLEAXLE_BOGEY = ((BlockBuilder)REGISTRATE.block("large_platform_doubleaxle_bogey", LargePlatformDoubleAxleBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Large Platform Double Axle Bogey").register();
    public static final BlockEntry<TripleAxleBogeyBlock> TRIPLEAXLE_BOGEY = ((BlockBuilder)REGISTRATE.block("tripleaxle_bogey", TripleAxleBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Triple Axle Bogey").register();
    public static final BlockEntry<ConductorWhistleFlagBlock> CONDUCTOR_WHISTLE_FLAG = ((BlockBuilder)REGISTRATE.block("conductor_whistle", ConductorWhistleFlagBlock::new).initialProperties(SharedProperties::wooden).properties(p -> p.m_155949_(MaterialColor.f_76362_)).properties(p -> p.m_60955_()).properties(p -> p.m_60918_(SoundType.f_56736_)).properties(p -> p.m_60966_()).properties(p -> p.m_60993_()).properties(p -> p.m_60910_()).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{"pole"})).build())).lang("Conductor Whistle").item(ConductorWhistleItem::new).transform(ModelGen.customItemModel())).register();
    public static final BlockEntry<SmokeStackBlock> CABOOSESTYLE_STACK = CRBlocks.makeSmokeStack("caboosestyle", new SmokeStackBlock.SmokeStackType(0.5, 0.625, 0.5), "Caboose Smokestack", true, ShapeWrapper.wrapped(CRShapes.CABOOSE_STACK), false, true);
    public static final BlockEntry<SmokeStackBlock> LONG_STACK = CRBlocks.makeSmokeStack("long", new SmokeStackBlock.SmokeStackType(0.5, 0.625, 0.5), "Long Smokestack", true, ShapeWrapper.wrapped(CRShapes.LONG_STACK), true, true);
    public static final BlockEntry<SmokeStackBlock> COALBURNER_STACK = CRBlocks.makeSmokeStack("coalburner", new SmokeStackBlock.SmokeStackType(0.5, 1.0, 0.5), "Coalburner Smokestack", CRShapes.COAL_STACK, true);
    public static final BlockEntry<SmokeStackBlock> OILBURNER_STACK = CRBlocks.makeSmokeStack("oilburner", new SmokeStackBlock.SmokeStackType(new Vec3(0.5, 0.4, 0.5), new Vec3(0.2, 0.2, 0.2)), "Oilburner Smokestack", CRShapes.OIL_STACK, true);
    public static final BlockEntry<SmokeStackBlock> STREAMLINED_STACK = CRBlocks.makeSmokeStack("streamlined", new SmokeStackBlock.SmokeStackType(new Vec3(0.5, 0.2, 0.5), new Vec3(0.25, 0.2, 0.25)), "Streamlined Smokestack", CRShapes.STREAMLINED_STACK, true);
    public static final BlockEntry<SmokeStackBlock> WOODBURNER_STACK = CRBlocks.makeSmokeStack("woodburner", new SmokeStackBlock.SmokeStackType(0.5, 0.75, 0.5), "Woodburner Smokestack", CRShapes.WOOD_STACK, true);
    public static final BlockEntry<DieselSmokeStackBlock> DIESEL_STACK = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("smokestack_diesel", p -> new DieselSmokeStackBlock((BlockBehaviour.Properties)p, new SmokeStackBlock.SmokeStackType(0.5, 0.25, 0.5), ShapeWrapper.wrapped(CRShapes.DIESEL_STACK), false)).initialProperties(SharedProperties::softMetal).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(Railways.asResource("block/smokestack/block_diesel_case"))).build())).properties(p -> p.m_155949_(MaterialColor.f_76419_)).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).transform(TagGen.pickaxeOnly())).onRegister(AllMovementBehaviours.movementBehaviour((MovementBehaviour)new SmokeStackMovementBehaviour(true, false, false)))).lang("Radiator Fan").item().model((c, p) -> p.withExistingParent("item/" + c.getName(), Railways.asResource("block/smokestack/block_diesel"))).build()).register();
    public static final BlockEntry<VentBlock> CONDUCTOR_VENT = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("conductor_vent", VentBlock::create).transform((NonNullFunction)com.simibubi.create.foundation.data.BuilderTransformers.copycat())).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile((Boolean)state.m_61143_((Property)VentBlock.CONDUCTOR_VISIBLE) != false ? Railways.asResource("block/copycat_vent_visible") : new ResourceLocation("block/air"))).build())).properties(p -> p.m_60960_((state, level, pos) -> false)).onRegister(CreateRegistrate.blockModel(() -> CopycatVentModel::create))).lang("Vent Block").recipe((c, p) -> p.stonecutting(DataIngredient.items((NonNullSupplier)AllBlocks.INDUSTRIAL_IRON_BLOCK, (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)c, 2)).item().transform(ModelGen.customItemModel((String[])new String[]{"copycat_vent"}))).register();

    private static BlockEntry<TrackBlock> makeTrack(TrackMaterial material) {
        return CRBlocks.makeTrack(material, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((CustomTrackBlockStateGenerator)new CustomTrackBlockStateGenerator()).generate(arg_0, arg_1)));
    }

    private static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen) {
        return CRBlocks.makeTrack(material, blockstateGen, (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}));
    }

    private static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister) {
        return CRBlocks.makeTrack(material, blockstateGen, onRegister, p -> p);
    }

    private static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> collectProperties) {
        return CRBlocks.makeTrack(material, blockstateGen, (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}), collectProperties);
    }

    private static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> collectProperties) {
        ArrayList<TagKey> trackTags = new ArrayList<TagKey>();
        trackTags.add(AllTags.AllBlockTags.TRACKS.tag);
        if (material.trackType != CRTrackMaterials.CRTrackType.MONORAIL) {
            trackTags.add(AllTags.AllBlockTags.GIRDABLE_TRACKS.tag);
        }
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("track_" + material.resourceName(), arg_0 -> ((TrackMaterial)material).createBlock(arg_0)).initialProperties(Material.f_76278_).properties(p -> ((BlockBehaviour.Properties)collectProperties.apply((BlockBehaviour.Properties)p)).m_155949_(MaterialColor.f_76404_).m_60978_(0.8f).m_60918_(SoundType.f_56743_).m_60955_()).addLayer(() -> RenderType::m_110457_).transform(TagGen.pickaxeOnly())).blockstate(blockstateGen).tag(new TagKey[]{CommonTags.RELOCATION_NOT_SUPPORTED.forge, CommonTags.RELOCATION_NOT_SUPPORTED.fabric}).tag(trackTags.toArray(new TagKey[0])).lang(material.langName + " Train Track").onRegister(onRegister)).onRegister(CreateRegistrate.blockModel(() -> TrackModel::new))).item(TrackBlockItem::new).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{Railways.asResource("item/track/" + c.getName())})).build()).register();
    }

    private static BlockEntry<SmokeStackBlock> makeSmokeStack(String variant, SmokeStackBlock.SmokeStackType type, String description, VoxelShape shape, boolean emitStationarySmoke) {
        return CRBlocks.makeSmokeStack(variant, type, description, false, ShapeWrapper.wrapped(shape), true, emitStationarySmoke);
    }

    private static BlockEntry<SmokeStackBlock> makeSmokeStack(String variant, SmokeStackBlock.SmokeStackType type, String description, VoxelShape shape, boolean spawnExtraSmoke, boolean emitStationarySmoke) {
        return CRBlocks.makeSmokeStack(variant, type, description, false, ShapeWrapper.wrapped(shape), spawnExtraSmoke, emitStationarySmoke);
    }

    private static BlockEntry<SmokeStackBlock> makeSmokeStack(String variant, SmokeStackBlock.SmokeStackType type, String description, boolean rotates, ShapeWrapper shape, boolean spawnExtraSmoke, boolean emitStationarySmoke) {
        ResourceLocation modelLoc = Railways.asResource("block/smokestack/block_" + variant);
        SmokeStackMovementBehaviour movementBehaviour = new SmokeStackMovementBehaviour(spawnExtraSmoke);
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("smokestack_" + variant, p -> rotates ? new AxisSmokeStackBlock((BlockBehaviour.Properties)p, type, shape, emitStationarySmoke) : new SmokeStackBlock((BlockBehaviour.Properties)p, type, shape, emitStationarySmoke)).initialProperties(SharedProperties::softMetal).blockstate((c, p) -> {
            if (rotates) {
                p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(modelLoc)).rotationY(state.m_61143_((Property)BlockStateProperties.f_61364_) == Direction.Axis.X ? 90 : 0).build());
            } else {
                p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(modelLoc)).build());
            }
        }).properties(p -> p.m_155949_(MaterialColor.f_76419_)).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).transform(TagGen.pickaxeOnly())).onRegister(AllMovementBehaviours.movementBehaviour((MovementBehaviour)movementBehaviour))).lang(description).item().model((c, p) -> p.withExistingParent("item/" + c.getName(), modelLoc)).build()).register();
    }

    public static void register() {
    }
}

