/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.content.custom_bogeys.selection_menu.BogeyCategoryHandlerServer;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.utility.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={StationBlockEntity.class}, remap=false)
public abstract class MixinStationBlockEntity
extends SmartBlockEntity {
    private Train dropScheduleTrain;

    @Shadow
    @Nullable
    public abstract GlobalStation getStation();

    private MixinStationBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"trackClicked"}, at={@At(value="HEAD")})
    private void storePlayer(Player player, InteractionHand hand, ITrackBlock track, BlockState state, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BogeyCategoryHandlerServer.currentPlayer = player.m_142081_();
    }

    @Inject(method={"trackClicked"}, at={@At(value="RETURN")})
    private void clearPlayer(Player player, InteractionHand hand, ITrackBlock track, BlockState state, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BogeyCategoryHandlerServer.currentPlayer = null;
    }

    @Inject(method={"trackClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", remap=true)}, locals=LocalCapture.CAPTURE_FAILSOFT, remap=true, require=0)
    private void snr$setBogeyData(Player player, InteractionHand hand, ITrackBlock track, BlockState state, BlockPos pos, CallbackInfoReturnable<Boolean> cir, BoundingBox bb, BlockPos up, BlockPos down, int bogeyOffset, ItemStack handItem, boolean upsideDown, BlockPos targetPos) {
        if (track.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
            return;
        }
        Pair<BogeyStyle, BogeySizes.BogeySize> styleData = BogeyCategoryHandlerServer.getStyle(player.m_142081_());
        BogeyStyle style = (BogeyStyle)styleData.getFirst();
        if (style == AllBogeyStyles.STANDARD) {
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(targetPos);
        if (blockEntity instanceof AbstractBogeyBlockEntity) {
            AbstractBogeyBlockEntity bogeyBE = (AbstractBogeyBlockEntity)blockEntity;
            bogeyBE.setBogeyStyle(style);
        }
    }

    @Inject(method={"tryDisassembleTrain"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/station/GlobalStation;getPresentTrain()Lcom/simibubi/create/content/trains/entity/Train;")})
    private void storeTrainForDropping(ServerPlayer sender, CallbackInfoReturnable<Boolean> cir) {
        this.dropScheduleTrain = this.getStation() == null ? null : this.getStation().getPresentTrain();
    }

    @Inject(method={"tryDisassembleTrain"}, at={@At(value="RETURN")})
    private void clearDropTrain(ServerPlayer sender, CallbackInfoReturnable<Boolean> cir) {
        this.dropScheduleTrain = null;
    }

    @Redirect(method={"dropSchedule"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/station/GlobalStation;getPresentTrain()Lcom/simibubi/create/content/trains/entity/Train;"), require=0)
    private Train returnOverridenTrain(GlobalStation instance) {
        Train train = instance.getPresentTrain();
        if (train == null) {
            train = this.dropScheduleTrain;
        }
        this.dropScheduleTrain = null;
        return train;
    }
}

