/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack;

import com.railwayteam.railways.util.ShapeWrapper;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SmokeStackBlock
extends Block
implements ProperWaterloggedBlock,
IWrenchable {
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public final SmokeStackType type;
    protected final ShapeWrapper shape;
    public boolean createsStationarySmoke;

    public SmokeStackBlock(BlockBehaviour.Properties properties, SmokeStackType type, ShapeWrapper shape, boolean createsStationarySmoke) {
        super(properties);
        this.m_49959_(this.makeDefaultState());
        this.type = type;
        this.shape = shape;
        this.createsStationarySmoke = createsStationarySmoke;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shape.get();
    }

    protected BlockState makeDefaultState() {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ENABLED}).m_61104_(new Property[]{POWERED}).m_61104_(new Property[]{WATERLOGGED});
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return this.fluidState(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = this.m_49966_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        if (context.m_43725_().m_46753_(context.m_8083_())) {
            blockstate = (BlockState)((BlockState)blockstate.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        this.updateWater(level, state, currentPos);
        return state;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (AllTags.AllItemTags.WRENCH.matches(pPlayer.m_21120_(pHand))) {
            return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
        }
        pState = (BlockState)pState.m_61122_((Property)ENABLED);
        pLevel.m_7731_(pPos, pState, 2);
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (!level.f_46443_) {
            boolean shouldBeEnabled;
            boolean powered = level.m_46753_(pos);
            boolean bl = shouldBeEnabled = !powered;
            if (powered != (Boolean)state.m_61143_((Property)POWERED)) {
                if ((Boolean)state.m_61143_((Property)ENABLED) != shouldBeEnabled) {
                    state = (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(shouldBeEnabled));
                }
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
                if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                    level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
                }
            }
        }
    }

    public static void makeParticles(Level level, BlockPos pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta) {
        SmokeStackBlock.makeParticles(level, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta);
    }

    public static void makeParticles(Level level, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, 1.0);
    }

    public static void makeParticles(Level level, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta, double speedMultiplier) {
        Random random = level.m_5822_();
        SimpleParticleType particleType = isSignalFire ? ParticleTypes.f_123778_ : ParticleTypes.f_123777_;
        level.m_6485_((ParticleOptions)particleType, true, pos.m_7096_() + spawnOffset.f_82479_ + random.nextDouble() * spawnDelta.f_82479_ * (double)(random.nextBoolean() ? 1 : -1), pos.m_7098_() + random.nextDouble() * spawnDelta.f_82480_ + spawnOffset.f_82480_, pos.m_7094_() + spawnOffset.f_82481_ + random.nextDouble() * spawnDelta.f_82481_ * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07 * speedMultiplier, 0.0);
        if (spawnExtraSmoke) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pos.m_7096_() + spawnOffset.f_82479_ + random.nextDouble() * spawnDelta.f_82479_ * 0.75 * (double)(random.nextBoolean() ? 1 : -1), pos.m_7098_() + spawnOffset.f_82480_ - 0.1, pos.m_7094_() + spawnOffset.f_82481_ + random.nextDouble() * spawnDelta.f_82481_ * 0.75 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.005 * speedMultiplier, 0.0);
        }
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)ENABLED)).booleanValue() && (double)random.nextFloat() < this.type.particleSpawnChance && this.createsStationarySmoke) {
            for (int i = 0; i < random.nextInt(this.type.maxParticles - this.type.minParticles) + this.type.minParticles; ++i) {
                SmokeStackBlock.makeParticles(level, pos, random.nextBoolean(), true, this.type.getParticleSpawnOffset(), this.type.getParticleSpawnDelta());
            }
        }
    }

    public static class SmokeStackType {
        public Vec3 particleSpawnOffset;
        public Vec3 particleSpawnDelta;
        public double particleSpawnChance;
        public int minParticles;
        public int maxParticles;

        public SmokeStackType(double xOffset, double yOffset, double zOffset) {
            this(new Vec3(xOffset, yOffset, zOffset));
        }

        public SmokeStackType(Vec3 particleSpawnOffset) {
            this(particleSpawnOffset, new Vec3(0.3, 2.0, 0.3));
        }

        public SmokeStackType(Vec3 particleSpawnOffset, Vec3 particleSpawnDelta) {
            this(particleSpawnOffset, particleSpawnDelta, 2, 4);
        }

        public SmokeStackType(Vec3 particleSpawnOffset, Vec3 particleSpawnDelta, int minParticles, int maxParticles) {
            this(particleSpawnOffset, particleSpawnDelta, minParticles, maxParticles, 1.0);
        }

        public SmokeStackType(Vec3 particleSpawnOffset, Vec3 particleSpawnDelta, int minParticles, int maxParticles, double particleSpawnChance) {
            this.particleSpawnOffset = particleSpawnOffset;
            this.particleSpawnDelta = particleSpawnDelta;
            this.minParticles = minParticles;
            this.maxParticles = maxParticles;
            this.particleSpawnChance = particleSpawnChance;
        }

        public Vec3 getParticleSpawnOffset() {
            return this.particleSpawnOffset;
        }

        public Vec3 getParticleSpawnDelta() {
            return this.particleSpawnDelta;
        }
    }
}

