/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling.coupler;

import com.railwayteam.railways.mixin.AccessorTrackTargetingBehavior;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;

public class SecondaryTrackTargetingBehaviour<T extends TrackEdgePoint>
extends TrackTargetingBehaviour<T> {
    public static final BehaviourType<SecondaryTrackTargetingBehaviour<?>> TYPE = new BehaviourType();

    public SecondaryTrackTargetingBehaviour(SmartBlockEntity te, EdgePointType<T> edgePointType) {
        super(te, edgePointType);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        AccessorTrackTargetingBehavior accessor = (AccessorTrackTargetingBehavior)((Object)this);
        nbt.m_128362_("SecondaryId", accessor.getId());
        nbt.m_128365_("SecondaryTargetTrack", (Tag)NbtUtils.m_129224_((BlockPos)accessor.getTargetTrack()));
        nbt.m_128379_("SecondaryOrtho", accessor.isOrthogonal());
        nbt.m_128379_("SecondaryTargetDirection", accessor.getTargetDirection() == Direction.AxisDirection.POSITIVE);
        if (accessor.getRotatedDirection() != null) {
            nbt.m_128365_("SecondaryRotatedAxis", (Tag)VecHelper.writeNBT((Vec3)accessor.getRotatedDirection()));
        }
        if (accessor.getPrevDirection() != null) {
            nbt.m_128365_("SecondaryPrevAxis", (Tag)VecHelper.writeNBT((Vec3)accessor.getPrevDirection()));
        }
        if (accessor.getMigrationData() != null && !clientPacket) {
            nbt.m_128365_("SecondaryMigrate", (Tag)accessor.getMigrationData());
        }
        if (accessor.getTargetBezier() != null) {
            CompoundTag bezierNbt = new CompoundTag();
            bezierNbt.m_128405_("Segment", accessor.getTargetBezier().segment());
            bezierNbt.m_128365_("Key", (Tag)NbtUtils.m_129224_((BlockPos)accessor.getTargetBezier().curveTarget().m_141950_((Vec3i)this.getPos())));
            nbt.m_128365_("SecondaryBezier", (Tag)bezierNbt);
        }
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        AccessorTrackTargetingBehavior accessor = (AccessorTrackTargetingBehavior)((Object)this);
        accessor.setId(nbt.m_128441_("SecondaryId") ? nbt.m_128342_("SecondaryId") : UUID.randomUUID());
        accessor.setTargetTrack(NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("SecondaryTargetTrack")));
        accessor.setTargetDirection(nbt.m_128471_("SecondaryTargetDirection") ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE);
        accessor.setOrthogonal(nbt.m_128471_("SecondaryOrtho"));
        if (nbt.m_128441_("SecondaryPrevAxis")) {
            accessor.setPrevDirection(VecHelper.readNBT((ListTag)nbt.m_128437_("SecondaryPrevAxis", 6)));
        }
        if (nbt.m_128441_("SecondaryRotatedAxis")) {
            accessor.setRotatedDirection(VecHelper.readNBT((ListTag)nbt.m_128437_("SecondaryRotatedAxis", 6)));
        }
        if (nbt.m_128441_("SecondaryMigrate")) {
            accessor.setMigrationData(nbt.m_128469_("SecondaryMigrate"));
        }
        if (clientPacket) {
            accessor.setEdgePoint(null);
        }
        if (nbt.m_128441_("SecondaryBezier")) {
            CompoundTag bezierNbt = nbt.m_128469_("SecondaryBezier");
            BlockPos key = NbtUtils.m_129239_((CompoundTag)bezierNbt.m_128469_("Key"));
            accessor.setTargetBezier(new BezierTrackPointLocation(bezierNbt.m_128441_("FromStack") ? key : key.m_141952_((Vec3i)this.getPos()), bezierNbt.m_128451_("Segment")));
        }
    }
}

