/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.block.WormFarmBlock;
import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.init.AquaBlockEntities;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import com.teammetallurgy.aquaculture.init.AquaGuis;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.FishRegistry;
import com.teammetallurgy.aquaculture.item.crafting.FishFilletRecipe;
import com.teammetallurgy.aquaculture.loot.FishReadFromJson;
import com.teammetallurgy.aquaculture.loot.FishWeightHandler;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import javax.annotation.Nonnull;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="aquaculture")
public class Aquaculture {
    public static Aquaculture instance;
    public static final boolean IS_DEV;
    public static final String MOD_ID = "aquaculture";
    public static final Logger LOG;
    public static final CreativeModeTab GROUP;
    public static LootItemConditionType BIOME_TAG_CHECK;

    public Aquaculture() {
        instance = this;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setupCommon);
        modBus.addListener(this::setupClient);
        this.registerDeferredRegistries(modBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AquaConfig.spec);
        AquacultureAPI.Tags.init();
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        event.enqueueWork(FishWeightHandler::registerFishData);
        event.enqueueWork(AquaEntities::setSpawnPlacement);
        event.enqueueWork(WormFarmBlock::addCompostables);
        if (((Boolean)AquaConfig.BASIC_OPTIONS.aqFishToBreedCats.get()).booleanValue()) {
            event.enqueueWork(FishRegistry::addCatBreeding);
        }
        if (((Boolean)AquaConfig.BASIC_OPTIONS.enableFishSpawning.get()).booleanValue()) {
            event.enqueueWork(FishReadFromJson::read);
        }
    }

    private void setupClient(FMLClientSetupEvent event) {
        ClientHandler.setupClient();
    }

    public void registerDeferredRegistries(IEventBus modBus) {
        AquaBlocks.BLOCK_DEFERRED.register(modBus);
        AquaItems.ITEM_DEFERRED.register(modBus);
        AquaBlockEntities.BLOCK_ENTITY_DEFERRED.register(modBus);
        AquaEntities.ENTITY_DEFERRED.register(modBus);
        AquaGuis.MENU_DEFERRED.register(modBus);
        FishFilletRecipe.IRECIPE_SERIALIZERS_DEFERRED.register(modBus);
    }

    static {
        IS_DEV = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.VERSION.get()).filter(v -> v.equals("MOD_DEV")).isPresent();
        LOG = LogManager.getLogger((String)MOD_ID);
        GROUP = new CreativeModeTab(MOD_ID){

            @Nonnull
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)AquaItems.IRON_FISHING_ROD.get());
            }
        };
    }
}

