/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.data;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.recipe.data.IRecipeHelper;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.MetalItemObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;

public interface ICommonRecipeHelper
extends IRecipeHelper {
    default public void packingRecipe(Consumer<FinishedRecipe> consumer, String largeName, ItemLike large, String smallName, ItemLike small, String folder) {
        ShapedRecipeBuilder.m_126116_((ItemLike)large).m_126127_(Character.valueOf('#'), small).m_126130_("###").m_126130_("###").m_126130_("###").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)small)).m_142409_(Objects.requireNonNull(large.m_5456_().getRegistryName()).toString()).m_142700_(consumer, this.wrap((IForgeRegistryEntry<?>)large.m_5456_(), folder, String.format("_from_%ss", smallName)));
        ShapelessRecipeBuilder.m_126191_((ItemLike)small, (int)9).m_126209_(large).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)large)).m_142409_(Objects.requireNonNull(small.m_5456_().getRegistryName()).toString()).m_142700_(consumer, this.wrap((IForgeRegistryEntry<?>)small.m_5456_(), folder, String.format("_from_%s", largeName)));
    }

    default public void packingRecipe(Consumer<FinishedRecipe> consumer, String largeName, ItemLike largeItem, String smallName, ItemLike smallItem, TagKey<Item> smallTag, String folder) {
        ShapedRecipeBuilder.m_126116_((ItemLike)largeItem).m_206416_(Character.valueOf('#'), smallTag).m_126127_(Character.valueOf('*'), smallItem).m_126130_("###").m_126130_("#*#").m_126130_("###").m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)smallItem)).m_142409_(Objects.requireNonNull(largeItem.m_5456_().getRegistryName()).toString()).m_142700_(consumer, this.wrap((IForgeRegistryEntry<?>)largeItem.m_5456_(), folder, String.format("_from_%ss", smallName)));
        ShapelessRecipeBuilder.m_126191_((ItemLike)smallItem, (int)9).m_126209_(largeItem).m_142284_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)largeItem)).m_142409_(Objects.requireNonNull(smallItem.m_5456_().getRegistryName()).toString()).m_142700_(consumer, this.wrap((IForgeRegistryEntry<?>)smallItem.m_5456_(), folder, String.format("_from_%s", largeName)));
    }

    default public void metalCrafting(Consumer<FinishedRecipe> consumer, MetalItemObject metal, String folder) {
        Item ingot = metal.getIngot();
        this.packingRecipe(consumer, "block", (ItemLike)metal.get(), "ingot", (ItemLike)ingot, metal.getIngotTag(), folder);
        this.packingRecipe(consumer, "ingot", (ItemLike)ingot, "nugget", (ItemLike)metal.getNugget(), metal.getNuggetTag(), folder);
    }

    default public void slabStairsCrafting(Consumer<FinishedRecipe> consumer, BuildingBlockObject saveing, String folder, boolean addStonecutter) {
        Item item = saveing.m_5456_();
        InventoryChangeTrigger.TriggerInstance hasBlock = RecipeProvider.m_125977_((ItemLike)item);
        SlabBlock slab = saveing.getSlab();
        ShapedRecipeBuilder.m_126118_((ItemLike)slab, (int)6).m_126127_(Character.valueOf('B'), (ItemLike)item).m_126130_("BBB").m_142284_("has_item", (CriterionTriggerInstance)hasBlock).m_142409_(Objects.requireNonNull(slab.m_5456_().getRegistryName()).toString()).m_142700_(consumer, this.wrap((IForgeRegistryEntry<?>)item, folder, "_slab"));
        StairBlock stairs = saveing.getStairs();
        ShapedRecipeBuilder.m_126118_((ItemLike)stairs, (int)4).m_126127_(Character.valueOf('B'), (ItemLike)item).m_126130_("B  ").m_126130_("BB ").m_126130_("BBB").m_142284_("has_item", (CriterionTriggerInstance)hasBlock).m_142409_(Objects.requireNonNull(stairs.m_5456_().getRegistryName()).toString()).m_142700_(consumer, this.wrap((IForgeRegistryEntry<?>)item, folder, "_stairs"));
        if (addStonecutter) {
            Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
            SingleItemRecipeBuilder.m_126316_((Ingredient)ingredient, (ItemLike)slab, (int)2).m_142284_("has_item", (CriterionTriggerInstance)hasBlock).m_142700_(consumer, this.wrap((IForgeRegistryEntry<?>)item, folder, "_slab_stonecutter"));
            SingleItemRecipeBuilder.m_126313_((Ingredient)ingredient, (ItemLike)stairs).m_142284_("has_item", (CriterionTriggerInstance)hasBlock).m_142700_(consumer, this.wrap((IForgeRegistryEntry<?>)item, folder, "_stairs_stonecutter"));
        }
    }

    default public void stairSlabWallCrafting(Consumer<FinishedRecipe> consumer, WallBuildingBlockObject saveing, String folder, boolean addStonecutter) {
        this.slabStairsCrafting(consumer, saveing, folder, addStonecutter);
        Item item = saveing.m_5456_();
        InventoryChangeTrigger.TriggerInstance hasBlock = RecipeProvider.m_125977_((ItemLike)item);
        WallBlock wall = saveing.getWall();
        ShapedRecipeBuilder.m_126118_((ItemLike)wall, (int)6).m_126127_(Character.valueOf('B'), (ItemLike)item).m_126130_("BBB").m_126130_("BBB").m_142284_("has_item", (CriterionTriggerInstance)hasBlock).m_142409_(Objects.requireNonNull(wall.m_5456_().getRegistryName()).toString()).m_142700_(consumer, this.wrap((IForgeRegistryEntry<?>)item, folder, "_wall"));
        if (addStonecutter) {
            Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
            SingleItemRecipeBuilder.m_126313_((Ingredient)ingredient, (ItemLike)wall).m_142284_("has_item", (CriterionTriggerInstance)hasBlock).m_142700_(consumer, this.wrap((IForgeRegistryEntry<?>)item, folder, "_wall_stonecutter"));
        }
    }

    default public void woodCrafting(Consumer<FinishedRecipe> consumer, WoodBlockObject wood, String folder) {
        InventoryChangeTrigger.TriggerInstance hasPlanks = RecipeProvider.m_125977_((ItemLike)wood);
        ShapelessRecipeBuilder.m_126191_((ItemLike)wood, (int)4).m_206419_(wood.getLogItemTag()).m_142409_("planks").m_142284_("has_log", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(wood.getLogItemTag()).m_45077_()})).m_142700_(consumer, this.modResource(folder + "planks"));
        SlabBlock slab = wood.getSlab();
        ShapedRecipeBuilder.m_126118_((ItemLike)slab, (int)6).m_126127_(Character.valueOf('#'), (ItemLike)wood).m_126130_("###").m_142284_("has_planks", (CriterionTriggerInstance)hasPlanks).m_142409_("wooden_slab").m_142700_(consumer, this.modResource(folder + "slab"));
        StairBlock stairs = wood.getStairs();
        ShapedRecipeBuilder.m_126118_((ItemLike)stairs, (int)4).m_126127_(Character.valueOf('#'), (ItemLike)wood).m_126130_("#  ").m_126130_("## ").m_126130_("###").m_142284_("has_planks", (CriterionTriggerInstance)hasPlanks).m_142409_("wooden_stairs").m_142700_(consumer, this.modResource(folder + "stairs"));
        ShapedRecipeBuilder.m_126118_((ItemLike)wood.getWood(), (int)3).m_126127_(Character.valueOf('#'), (ItemLike)wood.getLog()).m_126130_("##").m_126130_("##").m_142409_("bark").m_142284_("has_log", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)wood.getLog())).m_142700_(consumer, this.modResource(folder + "log_to_wood"));
        ShapedRecipeBuilder.m_126118_((ItemLike)wood.getStrippedWood(), (int)3).m_126127_(Character.valueOf('#'), (ItemLike)wood.getStrippedLog()).m_126130_("##").m_126130_("##").m_142409_("bark").m_142284_("has_log", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)wood.getStrippedLog())).m_142700_(consumer, this.modResource(folder + "stripped_log_to_wood"));
        ShapedRecipeBuilder.m_126118_((ItemLike)wood.getFence(), (int)3).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_126127_(Character.valueOf('W'), (ItemLike)wood).m_126130_("W#W").m_126130_("W#W").m_142409_("wooden_fence").m_142284_("has_planks", (CriterionTriggerInstance)hasPlanks).m_142700_(consumer, this.modResource(folder + "fence"));
        ShapedRecipeBuilder.m_126116_((ItemLike)wood.getFenceGate()).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('W'), (ItemLike)wood).m_126130_("#W#").m_126130_("#W#").m_142409_("wooden_fence_gate").m_142284_("has_planks", (CriterionTriggerInstance)hasPlanks).m_142700_(consumer, this.modResource(folder + "fence_gate"));
        ShapedRecipeBuilder.m_126118_((ItemLike)wood.getDoor(), (int)3).m_126127_(Character.valueOf('#'), (ItemLike)wood).m_126130_("##").m_126130_("##").m_126130_("##").m_142409_("wooden_door").m_142284_("has_planks", (CriterionTriggerInstance)hasPlanks).m_142700_(consumer, this.modResource(folder + "door"));
        ShapedRecipeBuilder.m_126118_((ItemLike)wood.getTrapdoor(), (int)2).m_126127_(Character.valueOf('#'), (ItemLike)wood).m_126130_("###").m_126130_("###").m_142409_("wooden_trapdoor").m_142284_("has_planks", (CriterionTriggerInstance)hasPlanks).m_142700_(consumer, this.modResource(folder + "trapdoor"));
        ShapelessRecipeBuilder.m_126189_((ItemLike)wood.getButton()).m_126209_((ItemLike)wood).m_142409_("wooden_button").m_142284_("has_planks", (CriterionTriggerInstance)hasPlanks).m_142700_(consumer, this.modResource(folder + "button"));
        ShapedRecipeBuilder.m_126116_((ItemLike)wood.getPressurePlate()).m_126127_(Character.valueOf('#'), (ItemLike)wood).m_126130_("##").m_142409_("wooden_pressure_plate").m_142284_("has_planks", (CriterionTriggerInstance)hasPlanks).m_142700_(consumer, this.modResource(folder + "pressure_plate"));
        ShapedRecipeBuilder.m_126118_((ItemLike)wood.getSign(), (int)3).m_142409_("sign").m_126127_(Character.valueOf('#'), (ItemLike)wood).m_206416_(Character.valueOf('X'), Tags.Items.RODS_WOODEN).m_126130_("###").m_126130_("###").m_126130_(" X ").m_142284_("has_planks", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)wood)).m_142700_(consumer, this.modResource(folder + "sign"));
    }
}

