/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.widget.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class WidgetScreen<T extends Widget>
extends Screen {
    protected final T widget;
    private boolean initialized = false;
    private boolean isPauseScreen = false;

    public static <T extends Widget> WidgetScreen<T> of(T widget) {
        return new WidgetScreen<T>(widget);
    }

    public static <T extends Widget> WidgetScreen<T> of(T widget, boolean isPauseScreen) {
        return new WidgetScreen<T>(widget, isPauseScreen);
    }

    public WidgetScreen(T widget, boolean isPauseScreen) {
        super((Component)TextComponents.empty().get());
        this.widget = widget;
        this.isPauseScreen = isPauseScreen;
    }

    public WidgetScreen(T widget) {
        this(widget, false);
    }

    protected void m_7856_() {
        if (!this.initialized) {
            this.widget.initialize();
            this.initialized = true;
        }
    }

    public void m_7379_() {
        this.widget.discard();
        super.m_7379_();
    }

    public void m_96624_() {
        this.widget.update();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        int offsetX = (this.f_96543_ - this.widget.width()) / 2;
        int offsetY = (this.f_96544_ - this.widget.height()) / 2;
        RenderSystem.m_157191_().m_85836_();
        RenderSystem.m_157191_().m_85837_((double)offsetX, (double)offsetY, 0.0);
        RenderSystem.m_157182_();
        this.widget.setFocused((mouseX -= offsetX) >= 0 && mouseX < this.widget.width() && (mouseY -= offsetY) >= 0 && mouseY < this.widget.height());
        this.widget.renderBackground(poseStack, mouseX, mouseY);
        this.widget.render(poseStack, mouseX, mouseY);
        this.widget.renderForeground(poseStack, mouseX, mouseY);
        this.widget.renderOverlay(poseStack, mouseX, mouseY);
        this.widget.renderTooltips(poseStack, mouseX, mouseY);
        RenderSystem.m_157191_().m_85849_();
        RenderSystem.m_157182_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.f_96543_ - this.widget.width()) / 2;
        return this.widget.mousePressed((int)(mouseX -= (double)offsetX), (int)(mouseY -= (double)(offsetY = (this.f_96544_ - this.widget.height()) / 2)), button, false) || super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.f_96543_ - this.widget.width()) / 2;
        return this.widget.mouseReleased((int)(mouseX -= (double)offsetX), (int)(mouseY -= (double)(offsetY = (this.f_96544_ - this.widget.height()) / 2)), button, false) || super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        int offsetY;
        int offsetX = (this.f_96543_ - this.widget.width()) / 2;
        return this.widget.mouseScrolled((int)(mouseX -= (double)offsetX), (int)(mouseY -= (double)(offsetY = (this.f_96544_ - this.widget.height()) / 2)), amount, false) || super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.widget.keyPressed(keyCode, false)) {
            return true;
        }
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (ClientUtils.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.widget.keyReleased(keyCode, false) || super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char character, int modifiers) {
        return this.widget.charTyped(character, false) || super.m_5534_(character, modifiers);
    }

    public boolean m_7043_() {
        return this.isPauseScreen;
    }

    public Component m_142562_() {
        Component message = this.widget.getNarrationMessage();
        return message == null ? TextComponents.empty().get() : message;
    }
}

