/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.modifier;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class AridZoneModifier
extends Modifier {
    public void onBreakSpeed(@Nonnull IToolStackView tool, int level, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Level world = event.getEntityLiving().f_19853_;
        float coeff = this.calcArid(world, event.getPos());
        event.setNewSpeed(event.getNewSpeed() + event.getOriginalSpeed() * coeff);
    }

    public float getEntityDamage(@Nonnull IToolStackView tool, int level, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        float extraDamage = 2.0f * this.calcArid(context.getAttacker().f_19853_, context.getAttacker().m_142538_());
        return super.getEntityDamage(tool, level, context, baseDamage, damage) + extraDamage;
    }

    private float calcArid(Level level, BlockPos pos) {
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        float rain = level.m_46471_() ? biome.m_47548_() / 2.0f : 0.0f;
        return (float)Math.pow(1.25, 3.0 * (double)(0.5f + biome.m_47554_() - biome.m_47548_()) - 1.25) - rain;
    }

    public void addInformation(@Nonnull IToolStackView tool, int level, @Nullable Player player, @Nonnull List<Component> tooltip, @Nonnull TooltipKey tooltipKey, @Nonnull TooltipFlag tooltipFlag) {
        if (player != null) {
            float calc = this.calcArid(player.f_19853_, player.m_142538_());
            float baseStat = ((Float)tool.getStats().get((IToolStat)ToolStats.MINING_SPEED)).floatValue() * calc;
            float extraDmg = calc * 2.0f;
            this.addMiningSpeedToolTip(tool, (float)Math.floor(baseStat), tooltip);
            this.addDamageTooltip(tool, (float)Math.floor(extraDmg), tooltip);
        }
    }

    public void addMiningSpeedToolTip(IToolStackView tool, float amount, List<Component> tooltip) {
        this.addStatTooltip(tool, ToolStats.MINING_SPEED, TinkerTags.Items.MELEE_OR_UNARMED, amount, tooltip);
    }
}

