/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.tom.createores.recipe.ExcavatingRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class DrillingRecipe
extends ExcavatingRecipe {
    public NonNullList<ProcessingOutput> output;
    public FluidIngredient drillingFluid;

    public DrillingRecipe(ResourceLocation id, RecipeType<?> type, RecipeSerializer<?> serializer) {
        super(id, type, serializer);
    }

    @Override
    public String m_6076_() {
        return "drilling";
    }

    public String toString() {
        return String.format("DrillingRecipe [id=%s, drill=%s, output=%s, drillingFluid=%s, weight=%s, ticks=%s]", this.id, this.drill, this.output, this.drillingFluid, this.weight, this.ticks);
    }

    @Override
    protected void fromJson(JsonObject json) {
        this.output = NonNullList.m_122779_();
        for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"output")) {
            this.output.add((Object)ProcessingOutput.deserialize((JsonElement)je));
        }
        this.drillingFluid = FluidIngredient.EMPTY;
        if (GsonHelper.m_13900_((JsonObject)json, (String)"fluid")) {
            this.drillingFluid = FluidIngredient.deserialize((JsonElement)json.get("fluid"));
        }
    }

    @Override
    protected void toJson(JsonObject json) {
        JsonArray ar = new JsonArray();
        this.output.stream().map(ProcessingOutput::serialize).forEach(arg_0 -> ((JsonArray)ar).add(arg_0));
        json.add("output", (JsonElement)ar);
        if (this.drillingFluid != FluidIngredient.EMPTY) {
            json.add("fluid", (JsonElement)this.drillingFluid.serialize());
        }
    }

    @Override
    protected void fromNetwork(FriendlyByteBuf buffer) {
        this.output = NonNullList.m_122779_();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            this.output.add((Object)ProcessingOutput.read((FriendlyByteBuf)buffer));
        }
        this.drillingFluid = buffer.readBoolean() ? FluidIngredient.read((FriendlyByteBuf)buffer) : FluidIngredient.EMPTY;
    }

    @Override
    protected void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.output.size());
        this.output.forEach(o -> o.write(buffer));
        if (this.drillingFluid.getRequiredAmount() == 0) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            this.drillingFluid.write(buffer);
        }
    }

    public NonNullList<ProcessingOutput> getOutput() {
        return this.output;
    }

    public FluidIngredient getDrillingFluid() {
        return this.drillingFluid;
    }
}

