/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.tom.createores.jei.AnimatedBlock;
import com.tom.createores.jei.ItemIcon;
import com.tom.createores.recipe.ExcavatingRecipe;
import com.tom.createores.util.NumberFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;

public abstract class ExcavatingCategory<T extends ExcavatingRecipe>
implements IRecipeCategory<T> {
    protected AnimatedBlock block;
    protected IDrawable background = new EmptyBackground(177, 100);
    protected IDrawable icon;
    protected IDrawable biomeWIcon = new ItemIcon(() -> new ItemStack((ItemLike)Items.f_42799_));
    protected IDrawable biomeBIcon = new DoubleItemIcon(() -> new ItemStack((ItemLike)Items.f_42799_), () -> new ItemStack((ItemLike)Items.f_42127_));
    private static long lastBiomeChangeTime;
    private static int biomePage;

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    public abstract RecipeType<T> getRecipeType();

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 51, 3).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addIngredients(((ExcavatingRecipe)recipe).getDrill());
    }

    public Class<? extends T> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        this.block.draw(stack, 48, 35);
        this.biomeWIcon.draw(stack, 100, 5);
        this.biomeBIcon.draw(stack, 100, 25);
    }

    public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (mouseX > 100.0 && mouseX < 118.0) {
            if (mouseY > 5.0 && mouseY < 23.0) {
                tooltip.add((Component)new TranslatableComponent("tooltip.coe.biome.whitelist"));
                ExcavatingCategory.listBiomes(((ExcavatingRecipe)recipe).biomeWhitelist, tooltip);
            } else if (mouseY > 25.0 && mouseY < 43.0) {
                tooltip.add((Component)new TranslatableComponent("tooltip.coe.biome.blacklist"));
                ExcavatingCategory.listBiomes(((ExcavatingRecipe)recipe).biomeBlacklist, tooltip);
            } else {
                biomePage = 0;
                lastBiomeChangeTime = 0L;
            }
        }
        if (mouseX > 40.0 && mouseX < 80.0 && mouseY > 25.0 && mouseY < 60.0) {
            tooltip.add(((ExcavatingRecipe)recipe).getName());
            tooltip.add((Component)new TranslatableComponent("tooltip.coe.processTime", new Object[]{((ExcavatingRecipe)recipe).getTicks()}));
            if (((ExcavatingRecipe)recipe).isInfiniteClient()) {
                tooltip.add((Component)new TranslatableComponent("tooltip.coe.infiniteVeins"));
            } else {
                tooltip.add((Component)new TranslatableComponent("tooltip.coe.finiteVeins", new Object[]{NumberFormatter.formatNumber(((ExcavatingRecipe)recipe).getMinAmountClient()), NumberFormatter.formatNumber(((ExcavatingRecipe)recipe).getMaxAmountClient())}));
            }
        }
        return tooltip;
    }

    private static void listBiomes(TagKey<Biome> tag, List<Component> tooltip) {
        boolean isShift = Screen.m_96638_();
        Minecraft.m_91087_().m_91403_().m_105152_().m_175515_(Registry.f_122885_).m_203431_(tag).map(t -> {
            Stream<Holder> s = t.m_203614_();
            int size = t.m_203632_();
            TranslatableComponent pg = null;
            if (size > 16) {
                if (!isShift && System.currentTimeMillis() - lastBiomeChangeTime > 2000L) {
                    if (++biomePage * 16 >= size) {
                        biomePage = 0;
                    }
                    lastBiomeChangeTime = System.currentTimeMillis();
                }
                pg = new TranslatableComponent("tooltip.coe.page", new Object[]{biomePage + 1, size / 16 + 1});
                s = s.skip(biomePage * 16).limit(16L);
            }
            List comps = s.map(ExcavatingCategory::getBiomeId).map(b -> new TranslatableComponent("biome." + b.m_135827_() + "." + b.m_135815_())).collect(Collectors.toList());
            if (pg != null) {
                comps.add(pg);
            }
            return comps;
        }).ifPresent(tooltip::addAll);
    }

    private static ResourceLocation getBiomeId(Holder<Biome> h) {
        try {
            if (h.m_203376_() == Holder.Kind.DIRECT) {
                return ((Biome)h.m_203334_()).getRegistryName();
            }
            return ((Holder.Reference)h).m_205785_().m_135782_();
        }
        catch (Exception e) {
            return new ResourceLocation("null");
        }
    }
}

