/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.item;

import com.tom.createores.CreateOreExcavation;
import com.tom.createores.OreDataCapability;
import com.tom.createores.util.ComponentJoiner;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class OreVeinFinderItem
extends Item {
    public OreVeinFinderItem() {
        super(new Item.Properties().m_41491_(CreateOreExcavation.MOD_TAB).m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        if (!level.f_46443_) {
            this.detect(level, player.m_142538_(), player);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(interactionHand));
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (!ctx.m_43725_().f_46443_) {
            this.detect(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43723_());
        }
        return InteractionResult.SUCCESS;
    }

    private void detect(Level level, BlockPos pos, Player player) {
        ChunkPos center = new ChunkPos(pos);
        OreDataCapability.OreData found = null;
        ArrayList<OreDataCapability.OreData> nearby = new ArrayList<OreDataCapability.OreData>();
        ArrayList<OreDataCapability.OreData> far = new ArrayList<OreDataCapability.OreData>();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                OreDataCapability.OreData d2 = OreDataCapability.getData(level.m_6325_(center.f_45578_ + x, center.f_45579_ + z));
                if (x == 0 && z == 0) {
                    found = d2;
                    continue;
                }
                if (Math.abs(x) <= 1 && Math.abs(z) <= 1) {
                    nearby.add(d2);
                    continue;
                }
                far.add(d2);
            }
        }
        player.m_5661_((Component)new TranslatableComponent("chat.coe.veinFinder.info"), false);
        player.m_5661_((Component)new TranslatableComponent("chat.coe.veinFinder.pos", new Object[]{center.f_45578_, center.f_45579_}), false);
        RecipeManager m = level.m_7465_();
        TranslatableComponent nothing = new TranslatableComponent("chat.coe.veinFinder.nothing");
        TextComponent comma = new TextComponent(", ");
        Object f = found != null && found.getRecipe(m) != null ? found.getRecipe(m).getName() : nothing;
        player.m_5661_((Component)new TranslatableComponent("chat.coe.veinFinder.found", new Object[]{f}), false);
        f = nearby.stream().map(d -> d.getRecipe(m)).filter(r -> r != null).map(r -> r.getName()).collect(ComponentJoiner.joining((Component)nothing, (Component)comma));
        player.m_5661_((Component)new TranslatableComponent("chat.coe.veinFinder.nearby", new Object[]{f}), false);
        f = far.stream().map(d -> d.getRecipe(m)).filter(r -> r != null).map(r -> r.getName()).collect(ComponentJoiner.joining((Component)nothing, (Component)comma));
        player.m_5661_((Component)new TranslatableComponent("chat.coe.veinFinder.far", new Object[]{f}), false);
    }
}

