/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.OreDataCapability;
import com.tom.createores.block.entity.IDrill;
import com.tom.createores.block.entity.MultiblockCapHandler;
import com.tom.createores.client.ClientUtil;
import com.tom.createores.recipe.ExcavatingRecipe;
import com.tom.createores.recipe.IRecipe;
import com.tom.createores.util.NumberFormatter;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class ExcavatingBlockEntity<R extends ExcavatingRecipe>
extends SmartBlockEntity
implements MultiblockCapHandler,
IDrill,
IHaveGoggleInformation {
    protected int progress;
    protected MultiblockCapHandler.Kinetic kinetic;
    protected ResourceLocation recipeClient;
    protected long resourceRemClient;
    protected boolean hasRotation;
    protected ItemStack drillStack;
    protected R current;
    protected OreDataCapability.OreData data;
    protected ExcavatorState state = ExcavatorState.NO_VEIN;

    protected ExcavatingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.drillStack = ItemStack.f_41583_;
        this.setLazyTickRate(20);
    }

    protected abstract boolean instanceofCheck(Object var1);

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ExcavatingRecipe rec = this.recipeClient != null ? (ExcavatingRecipe)this.f_58857_.m_7465_().m_44043_(this.recipeClient).filter(this::instanceofCheck).map(r -> (ExcavatingRecipe)r).orElse(null) : null;
        Component vein = rec != null ? rec.getName() : new TranslatableComponent("chat.coe.veinFinder.nothing");
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("chat.coe.veinFinder.found", new Object[]{vein})));
        if (!this.hasRotation) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translateDirect((String)"tooltip.speedRequirement", (Object[])new Object[0]).m_130940_(ChatFormatting.GOLD)));
            MutableComponent hint = Lang.translateDirect((String)"gui.contraptions.not_fast_enough", (Object[])new Object[]{I18n.m_118938_((String)this.m_58900_().m_60734_().m_7705_(), (Object[])new Object[0])});
            List cutString = TooltipHelper.cutTextComponent((Component)hint, (TooltipHelper.Palette)TooltipHelper.Palette.GRAY_AND_WHITE);
            for (int i = 0; i < cutString.size(); ++i) {
                tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)cutString.get(i)));
            }
        }
        if (this.drillStack.m_41619_()) {
            tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("info.coe.drill.noDrill")));
        } else {
            tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("info.coe.drill.installed", new Object[]{this.drillStack.m_41786_()})));
        }
        if (rec != null) {
            tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("info.coe.drill.progress")).m_130946_(": [").m_7220_(ClientUtil.makeProgressBar((float)this.progress / (float)rec.getTicks())).m_130946_("]"));
            if (this.resourceRemClient != 0L) {
                tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("info.coe.drill.resourceRemaining", new Object[]{NumberFormatter.formatNumber(this.resourceRemClient)})));
            }
            if (!rec.getDrill().test(this.drillStack)) {
                tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("info.coe.drill.badDrill")));
            }
            this.addToGoggleTooltip(tooltip, rec);
        }
        if (this.state != ExcavatorState.NO_ERROR) {
            tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("info.coe.drill.err_" + this.state.name().toLowerCase())));
        }
        return true;
    }

    public void addToGoggleTooltip(List<Component> tooltip, R recipe) {
    }

    private R getRecipe() {
        IRecipe r;
        ChunkPos p = new ChunkPos(this.f_58858_);
        this.data = OreDataCapability.getData(this.f_58857_.m_6325_(p.f_45578_, p.f_45579_));
        RecipeManager m = this.f_58857_.m_7465_();
        if (this.data != null && (r = this.data.getRecipe(m)) != null && this.instanceofCheck(r)) {
            return (R)((ExcavatingRecipe)r);
        }
        return null;
    }

    protected abstract boolean canExtract();

    protected abstract void onFinished();

    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_) {
            if (this.current != null && this.state == ExcavatorState.NO_ERROR) {
                if (this.kinetic != null) {
                    this.kinetic.setStress(((ExcavatingRecipe)this.current).getStress());
                }
                if (this.canExtract() && this.kinetic != null && this.kinetic.getRotationSpeed() >= IRotate.SpeedLevel.MEDIUM.getSpeedValue() && ((ExcavatingRecipe)this.current).getDrill().test(this.drillStack)) {
                    float prg = this.kinetic.getRotationSpeed() / IRotate.SpeedLevel.MEDIUM.getSpeedValue();
                    this.progress = (int)((float)this.progress + prg);
                    if (this.progress >= ((ExcavatingRecipe)this.current).getTicks()) {
                        this.updateState();
                        if (this.state == ExcavatorState.NO_ERROR) {
                            this.onFinished();
                            this.data.extract(1);
                        }
                        this.progress = 0;
                    }
                }
            } else if (this.progress > 10) {
                this.progress = 0;
                this.updateState();
            } else {
                ++this.progress;
            }
        }
    }

    private void updateState() {
        this.current = this.getRecipe();
        this.state = this.current == null ? ExcavatorState.NO_VEIN : (!this.data.canExtract(this.f_58857_, this.f_58858_) ? ExcavatorState.TOO_MANY_EXCAVATORS : (this.data.getResourcesRemaining((IRecipe)this.current) == -1L ? ExcavatorState.VEIN_EMPTY : ExcavatorState.NO_ERROR));
        this.notifyUpdate();
    }

    public void lazyTick() {
        this.notifyUpdate();
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.progress = tag.m_128451_("progress");
        this.drillStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("drill"));
        if (clientPacket) {
            this.state = ExcavatorState.VALUES[tag.m_128445_("state")];
            if (tag.m_128441_("veinName")) {
                this.recipeClient = new ResourceLocation(tag.m_128461_("veinName"));
                this.resourceRemClient = tag.m_128454_("resRem");
            } else {
                this.recipeClient = null;
            }
            this.hasRotation = tag.m_128471_("hasRot");
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128405_("progress", this.progress);
        tag.m_128365_("drill", (Tag)this.drillStack.serializeNBT());
        if (clientPacket) {
            tag.m_128344_("state", (byte)this.state.ordinal());
            if (this.current != null) {
                tag.m_128359_("veinName", ((ExcavatingRecipe)this.current).getRecipeId().toString());
                tag.m_128356_("resRem", this.data.getResourcesRemaining((IRecipe)this.current));
            }
            tag.m_128379_("hasRot", this.kinetic != null && this.kinetic.getRotationSpeed() >= IRotate.SpeedLevel.MEDIUM.getSpeedValue());
        }
    }

    public void initialize() {
        super.initialize();
        if (!this.f_58857_.f_46443_) {
            if (this.progress > 0 && this.current == null) {
                this.current = this.getRecipe();
            }
            if (this.current == null) {
                this.progress = 0;
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.recipeClient != null;
    }

    @Override
    public ItemStack getDrill() {
        return this.drillStack;
    }

    @Override
    public BlockPos getBelow() {
        return this.f_58858_.m_6625_(2);
    }

    @Override
    public void addKinetic(MultiblockCapHandler.Kinetic k) {
        this.kinetic = k;
    }

    @Override
    public void dropInv() {
        this.dropItemStack(this.drillStack);
    }

    public InteractionResult onClick(Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (!item.m_41619_() && item.m_204117_(CreateOreExcavation.DRILL_TAG)) {
            if (this.drillStack.m_41619_()) {
                if (!this.f_58857_.f_46443_) {
                    this.drillStack = item.m_41620_(1);
                }
                this.notifyUpdate();
                return InteractionResult.SUCCESS;
            }
        } else if (item.m_41619_() && !this.drillStack.m_41619_()) {
            if (!this.f_58857_.f_46443_) {
                if (player.m_36356_(this.drillStack)) {
                    this.drillStack = ItemStack.f_41583_;
                    this.notifyUpdate();
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void dropItemStack(ItemStack stackInSlot) {
        Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stackInSlot);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_.m_142082_(-1, -1, -1), this.f_58858_.m_142082_(1, 0, 1));
    }

    public static enum ExcavatorState {
        NO_ERROR,
        NO_VEIN,
        VEIN_EMPTY,
        TOO_MANY_EXCAVATORS;

        public static final ExcavatorState[] VALUES;

        static {
            VALUES = ExcavatorState.values();
        }
    }
}

