/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.guis.screens.planetselection;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.mrscauthd.beyond_earth.BeyondEarthMod;
import net.mrscauthd.beyond_earth.crafting.IngredientStack;
import net.mrscauthd.beyond_earth.crafting.SpaceStationRecipe;
import net.mrscauthd.beyond_earth.events.forge.PlanetSelectionGuiBackgroundRenderEvent;
import net.mrscauthd.beyond_earth.events.forge.PlanetSelectionGuiButtonVisibilityEvent;
import net.mrscauthd.beyond_earth.events.forge.PlanetSelectionGuiInitEvent;
import net.mrscauthd.beyond_earth.events.forge.PlanetSelectionGuiRenderEvent;
import net.mrscauthd.beyond_earth.guis.helper.ImageButtonPlacer;
import net.mrscauthd.beyond_earth.guis.screens.planetselection.PlanetSelectionGui;
import net.mrscauthd.beyond_earth.guis.screens.planetselection.helper.CategoryHelper;
import net.mrscauthd.beyond_earth.guis.screens.planetselection.helper.PlanetSelectionGuiHelper;

@OnlyIn(value=Dist.CLIENT)
public class PlanetSelectionGuiWindow
extends AbstractContainerScreen<PlanetSelectionGui.GuiContainer> {
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("beyond_earth", "textures/screens/planet_selection.png");
    public static final ResourceLocation SCROLLER_TEXTURE = new ResourceLocation("beyond_earth", "textures/scroller.png");
    public static final ResourceLocation GREEN_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/buttons/green_button.png");
    public static final ResourceLocation GREEN_LIGHT_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/buttons/green_button_2.png");
    public static final ResourceLocation RED_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/buttons/red_button.png");
    public static final ResourceLocation RED_LIGHT_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/buttons/red_button_2.png");
    public static final ResourceLocation DARK_BLUE_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/buttons/dark_blue_button.png");
    public static final ResourceLocation DARK_BLUE_LIGHT_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/buttons/dark_blue_button_2.png");
    public static final ResourceLocation BLUE_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/buttons/blue_button.png");
    public static final ResourceLocation BLUE_LIGHT_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/buttons/blue_button_2.png");
    public static final ResourceLocation SMALL_BLUE_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/buttons/small_blue_button.png");
    public static final ResourceLocation SMALL_BLUE_LIGHT_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/buttons/small_blue_button_2.png");
    public static final ResourceLocation LARGE_GREEN_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/buttons/big_green_button.png");
    public static final ResourceLocation LARGE_GREEN_LIGHT_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/buttons/big_green_button_2.png");
    public static final ResourceLocation LARGE_RED_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/buttons/big_red_button.png");
    public static final ResourceLocation LARGE_RED_LIGHT_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/buttons/big_red_button_2.png");
    public static final ResourceLocation MILKY_WAY_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/gui/milky_way.png");
    public static final ResourceLocation SUN_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/gui/sun.png");
    public static final ResourceLocation BLUE_SUN_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/gui/blue_sun.png");
    public static final ResourceLocation MARS_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/gui/mars.png");
    public static final ResourceLocation EARTH_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/gui/earth.png");
    public static final ResourceLocation VENUS_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/gui/venus.png");
    public static final ResourceLocation MERCURY_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/gui/mercury.png");
    public static final ResourceLocation GLACIO_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/gui/glacio.png");
    public static final ResourceLocation SMALL_MENU_LIST = new ResourceLocation("beyond_earth", "textures/rocket_menu_list.png");
    public static final ResourceLocation LARGE_MENU_TEXTURE = new ResourceLocation("beyond_earth", "textures/rocket_menu_list_2.png");
    public static final Component CATALOG_TEXT = PlanetSelectionGuiHelper.tl("catalog");
    public static final Component BACK_TEXT = PlanetSelectionGuiHelper.tl("back");
    public static final Component SUN_TEXT = PlanetSelectionGuiHelper.tl("sun");
    public static final Component PROXIMA_CENTAURI_TEXT = PlanetSelectionGuiHelper.tl("proxima_centauri");
    public static final Component SOLAR_SYSTEM_TEXT = PlanetSelectionGuiHelper.tl("solar_system");
    public static final Component SOLAR_SYSTEM_SUN_TEXT = PlanetSelectionGuiHelper.tl("solar_system_sun");
    public static final Component SOLAR_SYSTEM_PROXIMA_CENTAURI_TEXT = PlanetSelectionGuiHelper.tl("solar_system_proxima_centauri");
    public static final Component EARTH_TEXT = PlanetSelectionGuiHelper.tl("earth");
    public static final Component MARS_TEXT = PlanetSelectionGuiHelper.tl("mars");
    public static final Component MERCURY_TEXT = PlanetSelectionGuiHelper.tl("mercury");
    public static final Component VENUS_TEXT = PlanetSelectionGuiHelper.tl("venus");
    public static final Component GLACIO_TEXT = PlanetSelectionGuiHelper.tl("glacio");
    public static final Component PLANET_TEXT = PlanetSelectionGuiHelper.tl("planet");
    public static final Component MOON_TEXT = PlanetSelectionGuiHelper.tl("moon");
    public static final Component ORBIT_TEXT = PlanetSelectionGuiHelper.tl("orbit");
    public static final Component NO_GRAVITY_TEXT = PlanetSelectionGuiHelper.tl("no_gravity");
    public static final Component SPACE_STATION_TEXT = PlanetSelectionGuiHelper.tl("space_station");
    public static final Component CATEGORY_TEXT = PlanetSelectionGuiHelper.tl("category");
    public static final Component PROVIDED_TEXT = PlanetSelectionGuiHelper.tl("provided");
    public static final Component TYPE_TEXT = PlanetSelectionGuiHelper.tl("type");
    public static final Component GRAVITY_TEXT = PlanetSelectionGuiHelper.tl("gravity");
    public static final Component OXYGEN_TEXT = PlanetSelectionGuiHelper.tl("oxygen");
    public static final Component TEMPERATURE_TEXT = PlanetSelectionGuiHelper.tl("temperature");
    public static final Component OXYGEN_TRUE_TEXT = PlanetSelectionGuiHelper.tl("oxygen.true");
    public static final Component OXYGEN_FALSE_TEXT = PlanetSelectionGuiHelper.tl("oxygen.false");
    public static final Component ITEM_REQUIREMENT_TEXT = PlanetSelectionGuiHelper.tl("item_requirement");
    public static final Component ROCKET_TIER_1_TEXT = new TranslatableComponent("entity.beyond_earth.rocket_t1");
    public static final Component ROCKET_TIER_2_TEXT = new TranslatableComponent("entity.beyond_earth.rocket_t2");
    public static final Component ROCKET_TIER_3_TEXT = new TranslatableComponent("entity.beyond_earth.rocket_t3");
    public static final Component ROCKET_TIER_4_TEXT = new TranslatableComponent("entity.beyond_earth.rocket_t4");
    public CategoryHelper category;
    public List<ImageButtonPlacer> visibleButtons;
    public float rotationMilkyWay;
    public float rotationMars;
    public float rotationEarth;
    public float rotationVenus;
    public float rotationMercury;
    public float rotationGlacio;
    public ImageButtonPlacer solarSystemButton;
    public ImageButtonPlacer proximaCentauriButton;
    public ImageButtonPlacer earthCategoryButton;
    public ImageButtonPlacer marsCategoryButton;
    public ImageButtonPlacer mercuryCategoryButton;
    public ImageButtonPlacer venusCategoryButton;
    public ImageButtonPlacer glacioCategoryButton;
    public ImageButtonPlacer earthButton;
    public ImageButtonPlacer moonButton;
    public ImageButtonPlacer marsButton;
    public ImageButtonPlacer mercuryButton;
    public ImageButtonPlacer venusButton;
    public ImageButtonPlacer glacioButton;
    public ImageButtonPlacer backButton;
    public ImageButtonPlacer earthOrbitButton;
    public ImageButtonPlacer moonOrbitButton;
    public ImageButtonPlacer marsOrbitButton;
    public ImageButtonPlacer mercuryOrbitButton;
    public ImageButtonPlacer venusOrbitButton;
    public ImageButtonPlacer glacioOrbitButton;
    public ImageButtonPlacer earthSpaceStationButton;
    public ImageButtonPlacer moonSpaceStationButton;
    public ImageButtonPlacer marsSpaceStationButton;
    public ImageButtonPlacer mercurySpaceStationButton;
    public ImageButtonPlacer venusSpaceStationButton;
    public ImageButtonPlacer glacioSpaceStationButton;
    public SpaceStationRecipe recipe;
    public boolean spaceStationItemList;
    public int scrollIndex;
    public int rowEnd;

    public PlanetSelectionGuiWindow(PlanetSelectionGui.GuiContainer container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 512;
        this.f_97727_ = 512;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
        if (MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionGuiRenderEvent.Pre((Screen)this, poseStack, partialTicks, mouseX, mouseY))) {
            return;
        }
        this.f_96547_.m_92889_(poseStack, CATALOG_TEXT, 24.0f, (float)(this.f_96544_ / 2 - 71), -1);
        MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionGuiRenderEvent.Post((Screen)this, poseStack, partialTicks, mouseX, mouseY));
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        if (MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionGuiBackgroundRenderEvent.Pre((Screen)this, poseStack, partialTicks, mouseX, mouseY))) {
            return;
        }
        PlanetSelectionGuiHelper.enableRenderSystem();
        PlanetSelectionGuiHelper.addTexture(poseStack, 0, 0, this.f_96543_, this.f_96544_, BACKGROUND_TEXTURE);
        if (PlanetSelectionGuiHelper.categoryRange(this.category.get(), 1, 5)) {
            PlanetSelectionGuiHelper.addCircle(this.f_96543_ / 2, this.f_96544_ / 2, 23.0, 180);
            PlanetSelectionGuiHelper.addCircle(this.f_96543_ / 2, this.f_96544_ / 2, 46.0, 180);
            PlanetSelectionGuiHelper.addCircle(this.f_96543_ / 2, this.f_96544_ / 2, 69.5, 180);
            PlanetSelectionGuiHelper.addCircle(this.f_96543_ / 2, this.f_96544_ / 2, 92.0, 180);
        }
        if (PlanetSelectionGuiHelper.categoryRange(this.category.get(), 6, 7)) {
            PlanetSelectionGuiHelper.addCircle(this.f_96543_ / 2, this.f_96544_ / 2, 23.0, 180);
        }
        this.rotateObjects(partialTicks);
        this.renderRotatedObjects(poseStack);
        if (PlanetSelectionGuiHelper.categoryRange(this.category.get(), 1, 5)) {
            PlanetSelectionGuiHelper.addTexture(poseStack, (this.f_96543_ - 15) / 2, (this.f_96544_ - 15) / 2, 15, 15, SUN_TEXTURE);
        }
        if (PlanetSelectionGuiHelper.categoryRange(this.category.get(), 6, 7)) {
            PlanetSelectionGuiHelper.addTexture(poseStack, (this.f_96543_ - 15) / 2, (this.f_96544_ - 15) / 2, 15, 15, BLUE_SUN_TEXTURE);
        }
        if (PlanetSelectionGuiHelper.categoryRange(this.category.get(), 0, 1) || PlanetSelectionGuiHelper.categoryRange(this.category.get(), 6, 6)) {
            PlanetSelectionGuiHelper.addTexture(poseStack, 0, this.f_96544_ / 2 - 88, 105, 177, SMALL_MENU_LIST);
            this.renderScroller(poseStack);
        }
        if (PlanetSelectionGuiHelper.categoryRange(this.category.get(), 2, 5) || PlanetSelectionGuiHelper.categoryRange(this.category.get(), 7, 7)) {
            PlanetSelectionGuiHelper.addTexture(poseStack, 0, this.f_96544_ / 2 - 88, 215, 177, LARGE_MENU_TEXTURE);
        }
        PlanetSelectionGuiHelper.disableRenderSystem();
        MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionGuiBackgroundRenderEvent.Post((Screen)this, poseStack, partialTicks, mouseX, mouseY));
    }

    protected void m_7856_() {
        super.m_7856_();
        if (MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionGuiInitEvent.Pre((Screen)this))) {
            return;
        }
        this.rowEnd = 5;
        this.category = new CategoryHelper();
        this.rotationMilkyWay = 0.0f;
        this.rotationMars = 0.0f;
        this.rotationEarth = 90.0f;
        this.rotationVenus = 180.0f;
        this.rotationMercury = 270.0f;
        this.rotationGlacio = 180.0f;
        this.scrollIndex = 0;
        this.recipe = this.f_96541_.f_91073_.m_7465_().m_44043_(SpaceStationRecipe.KEY).orElse(null);
        this.spaceStationItemList = this.recipe.getIngredientStacks().stream().allMatch(this::getSpaceStationItemCheck);
        this.visibleButtons = Lists.newArrayList();
        this.solarSystemButton = PlanetSelectionGuiHelper.addCategoryButton(this, this.category, 10, 1, 70, 20, 1, true, ImageButtonPlacer.Types.MILKY_WAY_CATEGORY, List.of(SUN_TEXT.getString()), BLUE_BUTTON_TEXTURE, BLUE_LIGHT_BUTTON_TEXTURE, SOLAR_SYSTEM_SUN_TEXT);
        this.visibleButton(this.solarSystemButton, false);
        this.backButton = PlanetSelectionGuiHelper.addBackButton(this, 10, 1, 70, 20, DARK_BLUE_BUTTON_TEXTURE, DARK_BLUE_LIGHT_BUTTON_TEXTURE, BACK_TEXT, onPress -> {
            if (this.category.get() == 1) {
                this.category.set(0);
                this.scrollIndex = 0;
                this.updateButtonVisibility();
            } else if (PlanetSelectionGuiHelper.categoryRange(this.category.get(), 2, 5)) {
                this.category.set(1);
                this.scrollIndex = 0;
                this.updateButtonVisibility();
            } else if (this.category.get() == 6) {
                this.category.set(0);
                this.scrollIndex = 0;
                this.updateButtonVisibility();
            } else if (PlanetSelectionGuiHelper.categoryRange(this.category.get(), 7, 7)) {
                this.category.set(6);
                this.scrollIndex = 0;
                this.updateButtonVisibility();
            }
        });
        this.visibleButton(this.backButton, false);
        this.earthCategoryButton = PlanetSelectionGuiHelper.addCategoryButton(this, this.category, 10, 1, 70, 20, 2, this.checkTier(1), ImageButtonPlacer.Types.SOLAR_SYSTEM_CATEGORY, List.of(EARTH_TEXT.getString(), ROCKET_TIER_1_TEXT.getString()), RED_BUTTON_TEXTURE, RED_LIGHT_BUTTON_TEXTURE, EARTH_TEXT);
        this.visibleButton(this.earthCategoryButton, false);
        this.marsCategoryButton = PlanetSelectionGuiHelper.addCategoryButton(this, this.category, 10, 1, 70, 20, 3, this.checkTier(2), ImageButtonPlacer.Types.SOLAR_SYSTEM_CATEGORY, List.of(MARS_TEXT.getString(), ROCKET_TIER_2_TEXT.getString()), RED_BUTTON_TEXTURE, RED_LIGHT_BUTTON_TEXTURE, MARS_TEXT);
        this.visibleButton(this.marsCategoryButton, false);
        this.mercuryCategoryButton = PlanetSelectionGuiHelper.addCategoryButton(this, this.category, 10, 1, 70, 20, 4, this.checkTier(3), ImageButtonPlacer.Types.SOLAR_SYSTEM_CATEGORY, List.of(MERCURY_TEXT.getString(), ROCKET_TIER_3_TEXT.getString()), RED_BUTTON_TEXTURE, RED_LIGHT_BUTTON_TEXTURE, MERCURY_TEXT);
        this.visibleButton(this.mercuryCategoryButton, false);
        this.venusCategoryButton = PlanetSelectionGuiHelper.addCategoryButton(this, this.category, 10, 1, 70, 20, 5, this.checkTier(3), ImageButtonPlacer.Types.SOLAR_SYSTEM_CATEGORY, List.of(VENUS_TEXT.getString(), ROCKET_TIER_3_TEXT.getString()), RED_BUTTON_TEXTURE, RED_LIGHT_BUTTON_TEXTURE, VENUS_TEXT);
        this.visibleButton(this.venusCategoryButton, false);
        this.earthButton = PlanetSelectionGuiHelper.addHandlerButton(this, 10, 1, 70, 20, true, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(0), ImageButtonPlacer.Types.PLANET_CATEGORY, List.of(PLANET_TEXT.getString(), "9.807 m/s", "a" + OXYGEN_TRUE_TEXT.getString(), "a14"), BLUE_BUTTON_TEXTURE, BLUE_LIGHT_BUTTON_TEXTURE, EARTH_TEXT);
        this.visibleButton(this.earthButton, false);
        this.moonButton = PlanetSelectionGuiHelper.addHandlerButton(this, 10, 1, 70, 20, true, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(1), ImageButtonPlacer.Types.PLANET_CATEGORY, List.of(MOON_TEXT.getString(), "1.62 m/s", "c" + OXYGEN_FALSE_TEXT.getString(), "a-160"), BLUE_BUTTON_TEXTURE, BLUE_LIGHT_BUTTON_TEXTURE, MOON_TEXT);
        this.visibleButton(this.moonButton, false);
        this.marsButton = PlanetSelectionGuiHelper.addHandlerButton(this, 10, 1, 70, 20, true, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(2), ImageButtonPlacer.Types.PLANET_CATEGORY, List.of(PLANET_TEXT.getString(), "3.721 m/s", "c" + OXYGEN_FALSE_TEXT.getString(), "a-63"), BLUE_BUTTON_TEXTURE, BLUE_LIGHT_BUTTON_TEXTURE, MARS_TEXT);
        this.visibleButton(this.marsButton, false);
        this.mercuryButton = PlanetSelectionGuiHelper.addHandlerButton(this, 10, 1, 70, 20, true, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(3), ImageButtonPlacer.Types.PLANET_CATEGORY, List.of(PLANET_TEXT.getString(), "3.7 m/s", "c" + OXYGEN_FALSE_TEXT.getString(), "c430"), BLUE_BUTTON_TEXTURE, BLUE_LIGHT_BUTTON_TEXTURE, MERCURY_TEXT);
        this.visibleButton(this.mercuryButton, false);
        this.venusButton = PlanetSelectionGuiHelper.addHandlerButton(this, 10, 1, 70, 20, true, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(4), ImageButtonPlacer.Types.PLANET_CATEGORY, List.of(PLANET_TEXT.getString(), "8.87 m/s", "c" + OXYGEN_FALSE_TEXT.getString(), "c482"), BLUE_BUTTON_TEXTURE, BLUE_LIGHT_BUTTON_TEXTURE, VENUS_TEXT);
        this.visibleButton(this.venusButton, false);
        this.earthOrbitButton = PlanetSelectionGuiHelper.addHandlerButton(this, 84, 2, 37, 20, true, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(5), ImageButtonPlacer.Types.PLANET_CATEGORY, List.of(ORBIT_TEXT.getString(), NO_GRAVITY_TEXT.getString(), "c" + OXYGEN_FALSE_TEXT.getString(), "c-270"), SMALL_BLUE_BUTTON_TEXTURE, SMALL_BLUE_LIGHT_BUTTON_TEXTURE, ORBIT_TEXT);
        this.visibleButton(this.earthOrbitButton, false);
        this.moonOrbitButton = PlanetSelectionGuiHelper.addHandlerButton(this, 84, 2, 37, 20, true, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(6), ImageButtonPlacer.Types.PLANET_CATEGORY, List.of(ORBIT_TEXT.getString(), NO_GRAVITY_TEXT.getString(), "c" + OXYGEN_FALSE_TEXT.getString(), "c-270"), SMALL_BLUE_BUTTON_TEXTURE, SMALL_BLUE_LIGHT_BUTTON_TEXTURE, ORBIT_TEXT);
        this.visibleButton(this.moonOrbitButton, false);
        this.marsOrbitButton = PlanetSelectionGuiHelper.addHandlerButton(this, 84, 2, 37, 20, true, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(7), ImageButtonPlacer.Types.PLANET_CATEGORY, List.of(ORBIT_TEXT.getString(), NO_GRAVITY_TEXT.getString(), "c" + OXYGEN_FALSE_TEXT.getString(), "c-270"), SMALL_BLUE_BUTTON_TEXTURE, SMALL_BLUE_LIGHT_BUTTON_TEXTURE, ORBIT_TEXT);
        this.visibleButton(this.marsOrbitButton, false);
        this.mercuryOrbitButton = PlanetSelectionGuiHelper.addHandlerButton(this, 84, 2, 37, 20, true, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(8), ImageButtonPlacer.Types.PLANET_CATEGORY, List.of(ORBIT_TEXT.getString(), NO_GRAVITY_TEXT.getString(), "c" + OXYGEN_FALSE_TEXT.getString(), "c-270"), SMALL_BLUE_BUTTON_TEXTURE, SMALL_BLUE_LIGHT_BUTTON_TEXTURE, ORBIT_TEXT);
        this.visibleButton(this.mercuryOrbitButton, false);
        this.venusOrbitButton = PlanetSelectionGuiHelper.addHandlerButton(this, 84, 2, 37, 20, true, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(9), ImageButtonPlacer.Types.PLANET_CATEGORY, List.of(ORBIT_TEXT.getString(), NO_GRAVITY_TEXT.getString(), "c" + OXYGEN_FALSE_TEXT.getString(), "c-270"), SMALL_BLUE_BUTTON_TEXTURE, SMALL_BLUE_LIGHT_BUTTON_TEXTURE, ORBIT_TEXT);
        this.visibleButton(this.venusOrbitButton, false);
        this.earthSpaceStationButton = PlanetSelectionGuiHelper.addHandlerButton(this, 125, 3, 75, 20, this.spaceStationItemList, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(10), ImageButtonPlacer.Types.PLANET_SPACE_STATION_CATEGORY, List.of(ORBIT_TEXT.getString(), NO_GRAVITY_TEXT.getString(), "c" + OXYGEN_FALSE_TEXT.getString(), "c-270"), LARGE_RED_BUTTON_TEXTURE, LARGE_RED_LIGHT_BUTTON_TEXTURE, SPACE_STATION_TEXT);
        this.visibleButton(this.earthSpaceStationButton, false);
        this.moonSpaceStationButton = PlanetSelectionGuiHelper.addHandlerButton(this, 125, 3, 75, 20, this.spaceStationItemList, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(11), ImageButtonPlacer.Types.PLANET_SPACE_STATION_CATEGORY, List.of(ORBIT_TEXT.getString(), NO_GRAVITY_TEXT.getString(), "c" + OXYGEN_FALSE_TEXT.getString(), "c-270"), LARGE_RED_BUTTON_TEXTURE, LARGE_RED_LIGHT_BUTTON_TEXTURE, SPACE_STATION_TEXT);
        this.visibleButton(this.moonSpaceStationButton, false);
        this.marsSpaceStationButton = PlanetSelectionGuiHelper.addHandlerButton(this, 125, 3, 75, 20, this.spaceStationItemList, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(12), ImageButtonPlacer.Types.PLANET_SPACE_STATION_CATEGORY, List.of(ORBIT_TEXT.getString(), NO_GRAVITY_TEXT.getString(), "c" + OXYGEN_FALSE_TEXT.getString(), "c-270"), LARGE_RED_BUTTON_TEXTURE, LARGE_RED_LIGHT_BUTTON_TEXTURE, SPACE_STATION_TEXT);
        this.visibleButton(this.marsSpaceStationButton, false);
        this.mercurySpaceStationButton = PlanetSelectionGuiHelper.addHandlerButton(this, 125, 3, 75, 20, this.spaceStationItemList, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(13), ImageButtonPlacer.Types.PLANET_SPACE_STATION_CATEGORY, List.of(ORBIT_TEXT.getString(), NO_GRAVITY_TEXT.getString(), "c" + OXYGEN_FALSE_TEXT.getString(), "c-270"), LARGE_RED_BUTTON_TEXTURE, LARGE_RED_LIGHT_BUTTON_TEXTURE, SPACE_STATION_TEXT);
        this.visibleButton(this.mercurySpaceStationButton, false);
        this.venusSpaceStationButton = PlanetSelectionGuiHelper.addHandlerButton(this, 125, 3, 75, 20, this.spaceStationItemList, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(14), ImageButtonPlacer.Types.PLANET_SPACE_STATION_CATEGORY, List.of(ORBIT_TEXT.getString(), NO_GRAVITY_TEXT.getString(), "c" + OXYGEN_FALSE_TEXT.getString(), "c-270"), LARGE_RED_BUTTON_TEXTURE, LARGE_RED_LIGHT_BUTTON_TEXTURE, SPACE_STATION_TEXT);
        this.visibleButton(this.venusSpaceStationButton, false);
        this.proximaCentauriButton = PlanetSelectionGuiHelper.addCategoryButton(this, this.category, 10, 1, 70, 20, 6, true, ImageButtonPlacer.Types.MILKY_WAY_CATEGORY, List.of(PROXIMA_CENTAURI_TEXT.getString()), BLUE_BUTTON_TEXTURE, BLUE_LIGHT_BUTTON_TEXTURE, SOLAR_SYSTEM_PROXIMA_CENTAURI_TEXT);
        this.visibleButton(this.proximaCentauriButton, false);
        this.glacioCategoryButton = PlanetSelectionGuiHelper.addCategoryButton(this, this.category, 10, 1, 70, 20, 7, this.checkTier(4), ImageButtonPlacer.Types.SOLAR_SYSTEM_CATEGORY, List.of(GLACIO_TEXT.getString(), ROCKET_TIER_4_TEXT.getString()), RED_BUTTON_TEXTURE, RED_LIGHT_BUTTON_TEXTURE, GLACIO_TEXT);
        this.visibleButton(this.glacioCategoryButton, false);
        this.glacioButton = PlanetSelectionGuiHelper.addHandlerButton(this, 10, 1, 70, 20, true, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(15), ImageButtonPlacer.Types.PLANET_CATEGORY, List.of(PLANET_TEXT.getString(), "3.721 m/s", "a" + OXYGEN_TRUE_TEXT.getString(), "a-20"), BLUE_BUTTON_TEXTURE, BLUE_LIGHT_BUTTON_TEXTURE, GLACIO_TEXT);
        this.visibleButton(this.glacioButton, false);
        this.glacioOrbitButton = PlanetSelectionGuiHelper.addHandlerButton(this, 84, 2, 37, 20, true, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(16), ImageButtonPlacer.Types.PLANET_CATEGORY, List.of(ORBIT_TEXT.getString(), NO_GRAVITY_TEXT.getString(), "c" + OXYGEN_FALSE_TEXT.getString(), "c-270"), SMALL_BLUE_BUTTON_TEXTURE, SMALL_BLUE_LIGHT_BUTTON_TEXTURE, ORBIT_TEXT);
        this.visibleButton(this.glacioOrbitButton, false);
        this.glacioSpaceStationButton = PlanetSelectionGuiHelper.addHandlerButton(this, 125, 3, 75, 20, this.spaceStationItemList, BeyondEarthMod.PACKET_HANDLER, PlanetSelectionGuiHelper.getNetworkHandler(17), ImageButtonPlacer.Types.PLANET_SPACE_STATION_CATEGORY, List.of(ORBIT_TEXT.getString(), NO_GRAVITY_TEXT.getString(), "c" + OXYGEN_FALSE_TEXT.getString(), "c-270"), LARGE_RED_BUTTON_TEXTURE, LARGE_RED_LIGHT_BUTTON_TEXTURE, SPACE_STATION_TEXT);
        this.visibleButton(this.glacioSpaceStationButton, false);
        MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionGuiInitEvent.Post((Screen)this));
        this.updateButtonVisibility();
    }

    protected void m_7027_(PoseStack p_97808_, int p_97809_, int p_97810_) {
    }

    public void m_7379_() {
    }

    public boolean m_6050_(double p_99314_, double p_99315_, double p_99316_) {
        if (this.getVisibleButtons(1).size() > this.rowEnd) {
            if (p_99316_ == 1.0) {
                if (this.scrollIndex != 0) {
                    ++this.scrollIndex;
                    this.updateButtonVisibility();
                    return true;
                }
            } else if (this.scrollIndex != -(this.getVisibleButtons(1).size() - this.rowEnd)) {
                --this.scrollIndex;
                this.updateButtonVisibility();
                return true;
            }
        }
        return false;
    }

    public void updateButtonVisibility() {
        if (MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionGuiButtonVisibilityEvent.Pre((Screen)this))) {
            return;
        }
        this.visibleButtons.clear();
        this.visibleButton(this.solarSystemButton, this.category.get() == 0);
        this.visibleButton(this.proximaCentauriButton, this.category.get() == 0);
        this.visibleButton(this.backButton, PlanetSelectionGuiHelper.categoryRange(this.category.get(), 1, 5) || PlanetSelectionGuiHelper.categoryRange(this.category.get(), 6, 7));
        this.visibleButton(this.earthCategoryButton, this.category.get() == 1);
        this.visibleButton(this.marsCategoryButton, this.category.get() == 1);
        this.visibleButton(this.mercuryCategoryButton, this.category.get() == 1);
        this.visibleButton(this.venusCategoryButton, this.category.get() == 1);
        this.visibleButton(this.earthButton, this.category.get() == 2);
        this.visibleButton(this.moonButton, this.category.get() == 2);
        this.visibleButton(this.marsButton, this.category.get() == 3);
        this.visibleButton(this.mercuryButton, this.category.get() == 4);
        this.visibleButton(this.venusButton, this.category.get() == 5);
        this.visibleButton(this.earthOrbitButton, this.category.get() == 2);
        this.visibleButton(this.moonOrbitButton, this.category.get() == 2);
        this.visibleButton(this.marsOrbitButton, this.category.get() == 3);
        this.visibleButton(this.mercuryOrbitButton, this.category.get() == 4);
        this.visibleButton(this.venusOrbitButton, this.category.get() == 5);
        this.visibleButton(this.earthSpaceStationButton, this.category.get() == 2);
        this.visibleButton(this.moonSpaceStationButton, this.category.get() == 2);
        this.visibleButton(this.marsSpaceStationButton, this.category.get() == 3);
        this.visibleButton(this.mercurySpaceStationButton, this.category.get() == 4);
        this.visibleButton(this.venusSpaceStationButton, this.category.get() == 5);
        this.visibleButton(this.glacioCategoryButton, this.category.get() == 6);
        this.visibleButton(this.glacioButton, this.category.get() == 7);
        this.visibleButton(this.glacioOrbitButton, this.category.get() == 7);
        this.visibleButton(this.glacioSpaceStationButton, this.category.get() == 7);
        MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionGuiButtonVisibilityEvent.Post((Screen)this));
    }

    public void rotateObjects(float partialTicks) {
        this.rotationMilkyWay = (this.rotationMilkyWay + partialTicks * 0.4f) % 360.0f;
        this.rotationMars = (this.rotationMars + partialTicks * 0.4f) % 360.0f;
        this.rotationEarth = (this.rotationEarth + partialTicks * 0.8f) % 360.0f;
        this.rotationVenus = (this.rotationVenus + partialTicks * 0.7f) % 360.0f;
        this.rotationMercury = (this.rotationMercury + partialTicks * 0.7f) % 360.0f;
        this.rotationGlacio = (this.rotationGlacio + partialTicks * 0.7f) % 360.0f;
    }

    public void renderRotatedObjects(PoseStack poseStack) {
        if (this.category.get() == 0) {
            PlanetSelectionGuiHelper.addRotatedObject(this, poseStack, MILKY_WAY_TEXTURE, -125.0f, -125.0f, 250, 250, this.rotationMilkyWay);
        }
        if (PlanetSelectionGuiHelper.categoryRange(this.category.get(), 1, 5)) {
            PlanetSelectionGuiHelper.addRotatedObject(this, poseStack, MARS_TEXTURE, -70.0f, -70.0f, 10, 10, this.rotationMars);
            PlanetSelectionGuiHelper.addRotatedObject(this, poseStack, EARTH_TEXTURE, -54.0f, -54.0f, 10, 10, this.rotationEarth);
            PlanetSelectionGuiHelper.addRotatedObject(this, poseStack, VENUS_TEXTURE, -37.0f, -37.0f, 10, 10, this.rotationVenus);
            PlanetSelectionGuiHelper.addRotatedObject(this, poseStack, MERCURY_TEXTURE, -20.5f, -20.5f, 10, 10, this.rotationMercury);
        }
        if (PlanetSelectionGuiHelper.categoryRange(this.category.get(), 6, 7)) {
            PlanetSelectionGuiHelper.addRotatedObject(this, poseStack, GLACIO_TEXTURE, -20.5f, -20.5f, 10, 10, this.rotationGlacio);
        }
    }

    public void renderScroller(PoseStack poseStack) {
        if (this.visibleButtons.size() > this.rowEnd) {
            int buttonStartY = this.f_96544_ / 2 - 33;
            int scrollSize = this.visibleButtons.size() - this.rowEnd;
            float y = (float)buttonStartY + 97.0f / (float)scrollSize * (float)(-this.scrollIndex);
            PlanetSelectionGuiHelper.addTexture(poseStack, 92, (int)y, 4, 8, SCROLLER_TEXTURE);
        }
    }

    public void handleButtonPos(int rowStart, int rowEnd) {
        for (int f1 = rowStart; f1 <= rowEnd; ++f1) {
            for (int f2 = 0; f2 < this.getVisibleButtons(f1).size(); ++f2) {
                int y;
                ImageButtonPlacer button = this.getVisibleButtons(f1).get(f2);
                int buttonStartY = this.f_96544_ / 2 - 34;
                int extraPos = 0;
                if (f1 >= 2 && rowEnd <= 3) {
                    extraPos = 1;
                }
                if (button.f_93621_ == (y = buttonStartY + 22 * (f2 + extraPos + this.scrollIndex))) continue;
                button.setPosition(button.f_93620_, y);
            }
        }
    }

    public boolean buttonScrollVisibility(ImageButtonPlacer button) {
        int buttonStartY = this.f_96544_ / 2 - 34;
        int buttonEndY = buttonStartY + 22 * this.rowEnd;
        if (button.f_93621_ < buttonStartY && button.row != 0) {
            return false;
        }
        return button.f_93621_ < buttonEndY || button.row == 0;
    }

    public List<ImageButtonPlacer> getVisibleButtons(int row) {
        ArrayList<ImageButtonPlacer> listVisible = new ArrayList<ImageButtonPlacer>();
        for (int f1 = 0; f1 < this.visibleButtons.size(); ++f1) {
            ImageButtonPlacer button = this.visibleButtons.get(f1);
            if (button.row != row) continue;
            listVisible.add(button);
        }
        return listVisible;
    }

    public void visibleButton(ImageButtonPlacer button, Boolean condition) {
        if (condition.booleanValue() && !this.visibleButtons.contains((Object)button)) {
            this.visibleButtons.add(button);
        }
        this.handleButtonPos(1, 3);
        button.f_93624_ = condition != false && this.buttonScrollVisibility(button);
    }

    public boolean getSpaceStationItemCheck(IngredientStack ingredientStack) {
        Player player = ((PlanetSelectionGui.GuiContainer)this.f_97732_).player;
        if (player.m_150110_().f_35937_ || player.m_5833_()) {
            return true;
        }
        Inventory inv = player.m_150109_();
        int itemStackCount = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemStack = inv.m_8020_(i);
            if (!ingredientStack.testWithoutCount(itemStack)) continue;
            itemStackCount += itemStack.m_41613_();
        }
        return itemStackCount >= ingredientStack.getCount();
    }

    public boolean checkTier(int tier) {
        return PlanetSelectionGuiHelper.checkTier(((PlanetSelectionGui.GuiContainer)this.f_97732_).getRocket(), tier);
    }

    public ImageButtonPlacer addButton(int x, int y, int row, int width, int height, boolean rocketCondition, ImageButtonPlacer.Types type, List<String> list, ResourceLocation buttonTexture, ResourceLocation hoverButtonTexture, Component title, Button.OnPress onPress) {
        ImageButtonPlacer button = (ImageButtonPlacer)this.m_142416_((GuiEventListener)new ImageButtonPlacer(x, y, row, width, height, 0, 0, 0, rocketCondition, type, list, buttonTexture, hoverButtonTexture, width, height, onPress, title));
        return button;
    }
}

