/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.events;

import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrscauthd.beyond_earth.entities.IRocketEntity;
import net.mrscauthd.beyond_earth.entities.LanderEntity;
import net.mrscauthd.beyond_earth.events.ClientMethods;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.events.SpaceSoundSystem;
import net.mrscauthd.beyond_earth.events.TickableSpaceSoundSystem;
import net.mrscauthd.beyond_earth.events.forge.RenderHandItemEvent;
import net.mrscauthd.beyond_earth.events.forge.RenderViewEvent;
import net.mrscauthd.beyond_earth.events.forge.SetupLivingBipedAnimEvent;
import net.mrscauthd.beyond_earth.items.VehicleItem;

@Mod.EventBusSubscriber(modid="beyond_earth", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void spaceSounds(PlaySoundEvent event) {
        if (event.getSound() == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.f_19853_ != null && ClientMethods.checkSound(event.getSound().m_8070_()) && Methods.isSpaceWorldWithoutOxygen(Minecraft.m_91087_().f_91074_.f_19853_)) {
            if (!(event.getSound() instanceof TickableSoundInstance)) {
                event.setSound((SoundInstance)new SpaceSoundSystem(event.getSound()));
            } else if (event.getSound() instanceof TickableSoundInstance) {
                event.setSound((SoundInstance)new TickableSpaceSoundSystem((TickableSoundInstance)event.getSound()));
            }
        }
    }

    @SubscribeEvent
    public static void itemRender(RenderHandItemEvent.Pre event) {
        if (!(event.getLivingEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getLivingEntity();
        if (Methods.isRocket(player.m_20202_())) {
            event.setCanceled(true);
        }
        if (event.getHandSide() == HumanoidArm.LEFT) {
            Item item = player.m_21205_().m_41720_();
            if (item instanceof VehicleItem) {
                event.setCanceled(true);
            }
        } else {
            Item item = player.m_21206_().m_41720_();
            if (item instanceof VehicleItem) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void cameraPos(EntityViewRenderEvent.CameraSetup event) {
        CameraType cameraType;
        Entity ridding = event.getCamera().m_90592_().m_20202_();
        if ((Methods.isRocket(ridding) || ridding instanceof LanderEntity) && ((cameraType = Minecraft.m_91087_().f_91066_.m_92176_()).equals((Object)CameraType.THIRD_PERSON_FRONT) || cameraType.equals((Object)CameraType.THIRD_PERSON_BACK))) {
            event.getCamera().m_90568_(-event.getCamera().m_90566_(12.0), 0.0, 0.0);
        }
    }

    @SubscribeEvent
    public static void bobViewer(RenderViewEvent event) {
        CameraType cameraType;
        Minecraft mc = Minecraft.m_91087_();
        Entity ridding = mc.f_91074_.m_20202_();
        if (Methods.isRocket(ridding) && ((cameraType = mc.f_91066_.m_92176_()).equals((Object)CameraType.THIRD_PERSON_FRONT) || cameraType.equals((Object)CameraType.THIRD_PERSON_BACK))) {
            event.setCanceled(true);
            if (((Boolean)ridding.m_20088_().m_135370_(IRocketEntity.ROCKET_START)).booleanValue()) {
                ClientMethods.bobView(event.getPoseStack(), event.getTick());
            }
        }
    }

    @SubscribeEvent
    public static void renderPlayerArm(RenderArmEvent event) {
        AbstractClientPlayer player = event.getPlayer();
        PlayerRenderer renderer = (PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)player);
        PlayerModel playerModel = (PlayerModel)renderer.m_7200_();
        Item item = player.m_21206_().m_41720_();
        Item item2 = player.m_21205_().m_41720_();
        if (item instanceof VehicleItem || item2 instanceof VehicleItem) {
            event.setCanceled(true);
            return;
        }
        if (event.getArm() == HumanoidArm.RIGHT) {
            event.setCanceled(ClientMethods.armRenderer(player, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), (PlayerModel<AbstractClientPlayer>)playerModel, renderer));
        } else {
            event.setCanceled(ClientMethods.armRenderer(player, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), (PlayerModel<AbstractClientPlayer>)playerModel, renderer));
        }
    }

    @SubscribeEvent
    public static void render(RenderPlayerEvent event) {
        if (event.getEntity().m_20202_() instanceof LanderEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void setupPlayerAngles(SetupLivingBipedAnimEvent.Post event) {
        if (!(event.getLivingEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getLivingEntity();
        HumanoidModel model = event.getModel();
        if (Methods.isRocket(player.m_20202_())) {
            model.f_102813_.f_104203_ = 0.0f;
            model.f_102814_.f_104203_ = 0.0f;
            model.f_102813_.f_104204_ = 0.0f;
            model.f_102814_.f_104204_ = 0.0f;
            model.f_102813_.f_104205_ = 0.0f;
            model.f_102814_.f_104205_ = 0.0f;
            model.f_102811_.f_104203_ = -0.07f;
            model.f_102812_.f_104203_ = -0.07f;
        } else if (!Methods.isRocket(player.m_20202_())) {
            Item item1 = player.m_21205_().m_41720_();
            Item item2 = player.m_21206_().m_41720_();
            if (item1 instanceof VehicleItem || item2 instanceof VehicleItem) {
                model.f_102811_.f_104203_ = 10.0f;
                model.f_102812_.f_104203_ = 10.0f;
                model.f_102811_.f_104204_ = 0.0f;
                model.f_102812_.f_104204_ = 0.0f;
                model.f_102811_.f_104205_ = 0.0f;
                model.f_102812_.f_104205_ = 0.0f;
            }
        }
    }
}

