/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.habitats;

import com.github.kay9.dragonmounts.habitats.Habitat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public record HeightHabitat(int points, boolean below, int height) implements Habitat
{
    public static final Codec<HeightHabitat> CODEC = RecordCodecBuilder.create(func -> func.group(Habitat.withPoints(3, HeightHabitat::points), (App)Codec.BOOL.optionalFieldOf("below", (Object)false).forGetter(HeightHabitat::below), (App)Codec.INT.fieldOf("height").forGetter(HeightHabitat::height)).apply((Applicative)func, HeightHabitat::new));

    @Override
    public int getHabitatPoints(Level level, BlockPos pos) {
        int y = pos.m_123342_();
        int max = this.height;
        return (this.below ? y < max && !level.m_45527_(pos) : y > max) ? this.points : 0;
    }

    @Override
    public String type() {
        return Habitat.WORLD_HEIGHT;
    }
}

