/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.data.loot;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.dragon.DMLEggBlock;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DragonEggLootMod
extends LootModifier {
    private final ResourceLocation id;

    public DragonEggLootMod(LootItemCondition[] conditions, ResourceLocation breed) {
        super(conditions);
        this.id = breed;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (DMLConfig.useLootTables()) {
            RegistryAccess reg = context.m_78952_().m_5962_();
            BreedRegistry.registry(reg).m_6612_(this.id).ifPresentOrElse(breed -> generatedLoot.add(DMLEggBlock.Item.create(breed, reg, breed.hatchTime())), () -> {
                throw new JsonParseException("Unable to produce Dragon Egg Loot with unknown breed id: \"" + this.id + "\"");
            });
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<DragonEggLootMod> {
        public DragonEggLootMod read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            String in = GsonHelper.m_13906_((JsonObject)object, (String)"breed");
            if (!ResourceLocation.m_135830_((String)in)) {
                throw new JsonParseException("Not a valid ResourceLocation: \"" + in + "\"");
            }
            return new DragonEggLootMod(conditions, new ResourceLocation(in));
        }

        public JsonObject write(DragonEggLootMod instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("breed", instance.id.toString());
            return json;
        }
    }
}

