/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.util.BlockUtil;
import alternate.current.wire.LevelAccess;
import alternate.current.wire.Node;
import alternate.current.wire.PowerQueue;
import alternate.current.wire.WireBlock;
import alternate.current.wire.WireNode;
import alternate.current.wire.WireType;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class WireHandler {
    static final int[] FLOW_IN_TO_FLOW_OUT = new int[]{-1, 0, 1, 1, 2, -1, 2, 1, 3, 0, -1, 0, 3, 3, 2, -1};
    static final int[][] CARDINAL_UPDATE_ORDERS = new int[][]{{0, 2, 1, 3}, {1, 3, 2, 0}, {2, 0, 3, 1}, {3, 1, 0, 2}};
    static final int[] DEFAULT_CARDINAL_UPDATE_ORDER = CARDINAL_UPDATE_ORDERS[0];
    static final int[] DEFAULT_FULL_UPDATE_ORDER = new int[]{0, 2, 1, 3, 4, 5};
    private final LevelAccess level;
    private final List<WireNode> network;
    private final Long2ObjectMap<Node> nodes;
    private final Queue<WireNode> powerChanges;
    private int rootCount;
    private Node[] nodeCache;
    private int nodeCount;
    private boolean updatingPower;

    public WireHandler(ServerLevel level) {
        this.level = new LevelAccess(level);
        this.network = new ArrayList<WireNode>();
        this.nodes = new Long2ObjectOpenHashMap();
        this.powerChanges = new PowerQueue();
        this.nodeCache = new Node[16];
        this.fillNodeCache(0, 16);
    }

    private Node getOrAddNode(BlockPos pos) {
        return (Node)this.nodes.compute(pos.m_121878_(), (key, node) -> {
            if (node == null) {
                return this.getNextNode(pos);
            }
            if (node.invalid) {
                return this.revalidateNode((Node)node);
            }
            return node;
        });
    }

    private Node getNeighbor(Node node, int iDir) {
        Node neighbor = node.neighbors[iDir];
        if (neighbor == null || neighbor.invalid) {
            Direction dir = Directions.ALL[iDir];
            BlockPos pos = node.pos.m_142300_(dir);
            Node oldNeighbor = neighbor;
            neighbor = this.getOrAddNode(pos);
            if (neighbor != oldNeighbor) {
                int iOpp = Directions.iOpposite(iDir);
                node.neighbors[iDir] = neighbor;
                neighbor.neighbors[iOpp] = node;
            }
        }
        return neighbor;
    }

    private Node removeNode(BlockPos pos) {
        return (Node)this.nodes.remove(pos.m_121878_());
    }

    private Node revalidateNode(Node node) {
        node.invalid = false;
        if (node.isWire()) {
            WireNode wire = node.asWire();
            wire.prepared = false;
            wire.inNetwork = false;
        } else {
            BlockPos pos = node.pos;
            BlockState state = this.level.getBlockState(pos);
            node.update(pos, state, false);
        }
        return node;
    }

    private Node getNextNode(BlockPos pos) {
        BlockState state = this.level.getBlockState(pos);
        Block block = state.m_60734_();
        if (block instanceof WireBlock) {
            return new WireNode((WireBlock)block, this.level, pos, state);
        }
        return this.getNextNode().update(pos, state, true);
    }

    private Node getNextNode() {
        if (this.nodeCount == this.nodeCache.length) {
            this.increaseNodeCache();
        }
        return this.nodeCache[this.nodeCount++];
    }

    private void increaseNodeCache() {
        Node[] oldCache = this.nodeCache;
        this.nodeCache = new Node[oldCache.length << 1];
        for (int index = 0; index < oldCache.length; ++index) {
            this.nodeCache[index] = oldCache[index];
        }
        this.fillNodeCache(oldCache.length, this.nodeCache.length);
    }

    private void fillNodeCache(int start, int end) {
        for (int index = start; index < end; ++index) {
            this.nodeCache[index] = new Node(this.level);
        }
    }

    public void onWireUpdated(BlockPos pos, WireType type) {
        this.invalidateNodes();
        this.findRoots(pos, type, true);
        this.tryUpdatePower();
    }

    public void onWireAdded(BlockPos pos, WireType type) {
        Node node = this.getOrAddNode(pos);
        if (!node.isWire(type)) {
            return;
        }
        WireNode wire = node.asWire();
        wire.added = true;
        this.invalidateNodes();
        this.findRoots(pos, type, false);
        this.tryUpdatePower();
    }

    public void onWireRemoved(BlockPos pos, BlockState state, WireType type) {
        Node node = this.removeNode(pos);
        WireNode wire = node == null || !node.isWire(type) ? new WireNode(type, this.level, pos, state) : node.asWire();
        wire.invalid = true;
        wire.removed = true;
        if (this.updatingPower && wire.shouldBreak) {
            return;
        }
        this.invalidateNodes();
        this.tryAddRoot(wire);
        this.tryUpdatePower();
    }

    private void invalidateNodes() {
        if (this.updatingPower && !this.nodes.isEmpty()) {
            ObjectIterator it = Long2ObjectMaps.fastIterator(this.nodes);
            while (it.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
                Node node = (Node)entry.getValue();
                node.invalid = true;
            }
        }
    }

    private void findRoots(BlockPos pos, WireType type, boolean checkNeighbors) {
        Node node = this.getOrAddNode(pos);
        if (!node.isWire(type)) {
            return;
        }
        WireNode wire = node.asWire();
        this.tryAddRoot(wire);
        if (!checkNeighbors || !wire.inNetwork || wire.connections.total == 0) {
            return;
        }
        for (int iDir : DEFAULT_FULL_UPDATE_ORDER) {
            Node neighbor = this.getNeighbor(wire, iDir);
            if (neighbor.isConductor()) {
                this.findSignalSourcesAround(neighbor, Directions.iOpposite(iDir));
                continue;
            }
            if (!this.level.isSignalSourceTo(neighbor.pos, neighbor.state, Directions.ALL[iDir])) continue;
            this.findRootsAroundSignalSource(neighbor, Directions.iOpposite(iDir));
        }
    }

    private void findSignalSourcesAround(Node node, int except) {
        for (int iDir : Directions.I_EXCEPT[except]) {
            Node neighbor = this.getNeighbor(node, iDir);
            if (!this.level.isDirectSignalSourceTo(neighbor.pos, neighbor.state, Directions.ALL[iDir])) continue;
            this.findRootsAroundSignalSource(neighbor, iDir);
        }
    }

    private void findRootsAroundSignalSource(Node node, int except) {
        for (int iDir : Directions.I_EXCEPT[except]) {
            int iOpp = Directions.iOpposite(iDir);
            Direction opp = Directions.ALL[iOpp];
            boolean signal = this.level.isSignalSourceTo(node.pos, node.state, opp);
            boolean directSignal = this.level.isDirectSignalSourceTo(node.pos, node.state, opp);
            if (!signal && !directSignal) continue;
            Node neighbor = this.getNeighbor(node, iDir);
            if (signal && neighbor.isWire()) {
                this.tryAddRoot(neighbor.asWire());
                continue;
            }
            if (!directSignal || !neighbor.isConductor()) continue;
            this.findRootsAround(neighbor, iOpp);
        }
    }

    private void findRootsAround(Node node, int except) {
        for (int iDir : Directions.I_EXCEPT[except]) {
            Node neighbor = this.getNeighbor(node, iDir);
            if (!neighbor.isWire()) continue;
            this.tryAddRoot(neighbor.asWire());
        }
    }

    private void tryAddRoot(WireNode wire) {
        if (wire.prepared) {
            return;
        }
        this.prepare(wire);
        if (wire.type.powerStep != 0 || !this.needsPowerChange(wire)) {
            this.findPower(wire, false);
        }
        if (this.needsPowerChange(wire)) {
            this.addRoot(wire);
        }
    }

    private void addRoot(WireNode wire) {
        this.network.add(wire);
        ++this.rootCount;
        wire.inNetwork = true;
        if (wire.connections.iFlowDir >= 0) {
            wire.iFlowDir = wire.connections.iFlowDir;
        }
    }

    private void prepare(WireNode wire) {
        if (wire.prepared) {
            return;
        }
        wire.prepared = true;
        wire.inNetwork = false;
        if (!wire.removed && !wire.shouldBreak && this.level.shouldBreak(wire.pos, wire.state)) {
            wire.shouldBreak = true;
        }
        wire.virtualPower = wire.externalPower = this.getInitialPower(wire);
        wire.connections.set(this::getNeighbor);
    }

    private int getInitialPower(WireNode wire) {
        return wire.removed || wire.shouldBreak ? wire.type.minPower : this.getExternalPower(wire);
    }

    private int getExternalPower(WireNode wire) {
        int power = wire.type.minPower;
        for (int iDir = 0; iDir < Directions.ALL.length; ++iDir) {
            Node neighbor = this.getNeighbor(wire, iDir);
            if (neighbor.isWire()) continue;
            if (neighbor.isConductor()) {
                power = Math.max(power, this.getDirectSignalTo(wire, neighbor, Directions.iOpposite(iDir)));
            }
            if (neighbor.isSignalSource()) {
                power = Math.max(power, this.level.getSignalFrom(neighbor.pos, neighbor.state, Directions.ALL[iDir]));
            }
            if (power < wire.type.maxPower) continue;
            return wire.type.maxPower;
        }
        return power;
    }

    private int getDirectSignalTo(WireNode wire, Node node, int except) {
        int power = wire.type.minPower;
        for (int iDir : Directions.I_EXCEPT[except]) {
            Node neighbor = this.getNeighbor(node, iDir);
            if (!neighbor.isSignalSource() || (power = Math.max(power, this.level.getDirectSignalFrom(neighbor.pos, neighbor.state, Directions.ALL[iDir]))) < wire.type.maxPower) continue;
            return wire.type.maxPower;
        }
        return power;
    }

    private void findPower(WireNode wire, boolean ignoreNetwork) {
        if (wire.removed || wire.shouldBreak || wire.externalPower >= wire.type.maxPower) {
            return;
        }
        wire.virtualPower = wire.externalPower;
        wire.flowIn = 0;
        this.findWirePower(wire, ignoreNetwork);
    }

    private void findWirePower(WireNode wire, boolean ignoreNetwork) {
        wire.connections.forEach(connection -> {
            if (!connection.accept) {
                return;
            }
            WireNode neighbor = connection.wire;
            if (!ignoreNetwork || !neighbor.inNetwork) {
                int step = Math.max(wire.type.powerStep, neighbor.type.powerStep);
                int power = Math.max(wire.type.minPower, neighbor.virtualPower - step);
                int iOpp = Directions.iOpposite(connection.iDir);
                wire.offerPower(power, iOpp);
            }
        });
    }

    private boolean needsPowerChange(WireNode wire) {
        return wire.removed || wire.shouldBreak || wire.virtualPower != wire.currentPower;
    }

    private void tryUpdatePower() {
        if (this.rootCount > 0) {
            this.updatePower();
        }
        if (!this.updatingPower) {
            this.nodes.clear();
            this.nodeCount = 0;
        }
    }

    private void updatePower() {
        this.buildNetwork();
        this.findPoweredWires();
        this.network.clear();
        this.rootCount = 0;
        try {
            this.letPowerFlow();
        }
        catch (Throwable t) {
            this.updatingPower = false;
            throw t;
        }
    }

    private void buildNetwork() {
        for (int index = 0; index < this.network.size(); ++index) {
            WireNode wire = this.network.get(index);
            wire.connections.forEach(connection -> {
                if (!connection.offer) {
                    return;
                }
                WireNode neighbor = connection.wire;
                if (neighbor.inNetwork) {
                    return;
                }
                this.prepare(neighbor);
                if (neighbor.type.powerStep != 0 || !this.needsPowerChange(neighbor)) {
                    this.findPower(neighbor, false);
                }
                if (this.needsPowerChange(neighbor)) {
                    this.addToNetwork(neighbor, connection.iDir);
                }
            }, wire.iFlowDir);
        }
    }

    private void addToNetwork(WireNode wire, int iBackupFlowDir) {
        this.network.add(wire);
        wire.inNetwork = true;
        wire.iFlowDir = iBackupFlowDir;
    }

    private void findPoweredWires() {
        for (int index = 0; index < this.network.size(); ++index) {
            WireNode wire = this.network.get(index);
            this.findPower(wire, true);
            if (index < this.rootCount || wire.removed || wire.shouldBreak || wire.virtualPower > wire.type.minPower) {
                this.queuePowerChange(wire);
                continue;
            }
            --wire.virtualPower;
        }
    }

    private void queuePowerChange(WireNode wire) {
        if (this.needsPowerChange(wire)) {
            this.powerChanges.offer(wire);
        } else {
            this.findPowerFlow(wire);
            this.transmitPower(wire);
        }
    }

    private void findPowerFlow(WireNode wire) {
        int flow = FLOW_IN_TO_FLOW_OUT[wire.flowIn];
        if (flow >= 0) {
            wire.iFlowDir = flow;
        } else if (wire.connections.iFlowDir >= 0) {
            wire.iFlowDir = wire.connections.iFlowDir;
        }
    }

    private void transmitPower(WireNode wire) {
        wire.connections.forEach(connection -> {
            int iDir;
            if (!connection.offer) {
                return;
            }
            WireNode neighbor = connection.wire;
            int step = Math.max(wire.type.powerStep, neighbor.type.powerStep);
            int power = Math.max(neighbor.type.minPower, wire.virtualPower - step);
            if (neighbor.offerPower(power, iDir = connection.iDir)) {
                this.queuePowerChange(neighbor);
            }
        }, wire.iFlowDir);
    }

    private void letPowerFlow() {
        if (this.updatingPower) {
            return;
        }
        this.updatingPower = true;
        while (!this.powerChanges.isEmpty()) {
            WireNode wire = this.powerChanges.poll();
            if (!this.needsPowerChange(wire)) continue;
            this.findPowerFlow(wire);
            if (wire.setPower()) {
                if (!wire.added && !wire.shouldBreak) {
                    this.updateNeighborShapes(wire);
                }
                this.updateNeighborBlocks(wire);
            }
            this.transmitPower(wire);
        }
        this.updatingPower = false;
    }

    private void updateNeighborShapes(WireNode wire) {
        BlockPos wirePos = wire.pos;
        BlockState wireState = wire.state;
        for (Direction dir : BlockUtil.SHAPE_UPDATE_ORDER) {
            this.updateNeighborShape(wirePos.m_142300_(dir), dir.m_122424_(), wirePos, wireState);
        }
    }

    private void updateNeighborShape(BlockPos pos, Direction fromDir, BlockPos fromPos, BlockState fromState) {
        BlockState state = this.level.getBlockState(pos);
        if (!state.m_60795_() && !(state.m_60734_() instanceof WireBlock)) {
            this.level.updateNeighborShape(pos, state, fromDir, fromPos, fromState);
        }
    }

    private void updateNeighborBlocks(WireNode wire) {
        int iDir = wire.iFlowDir;
        Direction forward = Directions.HORIZONTAL[iDir];
        Direction rightward = Directions.HORIZONTAL[iDir + 1 & 3];
        Direction backward = Directions.HORIZONTAL[iDir + 2 & 3];
        Direction leftward = Directions.HORIZONTAL[iDir + 3 & 3];
        Direction downward = Direction.DOWN;
        Direction upward = Direction.UP;
        BlockPos self = wire.pos;
        BlockPos front = self.m_142300_(forward);
        BlockPos right = self.m_142300_(rightward);
        BlockPos back = self.m_142300_(backward);
        BlockPos left = self.m_142300_(leftward);
        BlockPos below = self.m_142300_(downward);
        BlockPos above = self.m_142300_(upward);
        Block block = wire.state.m_60734_();
        this.updateNeighbor(front, self, block);
        this.updateNeighbor(back, self, block);
        this.updateNeighbor(right, self, block);
        this.updateNeighbor(left, self, block);
        this.updateNeighbor(below, self, block);
        this.updateNeighbor(above, self, block);
        this.updateNeighbor(front.m_142300_(rightward), self, block);
        this.updateNeighbor(back.m_142300_(leftward), self, block);
        this.updateNeighbor(front.m_142300_(leftward), self, block);
        this.updateNeighbor(back.m_142300_(rightward), self, block);
        this.updateNeighbor(front.m_142300_(downward), self, block);
        this.updateNeighbor(back.m_142300_(upward), self, block);
        this.updateNeighbor(front.m_142300_(upward), self, block);
        this.updateNeighbor(back.m_142300_(downward), self, block);
        this.updateNeighbor(right.m_142300_(downward), self, block);
        this.updateNeighbor(left.m_142300_(upward), self, block);
        this.updateNeighbor(right.m_142300_(upward), self, block);
        this.updateNeighbor(left.m_142300_(downward), self, block);
        this.updateNeighbor(front.m_142300_(forward), self, block);
        this.updateNeighbor(back.m_142300_(backward), self, block);
        this.updateNeighbor(right.m_142300_(rightward), self, block);
        this.updateNeighbor(left.m_142300_(leftward), self, block);
        this.updateNeighbor(below.m_142300_(downward), self, block);
        this.updateNeighbor(above.m_142300_(upward), self, block);
    }

    private void updateNeighbor(BlockPos pos, BlockPos fromPos, Block fromBlock) {
        BlockState state = this.level.getBlockState(pos);
        Block block = state.m_60734_();
        if (!state.m_60795_() && !(block instanceof WireBlock)) {
            this.level.updateNeighborBlock(pos, state, fromPos, fromBlock);
        }
    }

    public static class Directions {
        public static final Direction[] ALL = new Direction[]{Direction.WEST, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.DOWN, Direction.UP};
        public static final Direction[] HORIZONTAL = new Direction[]{Direction.WEST, Direction.NORTH, Direction.EAST, Direction.SOUTH};
        public static final int WEST = 0;
        public static final int NORTH = 1;
        public static final int EAST = 2;
        public static final int SOUTH = 3;
        public static final int DOWN = 4;
        public static final int UP = 5;
        private static final int[][] I_EXCEPT = new int[][]{{1, 2, 3, 4, 5}, {0, 2, 3, 4, 5}, {0, 1, 3, 4, 5}, {0, 1, 2, 4, 5}, {0, 1, 2, 3, 5}, {0, 1, 2, 3, 4}};

        public static int iOpposite(int iDir) {
            return iDir ^ 2 >>> (iDir >>> 2);
        }
    }

    @FunctionalInterface
    public static interface NodeProvider {
        public Node getNeighbor(Node var1, int var2);
    }
}

