/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.client.QuiverArrowSelectGui;
import net.mehvahdjukaar.supplementaries.common.entities.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class QuiverItem
extends Item
implements DyeableLeatherItem {
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public QuiverItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142095_() {
        return false;
    }

    public boolean m_142207_(ItemStack quiver, Slot pSlot, ClickAction pAction, Player pPlayer) {
        IQuiverData data;
        if (pAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = pSlot.m_7993_();
        if (itemstack.m_150930_((Item)ModRegistry.QUIVER_ITEM.get())) {
            return false;
        }
        AtomicBoolean didStuff = new AtomicBoolean(false);
        if (itemstack.m_41619_()) {
            IQuiverData data2 = QuiverItem.getQuiverData(quiver);
            if (data2 != null) {
                data2.removeOneStack().ifPresent(stack -> {
                    this.playRemoveOneSound((Entity)pPlayer);
                    data2.tryAdding(pSlot.m_150659_(stack));
                    didStuff.set(true);
                });
            }
        } else if (itemstack.m_41720_().m_142095_() && (data = QuiverItem.getQuiverData(quiver)) != null) {
            ItemStack taken = pSlot.m_150647_(itemstack.m_41613_(), 64, pPlayer);
            ItemStack remaining = data.tryAdding(taken);
            if (!remaining.equals(taken)) {
                this.playInsertSound((Entity)pPlayer);
                didStuff.set(true);
            }
            pSlot.m_5852_(remaining);
        }
        return didStuff.get();
    }

    public boolean m_142305_(ItemStack quiver, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        IQuiverData data;
        if (pAction == ClickAction.SECONDARY && pSlot.m_150651_(pPlayer) && (data = QuiverItem.getQuiverData(quiver)) != null) {
            AtomicBoolean didStuff = new AtomicBoolean(false);
            if (pOther.m_41619_()) {
                data.removeOneStack().ifPresent(removed -> {
                    this.playRemoveOneSound((Entity)pPlayer);
                    pAccess.m_142104_(removed);
                    didStuff.set(true);
                });
            } else {
                ItemStack i = data.tryAdding(pOther);
                if (!i.equals(pOther)) {
                    this.playInsertSound((Entity)pPlayer);
                    pAccess.m_142104_(i);
                    didStuff.set(true);
                }
            }
            return didStuff.get();
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand pUsedHand) {
        ItemStack stack = player.m_21120_(pUsedHand);
        if (player.m_36341_()) {
            IQuiverData data = QuiverItem.getQuiverData(stack);
            if (data != null && data.cycle()) {
                this.playInsertSound((Entity)player);
            }
        } else {
            if (pLevel.f_46443_) {
                QuiverArrowSelectGui.setActive(true);
            }
            this.playRemoveOneSound((Entity)player);
            player.m_6672_(pUsedHand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)pLevel.f_46443_);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        return super.m_5922_(stack, level, livingEntity);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (level.f_46443_) {
            QuiverArrowSelectGui.setActive(false);
        }
        this.playInsertSound((Entity)livingEntity);
        livingEntity.m_6674_(livingEntity.m_7655_());
        super.m_5551_(stack, level, livingEntity, timeCharged);
    }

    public boolean m_142522_(ItemStack pStack) {
        IQuiverData data = QuiverItem.getQuiverData(pStack);
        if (data != null) {
            return data.getSelected().m_41613_() > 0;
        }
        return false;
    }

    public int m_142158_(ItemStack pStack) {
        IQuiverData data = QuiverItem.getQuiverData(pStack);
        if (data != null) {
            return Math.min(1 + 12 * data.getSelectedArrowCount() / (data.getSelected().m_41741_() * data.getContentView().size()), 13);
        }
        return 0;
    }

    public int m_142159_(ItemStack pStack) {
        return BAR_COLOR;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
        IQuiverData data = QuiverItem.getQuiverData(pStack);
        if (data != null) {
            NonNullList list = NonNullList.m_122779_();
            boolean isEmpty = true;
            for (ItemStack v : data.getContentView()) {
                if (!v.m_41619_()) {
                    isEmpty = false;
                }
                list.add((Object)v);
            }
            if (!isEmpty) {
                return Optional.of(new QuiverTooltip(new ArrayList<ItemStack>(data.getContentView()), data.getSelectedSlot()));
            }
        }
        return Optional.empty();
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        int c;
        IQuiverData data = QuiverItem.getQuiverData(pStack);
        if (data != null && (c = data.getSelectedArrowCount()) != 0) {
            pTooltipComponents.add((Component)new TranslatableComponent("message.supplementaries.quiver.tooltip", new Object[]{data.getSelected(null).m_41720_().m_41466_(), c}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_142023_(ItemEntity pItemEntity) {
        IQuiverData data = QuiverItem.getQuiverData(pItemEntity.m_32055_());
        if (data != null) {
            ItemUtils.m_150952_((ItemEntity)pItemEntity, data.getContentView().stream());
        }
    }

    private void playRemoveOneSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + pEntity.m_183503_().m_5822_().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + pEntity.m_183503_().m_5822_().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + pEntity.m_183503_().m_5822_().nextFloat() * 0.4f);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity2, int slotId, boolean isSelected) {
        IQuiverData data = QuiverItem.getQuiverData(stack);
        if (data != null) {
            data.updateSelectedIfNeeded();
        }
        super.m_6883_(stack, level, entity2, slotId, isSelected);
    }

    public static ItemStack getQuiver(LivingEntity entity2) {
        if (!(entity2 instanceof Player) && entity2 instanceof IQuiverEntity) {
            IQuiverEntity e = (IQuiverEntity)entity2;
            return e.getQuiver();
        }
        IItemHandler cap = (IItemHandler)entity2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (cap != null) {
            for (int i = 0; i < cap.getSlots(); ++i) {
                ItemStack quiver = cap.getStackInSlot(i);
                if (quiver.m_41720_() != ModRegistry.QUIVER_ITEM.get()) continue;
                return quiver;
            }
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public static IQuiverData getQuiverData(ItemStack stack) {
        return (QuiverCapability)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new QuiverCapability();
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag baseTag = stack.m_41783_();
        IQuiverData cap = QuiverItem.getQuiverData(stack);
        if (cap instanceof QuiverCapability) {
            QuiverCapability c = (QuiverCapability)cap;
            if (baseTag == null) {
                baseTag = new CompoundTag();
            }
            baseTag = baseTag.m_6426_();
            baseTag.m_128365_("QuiverCap", (Tag)c.serializeNBT());
        }
        return baseTag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag tag) {
        if (tag != null && tag.m_128441_("QuiverCap")) {
            CompoundTag capTag = tag.m_128469_("QuiverCap");
            tag.m_128473_("QuiverCap");
            IQuiverData cap = QuiverItem.getQuiverData(stack);
            if (cap instanceof QuiverCapability) {
                QuiverCapability c = (QuiverCapability)cap;
                c.deserializeNBT(capTag);
            }
        }
        stack.m_41751_(tag);
    }

    public static interface IQuiverData {
        public int getSelectedSlot();

        public void setSelectedSlot(int var1);

        public List<ItemStack> getContentView();

        default public boolean canAcceptItem(ItemStack toInsert) {
            return toInsert.m_41720_() instanceof ArrowItem;
        }

        default public ItemStack getSelected() {
            return this.getSelected(null);
        }

        default public ItemStack getSelected(@Nullable Predicate<ItemStack> supporterArrows) {
            List<ItemStack> content = this.getContentView();
            int selected = this.getSelectedSlot();
            if (supporterArrows == null) {
                return content.get(selected);
            }
            int size = content.size();
            for (int i = 0; i < size; ++i) {
                ItemStack s = content.get((i + selected) % size);
                if (!supporterArrows.test(s)) continue;
                return s;
            }
            return ItemStack.f_41583_;
        }

        default public boolean cycle() {
            return this.cycle(1);
        }

        default public boolean cycle(boolean clockWise) {
            return this.cycle(clockWise ? 1 : -1);
        }

        default public boolean cycle(int slotsMoved) {
            ItemStack selected;
            int originalSlot = this.getSelectedSlot();
            List<ItemStack> content = this.getContentView();
            if (slotsMoved == 0 && !(selected = content.get(this.getSelectedSlot())).m_41619_()) {
                return false;
            }
            int maxSlots = content.size();
            this.setSelectedSlot((maxSlots + (this.getSelectedSlot() + (slotsMoved %= maxSlots))) % maxSlots);
            for (int i = 0; i < maxSlots && (selected = content.get(this.getSelectedSlot())).m_41619_(); ++i) {
                this.setSelectedSlot((maxSlots + (this.getSelectedSlot() + (slotsMoved >= 0 ? 1 : -1))) % maxSlots);
            }
            return originalSlot != this.getSelectedSlot();
        }

        public ItemStack tryAdding(ItemStack var1);

        public Optional<ItemStack> removeOneStack();

        default public int getSelectedArrowCount() {
            ItemStack selected = this.getSelected(null);
            int amount = 0;
            for (ItemStack item2 : this.getContentView()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)selected, (ItemStack)item2)) continue;
                amount += item2.m_41613_();
            }
            return amount;
        }

        default public void updateSelectedIfNeeded() {
            this.cycle(0);
        }

        public void consumeArrow();
    }

    public record QuiverTooltip(List<ItemStack> stacks, int selected) implements TooltipComponent
    {
    }

    public static class QuiverCapability
    extends ItemStackHandler
    implements ICapabilitySerializable<CompoundTag>,
    IQuiverData {
        private final LazyOptional<IItemHandler> lazyOptional = LazyOptional.of(() -> this);
        private int selectedSlot = 0;

        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.lazyOptional);
        }

        public CompoundTag serializeNBT() {
            CompoundTag c = super.serializeNBT();
            c.m_128405_("SelectedSlot", this.selectedSlot);
            return c;
        }

        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.selectedSlot = nbt.m_128445_("SelectedSlot");
        }

        public QuiverCapability() {
            super(ServerConfigs.item.QUIVER_SLOTS.get().intValue());
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.canAcceptItem(stack);
        }

        @Override
        public List<ItemStack> getContentView() {
            return this.stacks;
        }

        @Override
        public int getSelectedSlot() {
            return this.selectedSlot;
        }

        @Override
        public void setSelectedSlot(int selectedSlot) {
            if (!((ItemStack)this.stacks.get(selectedSlot)).m_41619_()) {
                this.selectedSlot = selectedSlot;
            }
        }

        @Override
        public boolean cycle(int slotsMoved) {
            ItemStack stack;
            int originalSlot = this.selectedSlot;
            int maxSlots = this.stacks.size();
            this.selectedSlot = (maxSlots + (this.selectedSlot + (slotsMoved %= maxSlots))) % maxSlots;
            for (int i = 0; i < maxSlots && (stack = this.getStackInSlot(this.selectedSlot)).m_41619_(); ++i) {
                this.selectedSlot = (maxSlots + (this.selectedSlot + (slotsMoved >= 0 ? 1 : -1))) % maxSlots;
            }
            return originalSlot != this.selectedSlot;
        }

        @Override
        public ItemStack tryAdding(ItemStack toInsert) {
            if (!toInsert.m_41619_() && toInsert.m_41720_().m_142095_()) {
                return ItemHandlerHelper.insertItem((IItemHandler)this, (ItemStack)toInsert, (boolean)false);
            }
            return toInsert;
        }

        @Override
        public Optional<ItemStack> removeOneStack() {
            int i = 0;
            for (ItemStack s : this.getContentView()) {
                if (!s.m_41619_()) {
                    ItemStack extracted = this.extractItem(i, s.m_41613_(), false);
                    this.updateSelectedIfNeeded();
                    return Optional.of(extracted);
                }
                ++i;
            }
            return Optional.empty();
        }

        @Override
        public void consumeArrow() {
            ItemStack s = this.getSelected();
            s.m_41774_(1);
            if (s.m_41619_()) {
                this.stacks.set(this.selectedSlot, (Object)ItemStack.f_41583_);
            }
            this.updateSelectedIfNeeded();
        }
    }
}

