/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.api.IRotatable;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.farmersdelight.FDCompatRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StickBlock
extends WaterBlock
implements IRotatable {
    protected static final VoxelShape Y_AXIS_AABB = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0);
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    protected static final VoxelShape Y_Z_AXIS_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0));
    protected static final VoxelShape Y_X_AXIS_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0));
    protected static final VoxelShape X_Z_AXIS_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0));
    protected static final VoxelShape X_Y_Z_AXIS_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0), Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)});
    public static final BooleanProperty AXIS_X = BlockProperties.AXIS_X;
    public static final BooleanProperty AXIS_Y = BlockProperties.AXIS_Y;
    public static final BooleanProperty AXIS_Z = BlockProperties.AXIS_Z;
    protected final Map<Direction.Axis, BooleanProperty> AXIS2PROPERTY = ImmutableMap.of((Object)Direction.Axis.X, (Object)AXIS_X, (Object)Direction.Axis.Y, (Object)AXIS_Y, (Object)Direction.Axis.Z, (Object)AXIS_Z);
    private final int fireSpread;

    public StickBlock(BlockBehaviour.Properties properties, int fireSpread) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)AXIS_Y, (Comparable)Boolean.valueOf(true))).m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AXIS_Z, (Comparable)Boolean.valueOf(false)));
        this.fireSpread = fireSpread;
    }

    public StickBlock(BlockBehaviour.Properties properties) {
        this(properties, 60);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? 0 : this.fireSpread;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? 0 : this.fireSpread;
    }

    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TextComponent("You shouldn't have this").m_130940_(ChatFormatting.GRAY));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AXIS_X, AXIS_Y, AXIS_Z});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        boolean x = (Boolean)state.m_61143_((Property)AXIS_X);
        boolean y = (Boolean)state.m_61143_((Property)AXIS_Y);
        boolean z = (Boolean)state.m_61143_((Property)AXIS_Z);
        return StickBlock.getStickShape(x, y, z);
    }

    public static VoxelShape getStickShape(boolean x, boolean y, boolean z) {
        if (x) {
            if (y) {
                if (z) {
                    return X_Y_Z_AXIS_AABB;
                }
                return Y_X_AXIS_AABB;
            }
            if (z) {
                return X_Z_AXIS_AABB;
            }
            return X_AXIS_AABB;
        }
        if (z) {
            if (y) {
                return Y_Z_AXIS_AABB;
            }
            return Z_AXIS_AABB;
        }
        return Y_AXIS_AABB;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this == ModRegistry.STICK_BLOCK.get() && facing == Direction.DOWN && !worldIn.m_5776_() && CompatHandler.farmers_delight) {
            FDCompatRegistry.tryTomatoLogging(facingState, worldIn, facingPos, false);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        BooleanProperty axis = this.AXIS2PROPERTY.get(context.m_43719_().m_122434_());
        if (blockstate.m_60713_((Block)this) || CompatHandler.farmers_delight && FDCompatRegistry.canAddStickToTomato(blockstate, axis)) {
            return (BlockState)blockstate.m_61124_((Property)axis, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)AXIS_Y, (Comparable)Boolean.valueOf(false))).m_61124_((Property)axis, (Comparable)Boolean.valueOf(true));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        BooleanProperty axis;
        if (!context.m_7078_() && context.m_43722_().m_150930_(this.m_5456_()) && !((Boolean)state.m_61143_((Property)(axis = this.AXIS2PROPERTY.get(context.m_43719_().m_122434_())))).booleanValue()) {
            return true;
        }
        return super.m_6864_(state, context);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_41619_() && hand == InteractionHand.MAIN_HAND && ServerConfigs.cached.STICK_POLE) {
            if (this.f_60442_ != Material.f_76320_) {
                return InteractionResult.PASS;
            }
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            Direction moveDir = player.m_6144_() ? Direction.DOWN : Direction.UP;
            StickBlock.findConnectedFlag(world, pos, Direction.UP, moveDir, 0);
            StickBlock.findConnectedFlag(world, pos, Direction.DOWN, moveDir, 0);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static boolean isVertical(BlockState state) {
        return (Boolean)state.m_61143_((Property)AXIS_Y) != false && (Boolean)state.m_61143_((Property)AXIS_X) == false && (Boolean)state.m_61143_((Property)AXIS_Z) == false;
    }

    public static boolean findConnectedFlag(Level world, BlockPos pos, Direction searchDir, Direction moveDir, int it) {
        if (it > ServerConfigs.cached.STICK_POLE_LENGTH) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        Block b = state.m_60734_();
        if (b == ModRegistry.STICK_BLOCK.get() && StickBlock.isVertical(state)) {
            return StickBlock.findConnectedFlag(world, pos.m_142300_(searchDir), searchDir, moveDir, it + 1);
        }
        if (b instanceof FlagBlock && it != 0) {
            BlockPos toPos = pos.m_142300_(moveDir);
            BlockState stick = world.m_8055_(toPos);
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof FlagBlockTile) {
                FlagBlockTile tile = (FlagBlockTile)blockEntity;
                if (stick.m_60734_() == ModRegistry.STICK_BLOCK.get() && StickBlock.isVertical(stick)) {
                    world.m_46597_(pos, stick);
                    world.m_46597_(toPos, state);
                    CompoundTag tag = tile.m_187482_();
                    BlockEntity te = world.m_7702_(toPos);
                    if (te != null) {
                        te.m_142466_(tag);
                    }
                    world.m_5594_(null, toPos, SoundEvents.f_12642_, SoundSource.BLOCKS, 1.0f, 1.4f);
                    return true;
                }
            }
        }
        return false;
    }

    public BlockState applyRotationLock(Level world, BlockPos blockPos, BlockState state, Direction dir, int half) {
        int i = 0;
        if (((Boolean)state.m_61143_((Property)AXIS_X)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.m_61143_((Property)AXIS_Y)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.m_61143_((Property)AXIS_Z)).booleanValue()) {
            ++i;
        }
        if (i == 1) {
            ((BlockState)((BlockState)((BlockState)state.m_61124_((Property)AXIS_Z, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AXIS_Y, (Comparable)Boolean.valueOf(false))).m_61124_((Property)this.AXIS2PROPERTY.get(dir.m_122434_()), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        boolean x = (Boolean)state.m_61143_((Property)AXIS_X);
        boolean y = (Boolean)state.m_61143_((Property)AXIS_Y);
        boolean z = (Boolean)state.m_61143_((Property)AXIS_Z);
        return Optional.of(switch (axis.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.Y -> (BlockState)((BlockState)state.m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(z))).m_61124_((Property)AXIS_Z, (Comparable)Boolean.valueOf(x));
            case Direction.Axis.X -> (BlockState)((BlockState)state.m_61124_((Property)AXIS_Y, (Comparable)Boolean.valueOf(z))).m_61124_((Property)AXIS_Z, (Comparable)Boolean.valueOf(y));
            case Direction.Axis.Z -> (BlockState)((BlockState)state.m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(y))).m_61124_((Property)AXIS_Y, (Comparable)Boolean.valueOf(x));
        });
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.getRotatedState(state, null, null, rotation, Direction.UP, null).orElse(state);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder pBuilder) {
        int i = 0;
        if (((Boolean)state.m_61143_((Property)AXIS_X)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.m_61143_((Property)AXIS_Y)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.m_61143_((Property)AXIS_Z)).booleanValue()) {
            ++i;
        }
        return List.of(new ItemStack((ItemLike)this.m_5456_(), i));
    }
}

