/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.mehvahdjukaar.supplementaries.client.renderers.CapturedMobCache;
import net.mehvahdjukaar.supplementaries.client.renderers.RotHlpr;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PedestalBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PedestalBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.setup.ClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PedestalBlockTileRenderer
implements BlockEntityRenderer<PedestalBlockTile> {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final ItemRenderer itemRenderer = this.minecraft.m_91291_();
    private final EntityRenderDispatcher entityRenderer = this.minecraft.m_91290_();

    public PedestalBlockTileRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected boolean canRenderName(PedestalBlockTile tile) {
        if (Minecraft.m_91404_() && tile.m_8020_(0).m_41788_() && !tile.f_58855_.isGlobe()) {
            double d0 = this.entityRenderer.m_114378_((double)tile.m_58899_().m_123341_() + 0.5, (double)tile.m_58899_().m_123342_() + 0.5, (double)tile.m_58899_().m_123343_() + 0.5);
            return d0 < 256.0;
        }
        return false;
    }

    public static void renderName(Component name, float h, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft mc = Minecraft.m_91087_();
        int s = "Dinnerbone".equals(name.getString()) ? -1 : 1;
        poseStack.m_85841_((float)s, (float)s, 1.0f);
        boolean i = false;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)h, 0.0);
        poseStack.m_85845_(mc.m_91290_().m_114470_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        float f1 = mc.f_91066_.m_92141_(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        float f2 = -mc.f_91062_.m_92852_((FormattedText)name) / 2;
        mc.f_91062_.m_92841_(name, f2, (float)i, -1, false, matrix4f, bufferIn, false, j, combinedLightIn);
        poseStack.m_85849_();
    }

    public void render(PedestalBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.m_7983_()) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 1.125, 0.5);
            if (this.canRenderName(tile)) {
                PedestalBlockTileRenderer.renderName(tile.m_8020_(0).m_41786_(), 0.875f, matrixStackIn, bufferIn, combinedLightIn);
            }
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            matrixStackIn.m_85837_(0.0, 0.25, 0.0);
            if (tile.m_58900_().m_61143_(PedestalBlock.AXIS) == Direction.Axis.X) {
                matrixStackIn.m_85845_(RotHlpr.Y90);
            }
            ItemTransforms.TransformType transform = ItemTransforms.TransformType.FIXED;
            ItemStack stack = tile.getDisplayedItem();
            if (ClientConfigs.cached.PEDESTAL_SPECIAL) {
                switch (tile.f_58855_) {
                    case SWORD: {
                        matrixStackIn.m_85837_(0.0, -0.03125, 0.0);
                        matrixStackIn.m_85841_(1.5f, 1.5f, 1.5f);
                        matrixStackIn.m_85845_(RotHlpr.Z135);
                        break;
                    }
                    case TRIDENT: {
                        matrixStackIn.m_85837_(0.0, 0.03125, 0.0);
                        matrixStackIn.m_85841_(1.5f, 1.5f, 1.5f);
                        matrixStackIn.m_85845_(RotHlpr.ZN45);
                        break;
                    }
                    case CRYSTAL: {
                        this.entityRenderer.m_114384_((Entity)CapturedMobCache.getCrystal(), 0.0, 0.0, 0.0, 0.0f, partialTicks, matrixStackIn, bufferIn, combinedLightIn);
                        matrixStackIn.m_85849_();
                        return;
                    }
                    default: {
                        if (ClientConfigs.cached.PEDESTAL_SPIN) {
                            matrixStackIn.m_85837_(0.0, 0.375, 0.0);
                            matrixStackIn.m_85841_(1.5f, 1.5f, 1.5f);
                            int scale = (int)(ClientConfigs.cached.PEDESTAL_SPEED * 360.0);
                            long time = tile.m_58904_().m_46467_();
                            float angle = ((float)Math.floorMod(time, (long)scale) + partialTicks) / (float)scale;
                            Quaternion rotation = Vector3f.f_122225_.m_122270_((float)((double)angle * Math.PI * 10.0));
                            matrixStackIn.m_85845_(rotation);
                        }
                        if (!tile.f_58855_.isGlobe()) break;
                        if (ClientRegistry.GLOBE_RENDERER_INSTANCE != null) {
                            boolean sepia = tile.f_58855_ == PedestalBlockTile.DisplayType.SEPIA_GLOBE;
                            Pair<GlobeBlockTile.GlobeModel, ResourceLocation> pair = stack.m_41788_() ? GlobeBlockTile.GlobeType.getGlobeTexture(stack.m_41786_().getString()) : Pair.of((Object)((Object)GlobeBlockTile.GlobeModel.GLOBE), null);
                            ClientRegistry.GLOBE_RENDERER_INSTANCE.renderGlobe(pair, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, sepia, tile.m_58904_());
                        }
                        matrixStackIn.m_85849_();
                        return;
                    }
                }
            }
            if (CommonUtil.FESTIVITY.isAprilsFool()) {
                stack = new ItemStack((ItemLike)Items.f_42329_);
            }
            this.itemRenderer.m_174269_(stack, transform, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, 0);
            matrixStackIn.m_85849_();
        }
    }
}

