/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.sides;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public enum DistributionType {
    CLIENT(Set.of("client")),
    SERVER(Set.of("server", "dedicated_server"));

    private static final Map<Enum<?>, DistributionType> CACHE;
    private final Set<String> names;

    private DistributionType(Set<String> names) {
        this.names = names;
    }

    public boolean isServer() {
        return this == SERVER;
    }

    public boolean isClient() {
        return this == CLIENT;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public boolean matches(String name) {
        return this.getNames().contains(name.toLowerCase(Locale.ROOT));
    }

    public static DistributionType from(Enum<?> other) {
        return CACHE.computeIfAbsent(other, key -> {
            String name = key.name().toLowerCase(Locale.ROOT);
            return Arrays.stream(DistributionType.values()).filter(it -> it.getNames().contains(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create DistributionType from provided enum " + key + " of class " + key.getClass()));
        });
    }

    static {
        CACHE = new HashMap();
    }
}

