/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionAnyDamagedSerializer;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionCustomSerializer;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionDamagedSerializer;
import com.blamejared.crafttweaker.api.ingredient.serializer.IngredientAnySerializer;
import com.blamejared.crafttweaker.api.ingredient.serializer.IngredientConditionedSerializer;
import com.blamejared.crafttweaker.api.ingredient.serializer.IngredientListSerializer;
import com.blamejared.crafttweaker.api.ingredient.serializer.IngredientPartialTagSerializer;
import com.blamejared.crafttweaker.api.ingredient.serializer.IngredientTransformedSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformCustomSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformDamageSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformReplaceSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformerReuseSerializer;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientConditioned;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientTransformed;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientAny;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientConditioned;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientList;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientPartialTag;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientTransformed;
import com.blamejared.crafttweaker.api.recipe.serializer.CTShapedRecipeSerializer;
import com.blamejared.crafttweaker.api.recipe.serializer.CTShapelessRecipeSerializer;
import com.blamejared.crafttweaker.api.recipe.serializer.ICTShapedRecipeBaseSerializer;
import com.blamejared.crafttweaker.api.recipe.serializer.ICTShapelessRecipeBaseSerializer;
import com.blamejared.crafttweaker.impl.loot.LootTableIdRegexCondition;
import com.blamejared.crafttweaker.impl.script.ScriptSerializer;
import com.blamejared.crafttweaker.platform.registry.ForgeRegistryWrapper;
import com.blamejared.crafttweaker.platform.registry.RegistryWrapper;
import com.blamejared.crafttweaker.platform.services.IRegistryHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeRegistryHelper
implements IRegistryHelper {
    @Override
    public void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(newRegistry -> {
            CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER = this.registerVanillaRegistry(CraftTweakerConstants.rl("transformer_serializer"));
            CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER = this.registerVanillaRegistry(CraftTweakerConstants.rl("condition_serializer"));
            this.registerSerializer(CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER, TransformReplaceSerializer.INSTANCE);
            this.registerSerializer(CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER, TransformDamageSerializer.INSTANCE);
            this.registerSerializer(CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER, TransformCustomSerializer.INSTANCE);
            this.registerSerializer(CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER, TransformerReuseSerializer.INSTANCE);
            this.registerSerializer(CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER, ConditionDamagedSerializer.INSTANCE);
            this.registerSerializer(CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER, ConditionAnyDamagedSerializer.INSTANCE);
            this.registerSerializer(CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER, ConditionCustomSerializer.INSTANCE);
        });
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, blockRegister -> Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)new ResourceLocation("crafttweaker", "loot_table_id_regex"), (Object)LootTableIdRegexCondition.LOOT_TABLE_ID_REGEX));
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(RecipeSerializer.class, register -> {
            CraftTweakerRegistries.RECIPE_TYPE_SCRIPTS = RecipeType.m_44119_((String)CraftTweakerConstants.rl("scripts").toString());
            register.getRegistry().register((IForgeRegistryEntry)CTShapelessRecipeSerializer.INSTANCE);
            register.getRegistry().register((IForgeRegistryEntry)CTShapedRecipeSerializer.INSTANCE);
            register.getRegistry().register((IForgeRegistryEntry)ScriptSerializer.INSTANCE);
        });
        CraftingHelper.register((ResourceLocation)CraftTweakerConstants.rl("any"), (IIngredientSerializer)IngredientAnySerializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)CraftTweakerConstants.rl("list"), (IIngredientSerializer)IngredientListSerializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)CraftTweakerConstants.rl("transformed"), (IIngredientSerializer)IngredientTransformedSerializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)CraftTweakerConstants.rl("conditioned"), (IIngredientSerializer)IngredientConditionedSerializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)CraftTweakerConstants.rl("partial_tag"), (IIngredientSerializer)IngredientPartialTagSerializer.INSTANCE);
    }

    @Override
    public ICTShapedRecipeBaseSerializer getCTShapedRecipeSerializer() {
        return CTShapedRecipeSerializer.INSTANCE;
    }

    @Override
    public ICTShapelessRecipeBaseSerializer getCTShapelessRecipeSerializer() {
        return CTShapelessRecipeSerializer.INSTANCE;
    }

    @Override
    public Ingredient getIngredientAny() {
        return IngredientAny.INSTANCE;
    }

    @Override
    public Ingredient getIngredientList(List<Ingredient> children) {
        return new IngredientList(children);
    }

    @Override
    public <T extends IIngredient> Ingredient getIngredientConditioned(IIngredientConditioned<T> conditioned) {
        return new IngredientConditioned(conditioned);
    }

    @Override
    public <T extends IIngredient> Ingredient getIngredientTransformed(IIngredientTransformed<T> transformed) {
        return new IngredientTransformed(transformed);
    }

    @Override
    public Ingredient getIngredientPartialTag(ItemStack stack) {
        return new IngredientPartialTag(stack);
    }

    @Override
    public Optional<ResourceLocation> maybeGetRegistryKey(Object object) {
        if (object instanceof IForgeRegistryEntry) {
            return Optional.ofNullable(((IForgeRegistryEntry)object).getRegistryName());
        }
        return Optional.empty();
    }

    private <V extends IForgeRegistryEntry<V>> RegistryWrapper<V> wrap(IForgeRegistry<V> registry) {
        return new ForgeRegistryWrapper<V>(registry);
    }

    @Override
    public RegistryWrapper<Item> items() {
        return this.wrap(ForgeRegistries.ITEMS);
    }

    @Override
    public RegistryWrapper<Potion> potions() {
        return this.wrap(ForgeRegistries.POTIONS);
    }

    @Override
    public RegistryWrapper<RecipeSerializer<?>> recipeSerializers() {
        return this.wrap(ForgeRegistries.RECIPE_SERIALIZERS);
    }

    @Override
    public RegistryWrapper<Attribute> attributes() {
        return this.wrap(ForgeRegistries.ATTRIBUTES);
    }

    @Override
    public RegistryWrapper<Fluid> fluids() {
        return this.wrap(ForgeRegistries.FLUIDS);
    }

    @Override
    public RegistryWrapper<Enchantment> enchantments() {
        return this.wrap(ForgeRegistries.ENCHANTMENTS);
    }

    @Override
    public RegistryWrapper<Block> blocks() {
        return this.wrap(ForgeRegistries.BLOCKS);
    }

    @Override
    public RegistryWrapper<MobEffect> mobEffects() {
        return this.wrap(ForgeRegistries.MOB_EFFECTS);
    }

    @Override
    public RegistryWrapper<VillagerProfession> villagerProfessions() {
        return this.wrap(ForgeRegistries.PROFESSIONS);
    }

    @Override
    public RegistryWrapper<SoundEvent> soundEvents() {
        return this.wrap(ForgeRegistries.SOUND_EVENTS);
    }

    @Override
    public RegistryWrapper<EntityType<?>> entityTypes() {
        return this.wrap(ForgeRegistries.ENTITIES);
    }
}

