/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public final class IngredientUtil {
    public static boolean canConflict(Ingredient a, Ingredient b) {
        return a == b || a.m_43908_().length == 0 && b.m_43908_().length == 0 || !IngredientUtil.findIntersection(a, b).isEmpty();
    }

    public static List<ItemStack> findIntersection(Ingredient a, Ingredient b) {
        if (a == Ingredient.f_43901_ || b == Ingredient.f_43901_) {
            return Collections.emptyList();
        }
        ItemStack[] aStacks = a.m_43908_();
        ItemStack[] bStacks = b.m_43908_();
        if (a == b) {
            return Arrays.asList(aStacks);
        }
        ArrayList<ItemStack> intersection = null;
        for (ItemStack aStack : aStacks) {
            for (ItemStack bStack : bStacks) {
                if (!ItemStackUtil.areStacksTheSame(aStack, bStack)) continue;
                if (intersection == null) {
                    intersection = new ArrayList<ItemStack>();
                }
                intersection.add(aStack);
            }
        }
        return intersection == null ? Collections.emptyList() : intersection;
    }

    public static boolean doIngredientsConflict(List<Ingredient> first, List<Ingredient> second) {
        BitSet visitData = new BitSet(second.size());
        block0: for (Ingredient target : first) {
            for (int j = 0; j < second.size(); ++j) {
                Ingredient attempt;
                if (visitData.get(j) || !IngredientUtil.canConflict(target, attempt = second.get(j))) continue;
                visitData.set(j);
                continue block0;
            }
        }
        return visitData.nextClearBit(0) == second.size();
    }
}

