/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.recipe.replace;

import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRecipeBase;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipeByName;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.google.common.base.Suppliers;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;

public class ActionReplaceRecipe<T extends Recipe<?>>
extends ActionRecipeBase<T> {
    private final Supplier<ActionAddRecipe<T>> addRecipe;
    private final ActionRemoveRecipeByName<T> removeRecipe;
    private final ResourceLocation oldName;
    private final Supplier<ResourceLocation> newName;

    public ActionReplaceRecipe(IRecipeManager<T> manager, Function<ResourceLocation, ResourceLocation> nameGenerator, Recipe<?> oldRecipe, Function<ResourceLocation, T> recipeCreator) {
        super(manager);
        this.oldName = oldRecipe.m_6423_();
        this.newName = Suppliers.memoize(() -> (ResourceLocation)nameGenerator.apply(this.oldName));
        this.removeRecipe = new ActionRemoveRecipeByName<T>(manager, this.oldName);
        this.addRecipe = () -> new ActionAddRecipe<Recipe>(manager, (Recipe)recipeCreator.apply(this.newName.get()));
    }

    @Override
    public void apply() {
        this.removeRecipe.apply();
        this.addRecipe.get().apply();
    }

    @Override
    public String describe() {
        return String.format("- Replacing \"%s\" recipe with name \"%s\"%s", this.getManager().getBracketResourceLocation(), this.oldName, this.oldName.equals((Object)this.newName.get()) ? "" : String.format(", renaming it to \"%s\"", this.newName.get()));
    }
}

