/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.config.CoreClientConfig;
import cofh.core.config.CoreCommonConfig;
import cofh.core.init.CoreMobEffects;
import cofh.core.item.ItemCoFH;
import cofh.core.util.ProxyUtils;
import cofh.lib.api.block.IDismantleable;
import cofh.lib.api.block.IWrenchable;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.entity.ThrownFluxWrench;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class FluxWrenchItem
extends ItemCoFH
implements IMultiModeFluxItem {
    protected static final Set<Enchantment> VALID_ENCHANTS = new ObjectOpenHashSet();
    protected final float damage;
    protected final float attackSpeed;
    protected final int throwCooldown;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxWrenchItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder, int energy, int xfer) {
        super(builder);
        this.damage = tier.m_6631_() + attackDamageIn;
        this.attackSpeed = attackSpeedIn;
        this.throwCooldown = (int)(20.0f / (4.0f + attackSpeedIn)) + 2;
        this.setEnchantability(tier.m_6601_());
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() || ((Boolean)CoreClientConfig.alwaysShowDetails.get()).booleanValue()) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (((Boolean)CoreClientConfig.holdShiftForDetails.get()).booleanValue()) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IMultiModeFluxItem.super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public static void initEnchants() {
        VALID_ENCHANTS.add(Enchantments.f_44977_);
        VALID_ENCHANTS.add(Enchantments.f_44981_);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || VALID_ENCHANTS.contains(enchantment);
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.hasEnergy(stack, false)) {
            if (!world.m_5776_()) {
                world.m_7967_((Entity)new ThrownFluxWrench(world, (LivingEntity)player, stack));
                player.f_36093_.m_36057_(stack);
                player.m_36335_().m_41524_((Item)this, this.getRangedAttackCooldown(stack));
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    protected boolean useDelegate(ItemStack stack, UseOnContext context) {
        IDismantleable dismantleable;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (player == null || world.m_46859_(pos)) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (player.m_36341_() && block instanceof IDismantleable && (dismantleable = (IDismantleable)block).canDismantle(world, pos, state, player)) {
            BlockHitResult target = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_());
            dismantleable.dismantleBlock(world, pos, state, (HitResult)target, player, CoreCommonConfig.returnDismantleDrops());
            player.m_6674_(context.m_43724_());
            return true;
        }
        if (!player.m_36341_()) {
            IWrenchable wrenchable;
            if (block instanceof IWrenchable && (wrenchable = (IWrenchable)block).canWrench(world, pos, state, player)) {
                BlockHitResult target = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_());
                wrenchable.wrenchBlock(world, pos, state, (HitResult)target, player);
                return true;
            }
            return BlockHelper.attemptRotateBlock((BlockState)state, (Level)world, (BlockPos)pos);
        }
        return false;
    }

    public boolean useRanged(Level world, ItemStack stack, Player player, BlockHitResult result) {
        IWrenchable wrenchable;
        if (result.m_6662_() == HitResult.Type.MISS) {
            return false;
        }
        BlockPos pos = result.m_82425_();
        if (player == null || world.m_46859_(pos) || !this.hasEnergy(stack, false) && !player.f_36077_.f_35937_ || !player.m_36204_(pos, result.m_82434_(), stack)) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof IWrenchable && (wrenchable = (IWrenchable)block).canWrench(world, pos, state, player)) {
            wrenchable.wrenchBlock(world, pos, state, (HitResult)result, player);
            this.useEnergy(stack, false, player.f_36077_.f_35937_);
            return true;
        }
        if (BlockHelper.attemptRotateBlock((BlockState)state, (Level)world, (BlockPos)pos)) {
            this.useEnergy(stack, false, player.f_36077_.f_35937_);
            return true;
        }
        return false;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        return player.m_36204_(context.m_8083_(), context.m_43719_(), stack) && this.useDelegate(stack, context) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.WRENCHED.get(), 60, 0, false, false));
        this.useEnergy(stack, false, (Entity)attacker);
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((Level)worldIn) && state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack, false) ? this.damage : 0.0f;
    }

    public float getRangedAttackDamage(ItemStack stack) {
        return this.getAttackDamage(stack);
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed;
    }

    protected int getRangedAttackCooldown(ItemStack stack) {
        return this.throwCooldown;
    }

    public boolean m_142522_(ItemStack stack) {
        return IMultiModeFluxItem.super.isBarVisible(stack);
    }

    public int m_142159_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarColor(stack);
    }

    public int m_142158_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarWidth(stack);
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }
}

