/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.config.CoreClientConfig;
import cofh.core.util.ProxyUtils;
import cofh.lib.item.PickaxeItemCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.init.RSABlocks;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;

public class FluxPickaxeItem
extends PickaxeItemCoFH
implements IMultiModeFluxItem {
    protected final int LOW_LIGHT_THRESHOLD = 5;
    protected final int REMOVE_RADIUS = 10;
    protected final float damage = this.m_41008_();
    protected final float attackSpeed;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxPickaxeItem(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder, int energy, int xfer) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.attackSpeed = attackSpeedIn;
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() || ((Boolean)CoreClientConfig.alwaysShowDetails.get()).booleanValue()) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (((Boolean)CoreClientConfig.holdShiftForDetails.get()).booleanValue()) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return this.hasEnergy(stack, false) && super.canPerformAction(stack, action);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.useEnergy(stack, false, (Entity)attacker);
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((Level)worldIn) && state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.hasEnergy(stack, false) && super.isCorrectToolForDrops(stack, state);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.isCorrectToolForDrops(stack, state) ? this.f_40980_ : 1.0f;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack tool = context.m_43722_();
        Player player = context.m_43723_();
        if (player != null) {
            Level world = context.m_43725_();
            if (player.m_6144_()) {
                if (this.useEnergy(tool, true, player.f_36077_.f_35937_)) {
                    int r = 10;
                    int r2 = r * r;
                    for (BlockPos pos : BlockPos.m_121940_((BlockPos)context.m_8083_().m_142082_(-r, -r, -r), (BlockPos)context.m_8083_().m_142082_(r, r, r))) {
                        if (!(pos.m_123331_((Vec3i)context.m_8083_()) < (double)r2) || !world.m_8055_(pos).m_60734_().equals(RSABlocks.FLUX_GLOW_AIR.get())) continue;
                        this.removeAir(world, player, pos, 0.3f);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                BlockPos pos = context.m_8083_().m_142300_(context.m_43719_());
                BlockState state = world.m_8055_(pos);
                if (state.m_60734_().equals(RSABlocks.FLUX_GLOW_AIR.get()) && this.useEnergy(tool, false, player.f_36077_.f_35937_)) {
                    this.removeAir(world, player, pos, 0.5f);
                    return InteractionResult.SUCCESS;
                }
                if (state.m_60795_() && this.useEnergy(tool, true, player.f_36077_.f_35937_)) {
                    this.placeAir(world, player, pos, 0.5f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        BlockPos pos;
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (!world.m_5776_() && this.isEmpowered(stack) && world.m_46467_() % 8L == 0L && world.m_46859_(pos = entity.m_142538_()) && world.m_45524_(pos, world.m_7445_()) <= 5 && this.useEnergy(stack, true, entity)) {
            this.placeAir(world, null, pos, 0.3f);
        }
    }

    public void placeAir(Level world, Player player, BlockPos pos, float volume) {
        world.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.PLAYERS, volume, 1.0f);
        if (!world.m_5776_()) {
            ((ServerLevel)world).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 4, 0.25, 0.25, 0.25, 0.0);
        }
        world.m_46597_(pos, ((Block)RSABlocks.FLUX_GLOW_AIR.get()).m_49966_());
    }

    public void removeAir(Level world, Player player, BlockPos pos, float volume) {
        world.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.PLAYERS, 0.5f, 1.0f);
        if (!world.m_5776_()) {
            ((ServerLevel)world).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 4, 0.25, 0.25, 0.25, 0.0);
        }
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack, false) ? this.damage : 0.0f;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed;
    }

    public boolean m_142522_(ItemStack stack) {
        return IMultiModeFluxItem.super.isBarVisible(stack);
    }

    public int m_142159_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarColor(stack);
    }

    public int m_142158_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarWidth(stack);
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }
}

