/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.capability.CapabilityAreaEffect;
import cofh.core.config.CoreClientConfig;
import cofh.core.item.HammerItem;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.AreaEffectHelper;
import cofh.lib.api.capability.IAreaEffectItem;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.entity.Shockwave;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FluxHammerItem
extends HammerItem
implements IMultiModeFluxItem {
    protected final float damage = this.m_41008_();
    protected final float attackSpeed;
    public float knockbackMod = 1.0f;
    public int slamCooldown = 160;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxHammerItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder, int energy, int xfer) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.attackSpeed = attackSpeedIn;
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() || ((Boolean)CoreClientConfig.alwaysShowDetails.get()).booleanValue()) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (((Boolean)CoreClientConfig.holdShiftForDetails.get()).booleanValue()) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluxHammerItemWrapper(stack, this);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        int energy = this.getEnergyPerUse(true) * 2;
        if (player == null || !player.m_20096_() || !this.isEmpowered(stack) || !this.hasEnergy(stack, energy) && !player.f_36077_.f_35937_) {
            return InteractionResult.FAIL;
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = world.m_8055_(pos);
        if (world.f_46443_) {
            world.m_5594_(player, pos, state.getSoundType((LevelReader)world, pos, (Entity)player).m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (world.m_7967_((Entity)new Shockwave(world, (LivingEntity)player, Vec3.m_82512_((Vec3i)pos), player.f_19857_))) {
            this.useEnergy(stack, energy, player.f_36077_.f_35937_);
            player.m_36335_().m_41524_((Item)this, this.getSlamCooldown(stack));
        }
        return InteractionResult.SUCCESS;
    }

    protected int getSlamCooldown(ItemStack stack) {
        return this.slamCooldown;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return this.hasEnergy(stack, false) && super.canPerformAction(stack, action);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.useEnergy(stack, this.isEmpowered(stack), (Entity)attacker) && this.isEmpowered(stack)) {
            attacker.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 40, 0));
            if (attacker.m_21023_(MobEffects.f_19600_)) {
                attacker.m_7292_(new MobEffectInstance(MobEffects.f_19600_, attacker.m_21124_(MobEffects.f_19600_).m_19557_() + 10, 0));
            }
            attacker.m_6858_(true);
        }
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((Level)worldIn) && state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.hasEnergy(stack, false) && super.isCorrectToolForDrops(stack, state);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.isCorrectToolForDrops(stack, state) && !this.isEmpowered(stack) ? this.f_40980_ : 1.0f;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(Constants.UUID_WEAPON_KNOCKBACK, "Tool modifier", (double)this.getKnockbackModifier(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack, false) ? (this.isEmpowered(stack) && this.hasEnergy(stack, true) ? this.damage + 2.0f : this.damage) : 0.0f;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.hasEnergy(stack, false) && this.isEmpowered(stack) && this.hasEnergy(stack, true) ? this.attackSpeed + 0.8f : this.attackSpeed;
    }

    protected float getKnockbackModifier(ItemStack stack) {
        return this.knockbackMod;
    }

    public boolean m_142522_(ItemStack stack) {
        return IMultiModeFluxItem.super.isBarVisible(stack);
    }

    public int m_142159_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarColor(stack);
    }

    public int m_142158_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarWidth(stack);
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    protected class FluxHammerItemWrapper
    extends EnergyContainerItemWrapper
    implements IAreaEffectItem {
        private final LazyOptional<IAreaEffectItem> holder;

        FluxHammerItemWrapper(ItemStack containerIn, IEnergyContainerItem itemIn) {
            super(containerIn, itemIn, itemIn.getEnergyCapability());
            this.holder = LazyOptional.of(() -> this);
        }

        public ImmutableList<BlockPos> getAreaEffectBlocks(BlockPos pos, Player player) {
            if (FluxHammerItem.this.hasEnergy(this.container, false)) {
                return AreaEffectHelper.getBreakableBlocksRadius((ItemStack)this.container, (BlockPos)pos, (Player)player, (int)(1 + Utils.getItemEnchantmentLevel((Enchantment)Utils.getEnchantment((String)"ensorcellation", (String)"excavating"), (ItemStack)this.container)));
            }
            return ImmutableList.of();
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY) {
                return CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

