/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.config.CoreClientConfig;
import cofh.core.util.ProxyUtils;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.FluxArmorItem;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class FluxElytraItem
extends FluxArmorItem
implements IMultiModeFluxItem {
    public float propelSpeed = 0.85f;
    public float brakeRate = 0.95f;
    public int boostTime = 32;
    public int energyUseInterval = 8;

    public FluxElytraItem(ArmorMaterial material, EquipmentSlot slot, Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(material, slot, builder, maxEnergy, maxTransfer);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() || ((Boolean)CoreClientConfig.alwaysShowDetails.get()).booleanValue()) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (((Boolean)CoreClientConfig.holdShiftForDetails.get()).booleanValue()) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this, this.getEnergyCapability());
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return this.hasEnergy(stack, false);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        boolean simulate;
        boolean isCreative = Utils.isCreativePlayer((Entity)entity);
        boolean bl = simulate = isCreative || flightTicks % this.energyUseInterval != 0;
        if (!this.useEnergy(stack, false, simulate)) {
            return false;
        }
        if (entity.m_6144_() && this.useEnergy(stack, true, simulate)) {
            stack.m_41784_().m_128473_("Time");
            this.brake(entity);
        } else {
            CompoundTag tag = stack.m_41784_();
            long time = entity.f_19853_.m_46467_();
            if (time - tag.m_128454_("Time") <= (long)this.boostTime) {
                this.propel(entity);
            } else if (this.isEmpowered(stack) && this.useEnergy(stack, true, isCreative)) {
                tag.m_128356_("Time", time);
                this.propel(entity);
            }
        }
        return true;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof LivingEntity && !((LivingEntity)entity).m_21255_()) {
            stack.m_41784_().m_128473_("Time");
        }
    }

    public boolean boost(ItemStack stack, LivingEntity entity, int time) {
        boolean isCreative;
        if (!entity.m_6844_(EquipmentSlot.CHEST).canElytraFly(entity)) {
            return false;
        }
        boolean isPlayer = entity instanceof Player;
        boolean bl = isCreative = isPlayer && ((Player)entity).f_36077_.f_35937_;
        if (!this.useEnergy(stack, this.getEnergyPerUse(true) * time / this.energyUseInterval, isCreative)) {
            return false;
        }
        if (!entity.m_21255_() && isPlayer) {
            ((Player)entity).m_36320_();
        }
        this.propel(entity, this.propelSpeed);
        stack.m_41784_().m_128356_("Time", entity.f_19853_.m_46467_());
        return true;
    }

    public boolean boost(ItemStack stack, LivingEntity entity) {
        return this.boost(stack, entity, this.boostTime);
    }

    public void propel(LivingEntity entity, double speed) {
        if (entity.m_21255_()) {
            Vec3 look = entity.m_20154_();
            Vec3 velocity = entity.m_20184_();
            entity.m_20256_(velocity.m_82520_(look.f_82479_ * speed - velocity.f_82479_ * 0.5, look.f_82480_ * speed - velocity.f_82480_ * 0.5, look.f_82481_ * speed - velocity.f_82481_ * 0.5));
            if (entity.f_19853_.m_5776_()) {
                entity.f_19853_.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void propel(LivingEntity entity) {
        this.propel(entity, this.propelSpeed);
    }

    public void brake(LivingEntity entity, double rate) {
        if (entity.m_21255_()) {
            Vec3 velocity = entity.m_20184_();
            double horzBrake = velocity.m_7096_() * velocity.m_7096_() + velocity.m_7094_() * velocity.m_7094_() > 0.16 ? rate : 1.0;
            double vertBrake = velocity.m_7098_() * velocity.m_7098_() > 0.2 ? rate : 1.0;
            entity.m_20256_(velocity.m_82542_(horzBrake, vertBrake, horzBrake));
        }
    }

    public void brake(LivingEntity entity) {
        this.brake(entity, this.brakeRate);
    }
}

