/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.villager;

import java.util.List;
import jeresources.collection.TradeList;
import jeresources.jei.BlankJEIRecipeCategory;
import jeresources.jei.JEIConfig;
import jeresources.jei.villager.VillagerWrapper;
import jeresources.reference.Resources;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VillagerCategory
extends BlankJEIRecipeCategory<VillagerWrapper> {
    protected static final int X_FIRST_ITEM = 95;
    protected static final int X_ITEM_DISTANCE = 18;
    protected static final int X_ITEM_RESULT = 150;
    protected static final int Y_ITEM_DISTANCE = 22;

    public VillagerCategory() {
        super((IDrawable)JEIConfig.getJeiHelpers().getGuiHelper().createDrawable(Resources.Gui.Jei.TABS, 0, 0, 16, 16));
    }

    @NotNull
    public ResourceLocation getUid() {
        return JEIConfig.VILLAGER;
    }

    @NotNull
    public Component getTitle() {
        return new TranslatableComponent("jer.villager.title");
    }

    @NotNull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.VILLAGER;
    }

    @NotNull
    public Class<? extends VillagerWrapper> getRecipeClass() {
        return VillagerWrapper.class;
    }

    @NotNull
    public RecipeType<VillagerWrapper> getRecipeType() {
        return JEIConfig.VILLAGER_TYPE;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull VillagerWrapper recipeWrapper, @NotNull IFocusGroup focuses) {
        if (recipeWrapper.hasPois()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 50, 19).addItemStacks(recipeWrapper.getPois());
        }
        IFocus focus = focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).findFirst().orElse(null);
        recipeWrapper.setFocus((IFocus<ItemStack>)focus);
        List<Integer> possibleLevels = recipeWrapper.getPossibleLevels((IFocus<ItemStack>)focus);
        int y = 1 + 22 * (6 - possibleLevels.size()) / 2;
        for (int i = 0; i < possibleLevels.size(); ++i) {
            TradeList tradeList = recipeWrapper.getTrades(possibleLevels.get(i)).getFocusedList((IFocus<ItemStack>)focus);
            builder.addSlot(RecipeIngredientRole.INPUT, 96, y + i * 22).addItemStacks(tradeList.getCostAs());
            builder.addSlot(RecipeIngredientRole.INPUT, 114, y + i * 22).addItemStacks(tradeList.getCostBs());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 151, y + i * 22).addItemStacks(tradeList.getResults());
        }
    }
}

