/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import jeresources.api.IWorldGenRegistry;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.Restriction;
import jeresources.entry.WorldGenEntry;
import jeresources.registry.WorldGenRegistry;
import jeresources.util.LogHelper;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;

public class WorldGenRegistryImpl
implements IWorldGenRegistry {
    private static List<WorldGenEntry> registers = new LinkedList<WorldGenEntry>();
    private static List<Tuple<ItemStack, LootDrop[]>> addedDrops = new LinkedList<Tuple<ItemStack, LootDrop[]>>();

    protected WorldGenRegistryImpl() {
    }

    @Override
    public void register(@Nonnull ItemStack block, DistributionBase distribution, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, distribution, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void register(@Nonnull ItemStack block, @Nonnull ItemStack deepSlateBlock, DistributionBase distribution, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, deepSlateBlock, distribution, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void register(@Nonnull ItemStack block, DistributionBase distribution, Restriction restriction, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, distribution, restriction, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void register(@Nonnull ItemStack block, @Nonnull ItemStack deepSlateBlock, DistributionBase distribution, Restriction restriction, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, deepSlateBlock, distribution, restriction, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void register(@Nonnull ItemStack block, DistributionBase distribution, boolean silktouch, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, distribution, silktouch, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void register(@Nonnull ItemStack block, @Nonnull ItemStack deepSlateBlock, DistributionBase distribution, boolean silktouch, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, distribution, silktouch, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void register(@Nonnull ItemStack block, DistributionBase distribution, Restriction restriction, boolean silktouch, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, distribution, restriction, silktouch, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void register(@Nonnull ItemStack block, @Nonnull ItemStack deepSlateBlock, DistributionBase distribution, Restriction restriction, boolean silktouch, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, deepSlateBlock, distribution, restriction, silktouch, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void registerDrops(@Nonnull ItemStack block, LootDrop ... drops) {
        if (drops.length > 0) {
            addedDrops.add((Tuple<ItemStack, LootDrop[]>)new Tuple((Object)block, (Object)drops));
        }
    }

    protected static void commit() {
        for (WorldGenEntry worldGenEntry : registers) {
            WorldGenRegistry.getInstance().registerEntry(worldGenEntry);
        }
        for (Tuple tuple : addedDrops) {
            WorldGenRegistry.getInstance().addDrops((ItemStack)tuple.m_14418_(), (LootDrop[])tuple.m_14419_());
        }
    }
}

