/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.UUIDDeduplicator;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackItemStackRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingBackpackItemEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryInteractionHelper;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class BackpackItem
extends ItemBase
implements IStashStorageItem {
    private final IntSupplier numberOfSlots;
    private final IntSupplier numberOfUpgradeSlots;
    private final Supplier<BackpackBlock> blockSupplier;

    public BackpackItem(IntSupplier numberOfSlots, IntSupplier numberOfUpgradeSlots, Supplier<BackpackBlock> blockSupplier) {
        this(numberOfSlots, numberOfUpgradeSlots, blockSupplier, p -> p);
    }

    public BackpackItem(IntSupplier numberOfSlots, IntSupplier numberOfUpgradeSlots, Supplier<BackpackBlock> blockSupplier, UnaryOperator<Item.Properties> updateProperties) {
        super((Item.Properties)updateProperties.apply(new Item.Properties().m_41487_(1)), SophisticatedBackpacks.ITEM_GROUP);
        this.numberOfSlots = numberOfSlots;
        this.numberOfUpgradeSlots = numberOfUpgradeSlots;
        this.blockSupplier = blockSupplier;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new BackpackItemStackRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        super.m_6787_(group, items);
        if (!this.m_41389_(group) || this != ModItems.BACKPACK.get() || !net.p3pp3rf1y.sophisticatedcore.Config.SERVER.enabledItems.isItemEnabled((Item)this)) {
            return;
        }
        for (DyeColor color : DyeColor.values()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            new BackpackWrapper(stack).setColors(ColorHelper.getColor((float[])color.m_41068_()), ColorHelper.getColor((float[])color.m_41068_()));
            items.add((Object)stack);
        }
        int clothColor = ColorHelper.calculateColor((int)13394234, (int)13394234, List.of(DyeColor.BLUE, DyeColor.YELLOW, DyeColor.LIME));
        int trimColor = ColorHelper.calculateColor((int)6434330, (int)6434330, List.of(DyeColor.BLUE, DyeColor.BLACK));
        ItemStack stack = new ItemStack((ItemLike)this);
        new BackpackWrapper(stack).setColors(clothColor, trimColor);
        items.add((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (flagIn == TooltipFlag.Default.ADVANCED) {
            stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(w -> w.getContentsUuid().ifPresent(uuid -> tooltip.add((Component)new TextComponent("UUID: " + uuid).m_130940_(ChatFormatting.DARK_GRAY))));
        }
        if (!Screen.m_96638_()) {
            tooltip.add((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents", new Object[]{new TranslatableComponent(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift").m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        AtomicReference<Object> ret = new AtomicReference<Object>(null);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.m_91087_();
            if (Screen.m_96638_() || mc.f_91074_ != null && !mc.f_91074_.f_36096_.m_142621_().m_41619_()) {
                ret.set(new BackpackContentsTooltip(stack));
            }
        });
        return Optional.ofNullable(ret.get());
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    private boolean hasEverlastingUpgrade(ItemStack stack) {
        return stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(w -> !w.getUpgradeHandler().getTypeWrappers(EverlastingUpgradeItem.TYPE).isEmpty()).orElse(false);
    }

    @Nullable
    public Entity createEntity(Level world, Entity entity, ItemStack itemstack) {
        if (!(entity instanceof ItemEntity)) {
            return null;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        UUIDDeduplicator.dedupeBackpackItemEntityInArea(itemEntity);
        return this.hasEverlastingUpgrade(itemstack) ? this.createEverlastingBackpack(world, (ItemEntity)entity, itemstack) : null;
    }

    @Nullable
    private EverlastingBackpackItemEntity createEverlastingBackpack(Level world, ItemEntity itemEntity, ItemStack itemstack) {
        EverlastingBackpackItemEntity backpackItemEntity = (EverlastingBackpackItemEntity)((EntityType)ModItems.EVERLASTING_BACKPACK_ITEM_ENTITY.get()).m_20615_(world);
        if (backpackItemEntity != null) {
            backpackItemEntity.m_6034_(itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_());
            backpackItemEntity.m_32045_(itemstack);
            backpackItemEntity.m_32010_(this.getPickupDelay(itemEntity));
            backpackItemEntity.m_32052_(itemEntity.m_32057_());
            backpackItemEntity.m_20256_(itemEntity.m_20184_());
        }
        return backpackItemEntity;
    }

    private int getPickupDelay(ItemEntity itemEntity) {
        Integer result = (Integer)ObfuscationReflectionHelper.getPrivateValue(ItemEntity.class, (Object)itemEntity, (String)"f_31986_");
        if (result == null) {
            SophisticatedBackpacks.LOGGER.error("Reflection get of pickupDelay (pickupDelay) from ItemEntity returned null");
            return 20;
        }
        return result;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPlaceContext blockItemUseContext;
        Player player = context.m_43723_();
        if (player == null || !player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (InventoryInteractionHelper.tryInventoryInteraction(context)) {
            return InteractionResult.SUCCESS;
        }
        Direction direction = player.m_6350_().m_122424_();
        InteractionResult result = this.tryPlace(player, direction, blockItemUseContext = new BlockPlaceContext(context));
        return result == InteractionResult.PASS ? super.m_6225_(context) : result;
    }

    public InteractionResult tryPlace(@Nullable Player player, Direction direction, BlockPlaceContext blockItemUseContext) {
        if (!blockItemUseContext.m_7059_()) {
            return InteractionResult.FAIL;
        }
        Level world = blockItemUseContext.m_43725_();
        BlockPos pos = blockItemUseContext.m_8083_();
        FluidState fluidstate = blockItemUseContext.m_43725_().m_6425_(pos);
        BlockState placementState = (BlockState)((BlockState)this.blockSupplier.get().m_49966_().m_61124_((Property)BackpackBlock.FACING, (Comparable)direction)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        if (!this.canPlace(blockItemUseContext, placementState)) {
            return InteractionResult.FAIL;
        }
        if (world.m_46597_(pos, placementState)) {
            ItemStack backpack = blockItemUseContext.m_43722_();
            WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, BackpackBlockEntity.class).ifPresent(te -> {
                te.setBackpack(this.getBackpackCopy(player, backpack));
                te.refreshRenderState();
                te.tryToAddToController();
            });
            if (!world.f_46443_) {
                BackpackItem.stopBackpackSounds(backpack, world, pos);
            }
            SoundType soundtype = placementState.getSoundType((LevelReader)world, pos, (Entity)player);
            world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            if (player == null || !player.m_7500_()) {
                backpack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static void stopBackpackSounds(ItemStack backpack, Level world, BlockPos pos) {
        backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> wrapper.getContentsUuid().ifPresent(uuid -> ServerStorageSoundHandler.stopPlayingDisc((ServerLevel)((ServerLevel)world), (Vec3)Vec3.m_82512_((Vec3i)pos), (UUID)uuid)));
    }

    private ItemStack getBackpackCopy(@Nullable Player player, ItemStack backpack) {
        if (player == null || !player.m_7500_()) {
            return backpack.m_41777_();
        }
        return backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(IBackpackWrapper::cloneBackpack).orElse(new ItemStack((ItemLike)ModItems.BACKPACK.get()));
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player playerentity = context.m_43723_();
        CollisionContext iselectioncontext = playerentity == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)playerentity);
        return state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) && context.m_43725_().m_45752_(state, context.m_8083_(), iselectioncontext);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            String handlerName = hand == InteractionHand.MAIN_HAND ? "main" : "offhand";
            int slot = hand == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 0;
            BackpackContext.Item context = new BackpackContext.Item(handlerName, slot);
            NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, context), stack.m_41786_()), context::toBuffer);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){
            private IStorageWrapper wrapper = null;

            @Nonnull
            public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                if (stack.m_41613_() > 1) {
                    return LazyOptional.empty();
                }
                this.initWrapper();
                if (cap == CapabilityBackpackWrapper.getCapabilityInstance()) {
                    return LazyOptional.of(() -> this.wrapper).cast();
                }
                if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return LazyOptional.of(() -> this.wrapper.getInventoryForInputOutput()).cast();
                }
                if (cap == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY && Boolean.TRUE.equals(Config.SERVER.itemFluidHandlerEnabled.get())) {
                    return this.wrapper.getFluidHandler().map(handler -> LazyOptional.of(() -> handler).cast()).orElseGet(LazyOptional::empty);
                }
                if (cap == CapabilityEnergy.ENERGY) {
                    return this.wrapper.getEnergyStorage().map(storage -> LazyOptional.of(() -> storage).cast()).orElseGet(LazyOptional::empty);
                }
                return LazyOptional.empty();
            }

            private void initWrapper() {
                if (this.wrapper == null) {
                    this.wrapper = new BackpackWrapper(stack);
                }
            }
        };
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (level.f_46443_ || player.m_5833_() || player.m_21224_() || Boolean.FALSE.equals(Config.SERVER.nerfsConfig.onlyWornBackpackTriggersUpgrades.get())) {
            return;
        }
        stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> wrapper.getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick((LivingEntity)player, player.f_19853_, player.m_142538_())));
        super.onArmorTick(stack, level, player);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        Player player;
        if (level.f_46443_ || !(entityIn instanceof Player) || (player = (Player)entityIn).m_5833_() || player.m_21224_() || ((Boolean)Config.SERVER.nerfsConfig.onlyWornBackpackTriggersUpgrades.get()).booleanValue() && itemSlot > -1) {
            return;
        }
        stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> wrapper.getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick((LivingEntity)player, player.f_19853_, player.m_142538_())));
        super.m_6883_(stack, level, entityIn, itemSlot, isSelected);
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots.getAsInt();
    }

    public int getNumberOfUpgradeSlots() {
        return this.numberOfUpgradeSlots.getAsInt();
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        BackpackContainer backpackContainer;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        return !(abstractContainerMenu instanceof BackpackContainer && (backpackContainer = (BackpackContainer)abstractContainerMenu).getVisibleStorageItem().map(visibleStorageItem -> visibleStorageItem == item).orElse(false) != false);
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return stack.m_41720_() == ModItems.GOLD_BACKPACK.get();
    }

    public Optional<TooltipComponent> getInventoryTooltip(ItemStack stack) {
        return Optional.of(new BackpackContentsTooltip(stack));
    }

    public ItemStack stash(ItemStack storageStack, ItemStack stack) {
        return storageStack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> wrapper.getInventoryForUpgradeProcessing().insertItem(stack, false)).orElse(stack);
    }

    public boolean isItemStashable(ItemStack storageStack, ItemStack stack) {
        return storageStack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> wrapper.getInventoryForUpgradeProcessing().insertItem(stack, true).m_41613_() != stack.m_41613_()).orElse(false);
    }

    public boolean m_142207_(ItemStack storageStack, Slot slot, ClickAction action, Player player) {
        if (storageStack.m_41613_() > 1 || !slot.m_8010_(player) || action != ClickAction.SECONDARY) {
            return super.m_142207_(storageStack, slot, action, player);
        }
        ItemStack stackToStash = slot.m_7993_();
        ItemStack stashResult = this.stash(storageStack, stackToStash);
        if (stashResult.m_41613_() != stackToStash.m_41613_()) {
            slot.m_5852_(stashResult);
            slot.m_142406_(player, stashResult);
            return true;
        }
        return super.m_142207_(storageStack, slot, action, player);
    }

    public boolean m_142305_(ItemStack storageStack, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess carriedAccess) {
        if (storageStack.m_41613_() > 1 || !slot.m_5857_(storageStack) || action != ClickAction.SECONDARY) {
            return super.m_142305_(storageStack, otherStack, slot, action, player, carriedAccess);
        }
        ItemStack result = this.stash(storageStack, otherStack);
        if (result.m_41613_() != otherStack.m_41613_()) {
            carriedAccess.m_142104_(result);
            slot.m_5852_(storageStack);
            return true;
        }
        return super.m_142305_(storageStack, otherStack, slot, action, player, carriedAccess);
    }

    public boolean m_142095_() {
        return (Boolean)Config.SERVER.canBePlacedInContainerItems.get();
    }

    public record BackpackContentsTooltip(ItemStack backpack) implements TooltipComponent
    {
        public ItemStack getBackpack() {
            return this.backpack;
        }
    }
}

