/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import com.mojang.math.Vector3f;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackShapes;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeRenderRegistry;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class BackpackBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty LEFT_TANK = BooleanProperty.m_61465_((String)"left_tank");
    public static final BooleanProperty RIGHT_TANK = BooleanProperty.m_61465_((String)"right_tank");
    public static final BooleanProperty BATTERY = BooleanProperty.m_61465_((String)"battery");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final int BEDROCK_RESISTANCE = 3600000;

    public BackpackBlock() {
        this(0.8f);
    }

    public BackpackBlock(float explosionResistance) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60955_().m_60913_(0.8f, explosionResistance).m_60918_(SoundType.f_56745_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_TANK, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_TANK, (Comparable)Boolean.valueOf(false)));
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.DESTROY;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BackpackBlockEntity.class).map(t -> InventoryHelper.getAnalogOutputSignal((ITrackedContentsItemHandler)t.getBackpackWrapper().getInventoryForInputOutput())).orElse(0);
    }

    public FluidState m_5888_(BlockState state) {
        return Boolean.TRUE.equals(state.m_61143_((Property)BlockStateProperties.f_61362_)) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (Boolean.TRUE.equals(stateIn.m_61143_((Property)BlockStateProperties.f_61362_))) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BlockStateProperties.f_61362_, LEFT_TANK, RIGHT_TANK, BATTERY});
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        if (this.hasEverlastingUpgrade(world, pos)) {
            return 3600000.0f;
        }
        return super.getExplosionResistance(state, world, pos, explosion);
    }

    private boolean hasEverlastingUpgrade(BlockGetter world, BlockPos pos) {
        return WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, BackpackBlockEntity.class).map(te -> !te.getBackpackWrapper().getUpgradeHandler().getTypeWrappers(EverlastingUpgradeItem.TYPE).isEmpty()).orElse(false);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BackpackShapes.getShape(this, (Direction)state.m_61143_((Property)FACING), (Boolean)state.m_61143_((Property)LEFT_TANK), (Boolean)state.m_61143_((Property)RIGHT_TANK), (Boolean)state.m_61143_((Property)BATTERY));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BackpackBlockEntity(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (player.m_6144_() && heldItem.m_41619_()) {
            BackpackBlock.putInPlayersHandAndRemove(state, world, pos, player, hand);
            return InteractionResult.SUCCESS;
        }
        if (!heldItem.m_41619_() && heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, BackpackBlockEntity.class).flatMap(te -> te.getBackpackWrapper().getFluidHandler()).ifPresent(backpackFluidHandler -> player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(playerInventory -> {
                FluidActionResult resultOfEmptying = FluidUtil.tryEmptyContainerAndStow((ItemStack)heldItem, (IFluidHandler)backpackFluidHandler, (IItemHandler)playerInventory, (int)1000, (Player)player, (boolean)true);
                if (resultOfEmptying.isSuccess()) {
                    player.m_21008_(hand, resultOfEmptying.getResult());
                } else {
                    FluidActionResult resultOfFilling = FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)backpackFluidHandler, (IItemHandler)playerInventory, (int)1000, (Player)player, (boolean)true);
                    if (resultOfFilling.isSuccess()) {
                        player.m_21008_(hand, resultOfFilling.getResult());
                    }
                }
            }));
            return InteractionResult.SUCCESS;
        }
        BackpackContext.Block backpackContext = new BackpackContext.Block(pos);
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), this.getBackpackDisplayName(world, pos)), backpackContext::toBuffer);
        return InteractionResult.SUCCESS;
    }

    private Component getBackpackDisplayName(Level world, BlockPos pos) {
        Component defaultDisplayName = new ItemStack((ItemLike)ModItems.BACKPACK.get()).m_41786_();
        return WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, BackpackBlockEntity.class).map(te -> te.getBackpackWrapper().getBackpack().m_41786_()).orElse(defaultDisplayName);
    }

    private static void putInPlayersHandAndRemove(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack backpack = WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, BackpackBlockEntity.class).map(te -> te.getBackpackWrapper().getBackpack()).orElse(ItemStack.f_41583_);
        BackpackBlock.stopBackpackSounds(backpack, world, pos);
        player.m_21008_(hand, backpack.m_41777_());
        player.m_36335_().m_41524_(backpack.m_41720_(), 5);
        world.m_7471_(pos, false);
        SoundType soundType = state.m_60827_();
        world.m_5594_(null, pos, soundType.m_56775_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BackpackBlockEntity.class).ifPresent(IControllableStorage::removeFromController);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BackpackBlockEntity.class).ifPresent(IControllableStorage::removeFromController);
    }

    private static void stopBackpackSounds(ItemStack backpack, Level world, BlockPos pos) {
        backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> wrapper.getContentsUuid().ifPresent(uuid -> ServerStorageSoundHandler.stopPlayingDisc((ServerLevel)((ServerLevel)world), (Vec3)Vec3.m_82512_((Vec3i)pos), (UUID)uuid)));
    }

    public static void playerInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        Level world = player.f_19853_;
        BlockPos pos = event.getPos();
        if (!player.m_6144_() || !BackpackBlock.hasEmptyMainHandAndSomethingInOffhand(player) || BackpackBlock.didntInteractWithBackpack(event)) {
            return;
        }
        if (world.f_46443_) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof BackpackBlock)) {
            return;
        }
        BackpackBlock.putInPlayersHandAndRemove(state, world, pos, player, player.m_21205_().m_41619_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    private static boolean didntInteractWithBackpack(PlayerInteractEvent.RightClickBlock event) {
        return !(event.getWorld().m_8055_(event.getPos()).m_60734_() instanceof BackpackBlock);
    }

    private static boolean hasEmptyMainHandAndSomethingInOffhand(Player player) {
        return player.m_21205_().m_41619_() && !player.m_21206_().m_41619_();
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(state, world, pos, entity);
        if (!world.f_46443_ && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, BackpackBlockEntity.class).ifPresent(te -> this.tryToPickup(world, itemEntity, te.getBackpackWrapper()));
        }
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        if (this.hasEverlastingUpgrade(world, pos)) {
            return false;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    private void tryToPickup(Level world, ItemEntity itemEntity, IStorageWrapper w) {
        ItemStack remainingStack = itemEntity.m_32055_().m_41777_();
        remainingStack = InventoryHelper.runPickupOnPickupResponseUpgrades((Level)world, (UpgradeHandler)w.getUpgradeHandler(), (ItemStack)remainingStack, (boolean)false);
        if (remainingStack.m_41613_() < itemEntity.m_32055_().m_41613_()) {
            itemEntity.m_32045_(remainingStack);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.f_46443_ ? BackpackBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)ModBlocks.BACKPACK_TILE_TYPE.get(), (level, blockPos, blockState, backpackBlockEntity) -> BackpackBlockEntity.serverTick(level, blockPos, backpackBlockEntity)) : null;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> typePassedIn, BlockEntityType<E> typeExpected, BlockEntityTicker<? super E> blockEntityTicker) {
        return typeExpected == typePassedIn ? blockEntityTicker : null;
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BackpackBlockEntity.class).ifPresent(te -> {
            RenderInfo renderInfo = te.getBackpackWrapper().getRenderInfo();
            BackpackBlock.renderUpgrades(level, rand, pos, (Direction)state.m_61143_((Property)FACING), renderInfo);
        });
    }

    private static void renderUpgrades(Level level, Random rand, BlockPos pos, Direction facing, RenderInfo renderInfo) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        renderInfo.getUpgradeRenderData().forEach((type, data) -> UpgradeRenderRegistry.getUpgradeRenderer((UpgradeRenderDataType)type).ifPresent(renderer -> BackpackBlock.renderUpgrade(renderer, level, rand, pos, facing, type, data)));
    }

    private static Vector3f getBackpackMiddleFacePoint(BlockPos pos, Direction facing, Vector3f vector) {
        Vector3f point = vector.m_122281_();
        point.m_122272_(0.0f, 0.0f, 0.41f);
        point.m_122251_(Vector3f.f_122224_.m_122240_(facing.m_122435_()));
        point.m_122272_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_(), (float)pos.m_123343_() + 0.5f);
        return point;
    }

    private static <T extends IUpgradeRenderData> void renderUpgrade(IUpgradeRenderer<T> renderer, Level level, Random rand, BlockPos pos, Direction facing, UpgradeRenderDataType<?> type, IUpgradeRenderData data) {
        type.cast(data).ifPresent(renderData -> renderer.render(level, rand, vector -> BackpackBlock.getBackpackMiddleFacePoint(pos, facing, vector), renderData));
    }
}

